package zio.aws.devicefarm.model
import zio.aws.devicefarm.model.primitives.{
  HostAddress,
  Message,
  ClientId,
  DateTime,
  SkipAppResign,
  AmazonResourceName,
  Name
}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import java.time.Instant
import scala.jdk.CollectionConverters.*
final case class RemoteAccessSession(
    arn: Option[AmazonResourceName] = None,
    name: Option[Name] = None,
    created: Option[DateTime] = None,
    status: Option[zio.aws.devicefarm.model.ExecutionStatus] = None,
    result: Option[zio.aws.devicefarm.model.ExecutionResult] = None,
    message: Option[Message] = None,
    started: Option[DateTime] = None,
    stopped: Option[DateTime] = None,
    device: Option[zio.aws.devicefarm.model.Device] = None,
    instanceArn: Option[AmazonResourceName] = None,
    remoteDebugEnabled: Option[Boolean] = None,
    remoteRecordEnabled: Option[Boolean] = None,
    remoteRecordAppArn: Option[AmazonResourceName] = None,
    hostAddress: Option[HostAddress] = None,
    clientId: Option[ClientId] = None,
    billingMethod: Option[zio.aws.devicefarm.model.BillingMethod] = None,
    deviceMinutes: Option[zio.aws.devicefarm.model.DeviceMinutes] = None,
    endpoint: Option[String] = None,
    deviceUdid: Option[String] = None,
    interactionMode: Option[zio.aws.devicefarm.model.InteractionMode] = None,
    skipAppResign: Option[SkipAppResign] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.devicefarm.model.RemoteAccessSession = {
    import RemoteAccessSession.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.devicefarm.model.RemoteAccessSession
      .builder()
      .optionallyWith(
        arn.map(value => AmazonResourceName.unwrap(value): java.lang.String)
      )(_.arn)
      .optionallyWith(name.map(value => Name.unwrap(value): java.lang.String))(
        _.name
      )
      .optionallyWith(created.map(value => DateTime.unwrap(value): Instant))(
        _.created
      )
      .optionallyWith(status.map(value => value.unwrap))(_.status)
      .optionallyWith(result.map(value => value.unwrap))(_.result)
      .optionallyWith(
        message.map(value => Message.unwrap(value): java.lang.String)
      )(_.message)
      .optionallyWith(started.map(value => DateTime.unwrap(value): Instant))(
        _.started
      )
      .optionallyWith(stopped.map(value => DateTime.unwrap(value): Instant))(
        _.stopped
      )
      .optionallyWith(device.map(value => value.buildAwsValue()))(_.device)
      .optionallyWith(
        instanceArn.map(value =>
          AmazonResourceName.unwrap(value): java.lang.String
        )
      )(_.instanceArn)
      .optionallyWith(
        remoteDebugEnabled.map(value => value: java.lang.Boolean)
      )(_.remoteDebugEnabled)
      .optionallyWith(
        remoteRecordEnabled.map(value => value: java.lang.Boolean)
      )(_.remoteRecordEnabled)
      .optionallyWith(
        remoteRecordAppArn.map(value =>
          AmazonResourceName.unwrap(value): java.lang.String
        )
      )(_.remoteRecordAppArn)
      .optionallyWith(
        hostAddress.map(value => HostAddress.unwrap(value): java.lang.String)
      )(_.hostAddress)
      .optionallyWith(
        clientId.map(value => ClientId.unwrap(value): java.lang.String)
      )(_.clientId)
      .optionallyWith(billingMethod.map(value => value.unwrap))(_.billingMethod)
      .optionallyWith(deviceMinutes.map(value => value.buildAwsValue()))(
        _.deviceMinutes
      )
      .optionallyWith(endpoint.map(value => value: java.lang.String))(
        _.endpoint
      )
      .optionallyWith(deviceUdid.map(value => value: java.lang.String))(
        _.deviceUdid
      )
      .optionallyWith(interactionMode.map(value => value.unwrap))(
        _.interactionMode
      )
      .optionallyWith(
        skipAppResign.map(value =>
          SkipAppResign.unwrap(value): java.lang.Boolean
        )
      )(_.skipAppResign)
      .build()
  }
  def asReadOnly: zio.aws.devicefarm.model.RemoteAccessSession.ReadOnly =
    zio.aws.devicefarm.model.RemoteAccessSession.wrap(buildAwsValue())
}
object RemoteAccessSession {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.devicefarm.model.RemoteAccessSession
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.devicefarm.model.RemoteAccessSession =
      zio.aws.devicefarm.model.RemoteAccessSession(
        arn.map(value => value),
        name.map(value => value),
        created.map(value => value),
        status.map(value => value),
        result.map(value => value),
        message.map(value => value),
        started.map(value => value),
        stopped.map(value => value),
        device.map(value => value.asEditable),
        instanceArn.map(value => value),
        remoteDebugEnabled.map(value => value),
        remoteRecordEnabled.map(value => value),
        remoteRecordAppArn.map(value => value),
        hostAddress.map(value => value),
        clientId.map(value => value),
        billingMethod.map(value => value),
        deviceMinutes.map(value => value.asEditable),
        endpoint.map(value => value),
        deviceUdid.map(value => value),
        interactionMode.map(value => value),
        skipAppResign.map(value => value)
      )
    def arn: Option[AmazonResourceName]
    def name: Option[Name]
    def created: Option[DateTime]
    def status: Option[zio.aws.devicefarm.model.ExecutionStatus]
    def result: Option[zio.aws.devicefarm.model.ExecutionResult]
    def message: Option[Message]
    def started: Option[DateTime]
    def stopped: Option[DateTime]
    def device: Option[zio.aws.devicefarm.model.Device.ReadOnly]
    def instanceArn: Option[AmazonResourceName]
    def remoteDebugEnabled: Option[Boolean]
    def remoteRecordEnabled: Option[Boolean]
    def remoteRecordAppArn: Option[AmazonResourceName]
    def hostAddress: Option[HostAddress]
    def clientId: Option[ClientId]
    def billingMethod: Option[zio.aws.devicefarm.model.BillingMethod]
    def deviceMinutes: Option[zio.aws.devicefarm.model.DeviceMinutes.ReadOnly]
    def endpoint: Option[String]
    def deviceUdid: Option[String]
    def interactionMode: Option[zio.aws.devicefarm.model.InteractionMode]
    def skipAppResign: Option[SkipAppResign]
    def getArn: ZIO[Any, AwsError, AmazonResourceName] =
      AwsError.unwrapOptionField("arn", arn)
    def getName: ZIO[Any, AwsError, Name] =
      AwsError.unwrapOptionField("name", name)
    def getCreated: ZIO[Any, AwsError, DateTime] =
      AwsError.unwrapOptionField("created", created)
    def getStatus
        : ZIO[Any, AwsError, zio.aws.devicefarm.model.ExecutionStatus] =
      AwsError.unwrapOptionField("status", status)
    def getResult
        : ZIO[Any, AwsError, zio.aws.devicefarm.model.ExecutionResult] =
      AwsError.unwrapOptionField("result", result)
    def getMessage: ZIO[Any, AwsError, Message] =
      AwsError.unwrapOptionField("message", message)
    def getStarted: ZIO[Any, AwsError, DateTime] =
      AwsError.unwrapOptionField("started", started)
    def getStopped: ZIO[Any, AwsError, DateTime] =
      AwsError.unwrapOptionField("stopped", stopped)
    def getDevice
        : ZIO[Any, AwsError, zio.aws.devicefarm.model.Device.ReadOnly] =
      AwsError.unwrapOptionField("device", device)
    def getInstanceArn: ZIO[Any, AwsError, AmazonResourceName] =
      AwsError.unwrapOptionField("instanceArn", instanceArn)
    def getRemoteDebugEnabled: ZIO[Any, AwsError, Boolean] =
      AwsError.unwrapOptionField("remoteDebugEnabled", remoteDebugEnabled)
    def getRemoteRecordEnabled: ZIO[Any, AwsError, Boolean] =
      AwsError.unwrapOptionField("remoteRecordEnabled", remoteRecordEnabled)
    def getRemoteRecordAppArn: ZIO[Any, AwsError, AmazonResourceName] =
      AwsError.unwrapOptionField("remoteRecordAppArn", remoteRecordAppArn)
    def getHostAddress: ZIO[Any, AwsError, HostAddress] =
      AwsError.unwrapOptionField("hostAddress", hostAddress)
    def getClientId: ZIO[Any, AwsError, ClientId] =
      AwsError.unwrapOptionField("clientId", clientId)
    def getBillingMethod
        : ZIO[Any, AwsError, zio.aws.devicefarm.model.BillingMethod] =
      AwsError.unwrapOptionField("billingMethod", billingMethod)
    def getDeviceMinutes
        : ZIO[Any, AwsError, zio.aws.devicefarm.model.DeviceMinutes.ReadOnly] =
      AwsError.unwrapOptionField("deviceMinutes", deviceMinutes)
    def getEndpoint: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("endpoint", endpoint)
    def getDeviceUdid: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("deviceUdid", deviceUdid)
    def getInteractionMode
        : ZIO[Any, AwsError, zio.aws.devicefarm.model.InteractionMode] =
      AwsError.unwrapOptionField("interactionMode", interactionMode)
    def getSkipAppResign: ZIO[Any, AwsError, SkipAppResign] =
      AwsError.unwrapOptionField("skipAppResign", skipAppResign)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.devicefarm.model.RemoteAccessSession
  ) extends zio.aws.devicefarm.model.RemoteAccessSession.ReadOnly {
    override val arn: Option[AmazonResourceName] = scala
      .Option(impl.arn())
      .map(value =>
        zio.aws.devicefarm.model.primitives.AmazonResourceName(value)
      )
    override val name: Option[Name] = scala
      .Option(impl.name())
      .map(value => zio.aws.devicefarm.model.primitives.Name(value))
    override val created: Option[DateTime] = scala
      .Option(impl.created())
      .map(value => zio.aws.devicefarm.model.primitives.DateTime(value))
    override val status: Option[zio.aws.devicefarm.model.ExecutionStatus] =
      scala
        .Option(impl.status())
        .map(value => zio.aws.devicefarm.model.ExecutionStatus.wrap(value))
    override val result: Option[zio.aws.devicefarm.model.ExecutionResult] =
      scala
        .Option(impl.result())
        .map(value => zio.aws.devicefarm.model.ExecutionResult.wrap(value))
    override val message: Option[Message] = scala
      .Option(impl.message())
      .map(value => zio.aws.devicefarm.model.primitives.Message(value))
    override val started: Option[DateTime] = scala
      .Option(impl.started())
      .map(value => zio.aws.devicefarm.model.primitives.DateTime(value))
    override val stopped: Option[DateTime] = scala
      .Option(impl.stopped())
      .map(value => zio.aws.devicefarm.model.primitives.DateTime(value))
    override val device: Option[zio.aws.devicefarm.model.Device.ReadOnly] =
      scala
        .Option(impl.device())
        .map(value => zio.aws.devicefarm.model.Device.wrap(value))
    override val instanceArn: Option[AmazonResourceName] = scala
      .Option(impl.instanceArn())
      .map(value =>
        zio.aws.devicefarm.model.primitives.AmazonResourceName(value)
      )
    override val remoteDebugEnabled: Option[Boolean] =
      scala.Option(impl.remoteDebugEnabled()).map(value => value: Boolean)
    override val remoteRecordEnabled: Option[Boolean] =
      scala.Option(impl.remoteRecordEnabled()).map(value => value: Boolean)
    override val remoteRecordAppArn: Option[AmazonResourceName] = scala
      .Option(impl.remoteRecordAppArn())
      .map(value =>
        zio.aws.devicefarm.model.primitives.AmazonResourceName(value)
      )
    override val hostAddress: Option[HostAddress] = scala
      .Option(impl.hostAddress())
      .map(value => zio.aws.devicefarm.model.primitives.HostAddress(value))
    override val clientId: Option[ClientId] = scala
      .Option(impl.clientId())
      .map(value => zio.aws.devicefarm.model.primitives.ClientId(value))
    override val billingMethod: Option[zio.aws.devicefarm.model.BillingMethod] =
      scala
        .Option(impl.billingMethod())
        .map(value => zio.aws.devicefarm.model.BillingMethod.wrap(value))
    override val deviceMinutes
        : Option[zio.aws.devicefarm.model.DeviceMinutes.ReadOnly] = scala
      .Option(impl.deviceMinutes())
      .map(value => zio.aws.devicefarm.model.DeviceMinutes.wrap(value))
    override val endpoint: Option[String] =
      scala.Option(impl.endpoint()).map(value => value: String)
    override val deviceUdid: Option[String] =
      scala.Option(impl.deviceUdid()).map(value => value: String)
    override val interactionMode
        : Option[zio.aws.devicefarm.model.InteractionMode] = scala
      .Option(impl.interactionMode())
      .map(value => zio.aws.devicefarm.model.InteractionMode.wrap(value))
    override val skipAppResign: Option[SkipAppResign] = scala
      .Option(impl.skipAppResign())
      .map(value => zio.aws.devicefarm.model.primitives.SkipAppResign(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.devicefarm.model.RemoteAccessSession
  ): zio.aws.devicefarm.model.RemoteAccessSession.ReadOnly = new Wrapper(impl)
}
