package zio.aws.devicefarm.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters.*
final case class RenewOfferingResponse(
    offeringTransaction: Option[zio.aws.devicefarm.model.OfferingTransaction] =
      None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.devicefarm.model.RenewOfferingResponse = {
    import RenewOfferingResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.devicefarm.model.RenewOfferingResponse
      .builder()
      .optionallyWith(offeringTransaction.map(value => value.buildAwsValue()))(
        _.offeringTransaction
      )
      .build()
  }
  def asReadOnly: zio.aws.devicefarm.model.RenewOfferingResponse.ReadOnly =
    zio.aws.devicefarm.model.RenewOfferingResponse.wrap(buildAwsValue())
}
object RenewOfferingResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.devicefarm.model.RenewOfferingResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.devicefarm.model.RenewOfferingResponse =
      zio.aws.devicefarm.model.RenewOfferingResponse(
        offeringTransaction.map(value => value.asEditable)
      )
    def offeringTransaction
        : Option[zio.aws.devicefarm.model.OfferingTransaction.ReadOnly]
    def getOfferingTransaction: ZIO[
      Any,
      AwsError,
      zio.aws.devicefarm.model.OfferingTransaction.ReadOnly
    ] = AwsError.unwrapOptionField("offeringTransaction", offeringTransaction)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.devicefarm.model.RenewOfferingResponse
  ) extends zio.aws.devicefarm.model.RenewOfferingResponse.ReadOnly {
    override val offeringTransaction
        : Option[zio.aws.devicefarm.model.OfferingTransaction.ReadOnly] = scala
      .Option(impl.offeringTransaction())
      .map(value => zio.aws.devicefarm.model.OfferingTransaction.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.devicefarm.model.RenewOfferingResponse
  ): zio.aws.devicefarm.model.RenewOfferingResponse.ReadOnly = new Wrapper(impl)
}
