package zio.aws.devicefarm.model
import zio.aws.devicefarm.model.primitives.Integer
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters.*
final case class Resolution(
    width: Option[Integer] = None,
    height: Option[Integer] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.devicefarm.model.Resolution = {
    import Resolution.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.devicefarm.model.Resolution
      .builder()
      .optionallyWith(
        width.map(value => Integer.unwrap(value): java.lang.Integer)
      )(_.width)
      .optionallyWith(
        height.map(value => Integer.unwrap(value): java.lang.Integer)
      )(_.height)
      .build()
  }
  def asReadOnly: zio.aws.devicefarm.model.Resolution.ReadOnly =
    zio.aws.devicefarm.model.Resolution.wrap(buildAwsValue())
}
object Resolution {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.devicefarm.model.Resolution
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.devicefarm.model.Resolution =
      zio.aws.devicefarm.model
        .Resolution(width.map(value => value), height.map(value => value))
    def width: Option[Integer]
    def height: Option[Integer]
    def getWidth: ZIO[Any, AwsError, Integer] =
      AwsError.unwrapOptionField("width", width)
    def getHeight: ZIO[Any, AwsError, Integer] =
      AwsError.unwrapOptionField("height", height)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.devicefarm.model.Resolution
  ) extends zio.aws.devicefarm.model.Resolution.ReadOnly {
    override val width: Option[Integer] = scala
      .Option(impl.width())
      .map(value => zio.aws.devicefarm.model.primitives.Integer(value))
    override val height: Option[Integer] = scala
      .Option(impl.height())
      .map(value => zio.aws.devicefarm.model.primitives.Integer(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.devicefarm.model.Resolution
  ): zio.aws.devicefarm.model.Resolution.ReadOnly = new Wrapper(impl)
}
