package zio.aws.devicefarm.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters.*
final case class Rule(
    attribute: Option[zio.aws.devicefarm.model.DeviceAttribute] = None,
    operator: Option[zio.aws.devicefarm.model.RuleOperator] = None,
    value: Option[String] = None
) {
  def buildAwsValue(): software.amazon.awssdk.services.devicefarm.model.Rule = {
    import Rule.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.devicefarm.model.Rule
      .builder()
      .optionallyWith(attribute.map(value => value.unwrap))(_.attribute)
      .optionallyWith(operator.map(value => value.unwrap))(_.operator)
      .optionallyWith(value.map(value => value: java.lang.String))(_.value)
      .build()
  }
  def asReadOnly: zio.aws.devicefarm.model.Rule.ReadOnly =
    zio.aws.devicefarm.model.Rule.wrap(buildAwsValue())
}
object Rule {
  private lazy val zioAwsBuilderHelper
      : BuilderHelper[software.amazon.awssdk.services.devicefarm.model.Rule] =
    BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.devicefarm.model.Rule =
      zio.aws.devicefarm.model.Rule(
        attribute.map(value => value),
        operator.map(value => value),
        value.map(value => value)
      )
    def attribute: Option[zio.aws.devicefarm.model.DeviceAttribute]
    def operator: Option[zio.aws.devicefarm.model.RuleOperator]
    def value: Option[String]
    def getAttribute
        : ZIO[Any, AwsError, zio.aws.devicefarm.model.DeviceAttribute] =
      AwsError.unwrapOptionField("attribute", attribute)
    def getOperator: ZIO[Any, AwsError, zio.aws.devicefarm.model.RuleOperator] =
      AwsError.unwrapOptionField("operator", operator)
    def getValue: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("value", value)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.devicefarm.model.Rule
  ) extends zio.aws.devicefarm.model.Rule.ReadOnly {
    override val attribute: Option[zio.aws.devicefarm.model.DeviceAttribute] =
      scala
        .Option(impl.attribute())
        .map(value => zio.aws.devicefarm.model.DeviceAttribute.wrap(value))
    override val operator: Option[zio.aws.devicefarm.model.RuleOperator] = scala
      .Option(impl.operator())
      .map(value => zio.aws.devicefarm.model.RuleOperator.wrap(value))
    override val value: Option[String] =
      scala.Option(impl.value()).map(value => value: String)
  }
  def wrap(
      impl: software.amazon.awssdk.services.devicefarm.model.Rule
  ): zio.aws.devicefarm.model.Rule.ReadOnly = new Wrapper(impl)
}
