package zio.aws.devicefarm.model
import zio.aws.devicefarm.model.primitives.{
  JobTimeoutMinutes,
  Message,
  DateTime,
  SkipAppResign,
  Integer,
  AmazonResourceName,
  Name
}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import java.time.Instant
import scala.jdk.CollectionConverters.*
final case class Run(
    arn: Option[AmazonResourceName] = None,
    name: Option[Name] = None,
    `type`: Option[zio.aws.devicefarm.model.TestType] = None,
    platform: Option[zio.aws.devicefarm.model.DevicePlatform] = None,
    created: Option[DateTime] = None,
    status: Option[zio.aws.devicefarm.model.ExecutionStatus] = None,
    result: Option[zio.aws.devicefarm.model.ExecutionResult] = None,
    started: Option[DateTime] = None,
    stopped: Option[DateTime] = None,
    counters: Option[zio.aws.devicefarm.model.Counters] = None,
    message: Option[Message] = None,
    totalJobs: Option[Integer] = None,
    completedJobs: Option[Integer] = None,
    billingMethod: Option[zio.aws.devicefarm.model.BillingMethod] = None,
    deviceMinutes: Option[zio.aws.devicefarm.model.DeviceMinutes] = None,
    networkProfile: Option[zio.aws.devicefarm.model.NetworkProfile] = None,
    parsingResultUrl: Option[String] = None,
    resultCode: Option[zio.aws.devicefarm.model.ExecutionResultCode] = None,
    seed: Option[Integer] = None,
    appUpload: Option[AmazonResourceName] = None,
    eventCount: Option[Integer] = None,
    jobTimeoutMinutes: Option[JobTimeoutMinutes] = None,
    devicePoolArn: Option[AmazonResourceName] = None,
    locale: Option[String] = None,
    radios: Option[zio.aws.devicefarm.model.Radios] = None,
    location: Option[zio.aws.devicefarm.model.Location] = None,
    customerArtifactPaths: Option[
      zio.aws.devicefarm.model.CustomerArtifactPaths
    ] = None,
    webUrl: Option[String] = None,
    skipAppResign: Option[SkipAppResign] = None,
    testSpecArn: Option[AmazonResourceName] = None,
    deviceSelectionResult: Option[
      zio.aws.devicefarm.model.DeviceSelectionResult
    ] = None
) {
  def buildAwsValue(): software.amazon.awssdk.services.devicefarm.model.Run = {
    import Run.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.devicefarm.model.Run
      .builder()
      .optionallyWith(
        arn.map(value => AmazonResourceName.unwrap(value): java.lang.String)
      )(_.arn)
      .optionallyWith(name.map(value => Name.unwrap(value): java.lang.String))(
        _.name
      )
      .optionallyWith(`type`.map(value => value.unwrap))(_.`type`)
      .optionallyWith(platform.map(value => value.unwrap))(_.platform)
      .optionallyWith(created.map(value => DateTime.unwrap(value): Instant))(
        _.created
      )
      .optionallyWith(status.map(value => value.unwrap))(_.status)
      .optionallyWith(result.map(value => value.unwrap))(_.result)
      .optionallyWith(started.map(value => DateTime.unwrap(value): Instant))(
        _.started
      )
      .optionallyWith(stopped.map(value => DateTime.unwrap(value): Instant))(
        _.stopped
      )
      .optionallyWith(counters.map(value => value.buildAwsValue()))(_.counters)
      .optionallyWith(
        message.map(value => Message.unwrap(value): java.lang.String)
      )(_.message)
      .optionallyWith(
        totalJobs.map(value => Integer.unwrap(value): java.lang.Integer)
      )(_.totalJobs)
      .optionallyWith(
        completedJobs.map(value => Integer.unwrap(value): java.lang.Integer)
      )(_.completedJobs)
      .optionallyWith(billingMethod.map(value => value.unwrap))(_.billingMethod)
      .optionallyWith(deviceMinutes.map(value => value.buildAwsValue()))(
        _.deviceMinutes
      )
      .optionallyWith(networkProfile.map(value => value.buildAwsValue()))(
        _.networkProfile
      )
      .optionallyWith(parsingResultUrl.map(value => value: java.lang.String))(
        _.parsingResultUrl
      )
      .optionallyWith(resultCode.map(value => value.unwrap))(_.resultCode)
      .optionallyWith(
        seed.map(value => Integer.unwrap(value): java.lang.Integer)
      )(_.seed)
      .optionallyWith(
        appUpload.map(value =>
          AmazonResourceName.unwrap(value): java.lang.String
        )
      )(_.appUpload)
      .optionallyWith(
        eventCount.map(value => Integer.unwrap(value): java.lang.Integer)
      )(_.eventCount)
      .optionallyWith(
        jobTimeoutMinutes.map(value =>
          JobTimeoutMinutes.unwrap(value): java.lang.Integer
        )
      )(_.jobTimeoutMinutes)
      .optionallyWith(
        devicePoolArn.map(value =>
          AmazonResourceName.unwrap(value): java.lang.String
        )
      )(_.devicePoolArn)
      .optionallyWith(locale.map(value => value: java.lang.String))(_.locale)
      .optionallyWith(radios.map(value => value.buildAwsValue()))(_.radios)
      .optionallyWith(location.map(value => value.buildAwsValue()))(_.location)
      .optionallyWith(
        customerArtifactPaths.map(value => value.buildAwsValue())
      )(_.customerArtifactPaths)
      .optionallyWith(webUrl.map(value => value: java.lang.String))(_.webUrl)
      .optionallyWith(
        skipAppResign.map(value =>
          SkipAppResign.unwrap(value): java.lang.Boolean
        )
      )(_.skipAppResign)
      .optionallyWith(
        testSpecArn.map(value =>
          AmazonResourceName.unwrap(value): java.lang.String
        )
      )(_.testSpecArn)
      .optionallyWith(
        deviceSelectionResult.map(value => value.buildAwsValue())
      )(_.deviceSelectionResult)
      .build()
  }
  def asReadOnly: zio.aws.devicefarm.model.Run.ReadOnly =
    zio.aws.devicefarm.model.Run.wrap(buildAwsValue())
}
object Run {
  private lazy val zioAwsBuilderHelper
      : BuilderHelper[software.amazon.awssdk.services.devicefarm.model.Run] =
    BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.devicefarm.model.Run = zio.aws.devicefarm.model.Run(
      arn.map(value => value),
      name.map(value => value),
      `type`.map(value => value),
      platform.map(value => value),
      created.map(value => value),
      status.map(value => value),
      result.map(value => value),
      started.map(value => value),
      stopped.map(value => value),
      counters.map(value => value.asEditable),
      message.map(value => value),
      totalJobs.map(value => value),
      completedJobs.map(value => value),
      billingMethod.map(value => value),
      deviceMinutes.map(value => value.asEditable),
      networkProfile.map(value => value.asEditable),
      parsingResultUrl.map(value => value),
      resultCode.map(value => value),
      seed.map(value => value),
      appUpload.map(value => value),
      eventCount.map(value => value),
      jobTimeoutMinutes.map(value => value),
      devicePoolArn.map(value => value),
      locale.map(value => value),
      radios.map(value => value.asEditable),
      location.map(value => value.asEditable),
      customerArtifactPaths.map(value => value.asEditable),
      webUrl.map(value => value),
      skipAppResign.map(value => value),
      testSpecArn.map(value => value),
      deviceSelectionResult.map(value => value.asEditable)
    )
    def arn: Option[AmazonResourceName]
    def name: Option[Name]
    def `type`: Option[zio.aws.devicefarm.model.TestType]
    def platform: Option[zio.aws.devicefarm.model.DevicePlatform]
    def created: Option[DateTime]
    def status: Option[zio.aws.devicefarm.model.ExecutionStatus]
    def result: Option[zio.aws.devicefarm.model.ExecutionResult]
    def started: Option[DateTime]
    def stopped: Option[DateTime]
    def counters: Option[zio.aws.devicefarm.model.Counters.ReadOnly]
    def message: Option[Message]
    def totalJobs: Option[Integer]
    def completedJobs: Option[Integer]
    def billingMethod: Option[zio.aws.devicefarm.model.BillingMethod]
    def deviceMinutes: Option[zio.aws.devicefarm.model.DeviceMinutes.ReadOnly]
    def networkProfile: Option[zio.aws.devicefarm.model.NetworkProfile.ReadOnly]
    def parsingResultUrl: Option[String]
    def resultCode: Option[zio.aws.devicefarm.model.ExecutionResultCode]
    def seed: Option[Integer]
    def appUpload: Option[AmazonResourceName]
    def eventCount: Option[Integer]
    def jobTimeoutMinutes: Option[JobTimeoutMinutes]
    def devicePoolArn: Option[AmazonResourceName]
    def locale: Option[String]
    def radios: Option[zio.aws.devicefarm.model.Radios.ReadOnly]
    def location: Option[zio.aws.devicefarm.model.Location.ReadOnly]
    def customerArtifactPaths
        : Option[zio.aws.devicefarm.model.CustomerArtifactPaths.ReadOnly]
    def webUrl: Option[String]
    def skipAppResign: Option[SkipAppResign]
    def testSpecArn: Option[AmazonResourceName]
    def deviceSelectionResult
        : Option[zio.aws.devicefarm.model.DeviceSelectionResult.ReadOnly]
    def getArn: ZIO[Any, AwsError, AmazonResourceName] =
      AwsError.unwrapOptionField("arn", arn)
    def getName: ZIO[Any, AwsError, Name] =
      AwsError.unwrapOptionField("name", name)
    def getType: ZIO[Any, AwsError, zio.aws.devicefarm.model.TestType] =
      AwsError.unwrapOptionField("type", `type`)
    def getPlatform
        : ZIO[Any, AwsError, zio.aws.devicefarm.model.DevicePlatform] =
      AwsError.unwrapOptionField("platform", platform)
    def getCreated: ZIO[Any, AwsError, DateTime] =
      AwsError.unwrapOptionField("created", created)
    def getStatus
        : ZIO[Any, AwsError, zio.aws.devicefarm.model.ExecutionStatus] =
      AwsError.unwrapOptionField("status", status)
    def getResult
        : ZIO[Any, AwsError, zio.aws.devicefarm.model.ExecutionResult] =
      AwsError.unwrapOptionField("result", result)
    def getStarted: ZIO[Any, AwsError, DateTime] =
      AwsError.unwrapOptionField("started", started)
    def getStopped: ZIO[Any, AwsError, DateTime] =
      AwsError.unwrapOptionField("stopped", stopped)
    def getCounters
        : ZIO[Any, AwsError, zio.aws.devicefarm.model.Counters.ReadOnly] =
      AwsError.unwrapOptionField("counters", counters)
    def getMessage: ZIO[Any, AwsError, Message] =
      AwsError.unwrapOptionField("message", message)
    def getTotalJobs: ZIO[Any, AwsError, Integer] =
      AwsError.unwrapOptionField("totalJobs", totalJobs)
    def getCompletedJobs: ZIO[Any, AwsError, Integer] =
      AwsError.unwrapOptionField("completedJobs", completedJobs)
    def getBillingMethod
        : ZIO[Any, AwsError, zio.aws.devicefarm.model.BillingMethod] =
      AwsError.unwrapOptionField("billingMethod", billingMethod)
    def getDeviceMinutes
        : ZIO[Any, AwsError, zio.aws.devicefarm.model.DeviceMinutes.ReadOnly] =
      AwsError.unwrapOptionField("deviceMinutes", deviceMinutes)
    def getNetworkProfile
        : ZIO[Any, AwsError, zio.aws.devicefarm.model.NetworkProfile.ReadOnly] =
      AwsError.unwrapOptionField("networkProfile", networkProfile)
    def getParsingResultUrl: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("parsingResultUrl", parsingResultUrl)
    def getResultCode
        : ZIO[Any, AwsError, zio.aws.devicefarm.model.ExecutionResultCode] =
      AwsError.unwrapOptionField("resultCode", resultCode)
    def getSeed: ZIO[Any, AwsError, Integer] =
      AwsError.unwrapOptionField("seed", seed)
    def getAppUpload: ZIO[Any, AwsError, AmazonResourceName] =
      AwsError.unwrapOptionField("appUpload", appUpload)
    def getEventCount: ZIO[Any, AwsError, Integer] =
      AwsError.unwrapOptionField("eventCount", eventCount)
    def getJobTimeoutMinutes: ZIO[Any, AwsError, JobTimeoutMinutes] =
      AwsError.unwrapOptionField("jobTimeoutMinutes", jobTimeoutMinutes)
    def getDevicePoolArn: ZIO[Any, AwsError, AmazonResourceName] =
      AwsError.unwrapOptionField("devicePoolArn", devicePoolArn)
    def getLocale: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("locale", locale)
    def getRadios
        : ZIO[Any, AwsError, zio.aws.devicefarm.model.Radios.ReadOnly] =
      AwsError.unwrapOptionField("radios", radios)
    def getLocation
        : ZIO[Any, AwsError, zio.aws.devicefarm.model.Location.ReadOnly] =
      AwsError.unwrapOptionField("location", location)
    def getCustomerArtifactPaths: ZIO[
      Any,
      AwsError,
      zio.aws.devicefarm.model.CustomerArtifactPaths.ReadOnly
    ] =
      AwsError.unwrapOptionField("customerArtifactPaths", customerArtifactPaths)
    def getWebUrl: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("webUrl", webUrl)
    def getSkipAppResign: ZIO[Any, AwsError, SkipAppResign] =
      AwsError.unwrapOptionField("skipAppResign", skipAppResign)
    def getTestSpecArn: ZIO[Any, AwsError, AmazonResourceName] =
      AwsError.unwrapOptionField("testSpecArn", testSpecArn)
    def getDeviceSelectionResult: ZIO[
      Any,
      AwsError,
      zio.aws.devicefarm.model.DeviceSelectionResult.ReadOnly
    ] =
      AwsError.unwrapOptionField("deviceSelectionResult", deviceSelectionResult)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.devicefarm.model.Run
  ) extends zio.aws.devicefarm.model.Run.ReadOnly {
    override val arn: Option[AmazonResourceName] = scala
      .Option(impl.arn())
      .map(value =>
        zio.aws.devicefarm.model.primitives.AmazonResourceName(value)
      )
    override val name: Option[Name] = scala
      .Option(impl.name())
      .map(value => zio.aws.devicefarm.model.primitives.Name(value))
    override val `type`: Option[zio.aws.devicefarm.model.TestType] = scala
      .Option(impl.`type`())
      .map(value => zio.aws.devicefarm.model.TestType.wrap(value))
    override val platform: Option[zio.aws.devicefarm.model.DevicePlatform] =
      scala
        .Option(impl.platform())
        .map(value => zio.aws.devicefarm.model.DevicePlatform.wrap(value))
    override val created: Option[DateTime] = scala
      .Option(impl.created())
      .map(value => zio.aws.devicefarm.model.primitives.DateTime(value))
    override val status: Option[zio.aws.devicefarm.model.ExecutionStatus] =
      scala
        .Option(impl.status())
        .map(value => zio.aws.devicefarm.model.ExecutionStatus.wrap(value))
    override val result: Option[zio.aws.devicefarm.model.ExecutionResult] =
      scala
        .Option(impl.result())
        .map(value => zio.aws.devicefarm.model.ExecutionResult.wrap(value))
    override val started: Option[DateTime] = scala
      .Option(impl.started())
      .map(value => zio.aws.devicefarm.model.primitives.DateTime(value))
    override val stopped: Option[DateTime] = scala
      .Option(impl.stopped())
      .map(value => zio.aws.devicefarm.model.primitives.DateTime(value))
    override val counters: Option[zio.aws.devicefarm.model.Counters.ReadOnly] =
      scala
        .Option(impl.counters())
        .map(value => zio.aws.devicefarm.model.Counters.wrap(value))
    override val message: Option[Message] = scala
      .Option(impl.message())
      .map(value => zio.aws.devicefarm.model.primitives.Message(value))
    override val totalJobs: Option[Integer] = scala
      .Option(impl.totalJobs())
      .map(value => zio.aws.devicefarm.model.primitives.Integer(value))
    override val completedJobs: Option[Integer] = scala
      .Option(impl.completedJobs())
      .map(value => zio.aws.devicefarm.model.primitives.Integer(value))
    override val billingMethod: Option[zio.aws.devicefarm.model.BillingMethod] =
      scala
        .Option(impl.billingMethod())
        .map(value => zio.aws.devicefarm.model.BillingMethod.wrap(value))
    override val deviceMinutes
        : Option[zio.aws.devicefarm.model.DeviceMinutes.ReadOnly] = scala
      .Option(impl.deviceMinutes())
      .map(value => zio.aws.devicefarm.model.DeviceMinutes.wrap(value))
    override val networkProfile
        : Option[zio.aws.devicefarm.model.NetworkProfile.ReadOnly] = scala
      .Option(impl.networkProfile())
      .map(value => zio.aws.devicefarm.model.NetworkProfile.wrap(value))
    override val parsingResultUrl: Option[String] =
      scala.Option(impl.parsingResultUrl()).map(value => value: String)
    override val resultCode
        : Option[zio.aws.devicefarm.model.ExecutionResultCode] = scala
      .Option(impl.resultCode())
      .map(value => zio.aws.devicefarm.model.ExecutionResultCode.wrap(value))
    override val seed: Option[Integer] = scala
      .Option(impl.seed())
      .map(value => zio.aws.devicefarm.model.primitives.Integer(value))
    override val appUpload: Option[AmazonResourceName] = scala
      .Option(impl.appUpload())
      .map(value =>
        zio.aws.devicefarm.model.primitives.AmazonResourceName(value)
      )
    override val eventCount: Option[Integer] = scala
      .Option(impl.eventCount())
      .map(value => zio.aws.devicefarm.model.primitives.Integer(value))
    override val jobTimeoutMinutes: Option[JobTimeoutMinutes] = scala
      .Option(impl.jobTimeoutMinutes())
      .map(value =>
        zio.aws.devicefarm.model.primitives.JobTimeoutMinutes(value)
      )
    override val devicePoolArn: Option[AmazonResourceName] = scala
      .Option(impl.devicePoolArn())
      .map(value =>
        zio.aws.devicefarm.model.primitives.AmazonResourceName(value)
      )
    override val locale: Option[String] =
      scala.Option(impl.locale()).map(value => value: String)
    override val radios: Option[zio.aws.devicefarm.model.Radios.ReadOnly] =
      scala
        .Option(impl.radios())
        .map(value => zio.aws.devicefarm.model.Radios.wrap(value))
    override val location: Option[zio.aws.devicefarm.model.Location.ReadOnly] =
      scala
        .Option(impl.location())
        .map(value => zio.aws.devicefarm.model.Location.wrap(value))
    override val customerArtifactPaths
        : Option[zio.aws.devicefarm.model.CustomerArtifactPaths.ReadOnly] =
      scala
        .Option(impl.customerArtifactPaths())
        .map(value =>
          zio.aws.devicefarm.model.CustomerArtifactPaths.wrap(value)
        )
    override val webUrl: Option[String] =
      scala.Option(impl.webUrl()).map(value => value: String)
    override val skipAppResign: Option[SkipAppResign] = scala
      .Option(impl.skipAppResign())
      .map(value => zio.aws.devicefarm.model.primitives.SkipAppResign(value))
    override val testSpecArn: Option[AmazonResourceName] = scala
      .Option(impl.testSpecArn())
      .map(value =>
        zio.aws.devicefarm.model.primitives.AmazonResourceName(value)
      )
    override val deviceSelectionResult
        : Option[zio.aws.devicefarm.model.DeviceSelectionResult.ReadOnly] =
      scala
        .Option(impl.deviceSelectionResult())
        .map(value =>
          zio.aws.devicefarm.model.DeviceSelectionResult.wrap(value)
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.devicefarm.model.Run
  ): zio.aws.devicefarm.model.Run.ReadOnly = new Wrapper(impl)
}
