package zio.aws.devicefarm.model
import zio.aws.devicefarm.model.primitives.{URL, AmazonResourceName}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters.*
final case class Sample(
    arn: Option[AmazonResourceName] = None,
    `type`: Option[zio.aws.devicefarm.model.SampleType] = None,
    url: Option[URL] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.devicefarm.model.Sample = {
    import Sample.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.devicefarm.model.Sample
      .builder()
      .optionallyWith(
        arn.map(value => AmazonResourceName.unwrap(value): java.lang.String)
      )(_.arn)
      .optionallyWith(`type`.map(value => value.unwrap))(_.`type`)
      .optionallyWith(url.map(value => URL.unwrap(value): java.lang.String))(
        _.url
      )
      .build()
  }
  def asReadOnly: zio.aws.devicefarm.model.Sample.ReadOnly =
    zio.aws.devicefarm.model.Sample.wrap(buildAwsValue())
}
object Sample {
  private lazy val zioAwsBuilderHelper
      : BuilderHelper[software.amazon.awssdk.services.devicefarm.model.Sample] =
    BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.devicefarm.model.Sample =
      zio.aws.devicefarm.model.Sample(
        arn.map(value => value),
        `type`.map(value => value),
        url.map(value => value)
      )
    def arn: Option[AmazonResourceName]
    def `type`: Option[zio.aws.devicefarm.model.SampleType]
    def url: Option[URL]
    def getArn: ZIO[Any, AwsError, AmazonResourceName] =
      AwsError.unwrapOptionField("arn", arn)
    def getType: ZIO[Any, AwsError, zio.aws.devicefarm.model.SampleType] =
      AwsError.unwrapOptionField("type", `type`)
    def getUrl: ZIO[Any, AwsError, URL] = AwsError.unwrapOptionField("url", url)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.devicefarm.model.Sample
  ) extends zio.aws.devicefarm.model.Sample.ReadOnly {
    override val arn: Option[AmazonResourceName] = scala
      .Option(impl.arn())
      .map(value =>
        zio.aws.devicefarm.model.primitives.AmazonResourceName(value)
      )
    override val `type`: Option[zio.aws.devicefarm.model.SampleType] = scala
      .Option(impl.`type`())
      .map(value => zio.aws.devicefarm.model.SampleType.wrap(value))
    override val url: Option[URL] = scala
      .Option(impl.url())
      .map(value => zio.aws.devicefarm.model.primitives.URL(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.devicefarm.model.Sample
  ): zio.aws.devicefarm.model.Sample.ReadOnly = new Wrapper(impl)
}
