package zio.aws.devicefarm.model
import scala.jdk.CollectionConverters.*
sealed trait SampleType {
  def unwrap: software.amazon.awssdk.services.devicefarm.model.SampleType
}
object SampleType {
  def wrap(
      value: software.amazon.awssdk.services.devicefarm.model.SampleType
  ): zio.aws.devicefarm.model.SampleType = value match {
    case software.amazon.awssdk.services.devicefarm.model.SampleType.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.devicefarm.model.SampleType.CPU =>
      val r = CPU
      r
    case software.amazon.awssdk.services.devicefarm.model.SampleType.MEMORY =>
      val r = MEMORY
      r
    case software.amazon.awssdk.services.devicefarm.model.SampleType.THREADS =>
      val r = THREADS
      r
    case software.amazon.awssdk.services.devicefarm.model.SampleType.RX_RATE =>
      val r = RX_RATE
      r
    case software.amazon.awssdk.services.devicefarm.model.SampleType.TX_RATE =>
      val r = TX_RATE
      r
    case software.amazon.awssdk.services.devicefarm.model.SampleType.RX =>
      val r = RX
      r
    case software.amazon.awssdk.services.devicefarm.model.SampleType.TX =>
      val r = TX
      r
    case software.amazon.awssdk.services.devicefarm.model.SampleType.NATIVE_FRAMES =>
      val r = NATIVE_FRAMES
      r
    case software.amazon.awssdk.services.devicefarm.model.SampleType.NATIVE_FPS =>
      val r = NATIVE_FPS
      r
    case software.amazon.awssdk.services.devicefarm.model.SampleType.NATIVE_MIN_DRAWTIME =>
      val r = NATIVE_MIN_DRAWTIME
      r
    case software.amazon.awssdk.services.devicefarm.model.SampleType.NATIVE_AVG_DRAWTIME =>
      val r = NATIVE_AVG_DRAWTIME
      r
    case software.amazon.awssdk.services.devicefarm.model.SampleType.NATIVE_MAX_DRAWTIME =>
      val r = NATIVE_MAX_DRAWTIME
      r
    case software.amazon.awssdk.services.devicefarm.model.SampleType.OPENGL_FRAMES =>
      val r = OPENGL_FRAMES
      r
    case software.amazon.awssdk.services.devicefarm.model.SampleType.OPENGL_FPS =>
      val r = OPENGL_FPS
      r
    case software.amazon.awssdk.services.devicefarm.model.SampleType.OPENGL_MIN_DRAWTIME =>
      val r = OPENGL_MIN_DRAWTIME
      r
    case software.amazon.awssdk.services.devicefarm.model.SampleType.OPENGL_AVG_DRAWTIME =>
      val r = OPENGL_AVG_DRAWTIME
      r
    case software.amazon.awssdk.services.devicefarm.model.SampleType.OPENGL_MAX_DRAWTIME =>
      val r = OPENGL_MAX_DRAWTIME
      r
  }
  case object unknownToSdkVersion extends zio.aws.devicefarm.model.SampleType {
    override def unwrap
        : software.amazon.awssdk.services.devicefarm.model.SampleType =
      software.amazon.awssdk.services.devicefarm.model.SampleType.UNKNOWN_TO_SDK_VERSION
  }
  case object CPU extends zio.aws.devicefarm.model.SampleType {
    override def unwrap
        : software.amazon.awssdk.services.devicefarm.model.SampleType =
      software.amazon.awssdk.services.devicefarm.model.SampleType.CPU
  }
  case object MEMORY extends zio.aws.devicefarm.model.SampleType {
    override def unwrap
        : software.amazon.awssdk.services.devicefarm.model.SampleType =
      software.amazon.awssdk.services.devicefarm.model.SampleType.MEMORY
  }
  case object THREADS extends zio.aws.devicefarm.model.SampleType {
    override def unwrap
        : software.amazon.awssdk.services.devicefarm.model.SampleType =
      software.amazon.awssdk.services.devicefarm.model.SampleType.THREADS
  }
  case object RX_RATE extends zio.aws.devicefarm.model.SampleType {
    override def unwrap
        : software.amazon.awssdk.services.devicefarm.model.SampleType =
      software.amazon.awssdk.services.devicefarm.model.SampleType.RX_RATE
  }
  case object TX_RATE extends zio.aws.devicefarm.model.SampleType {
    override def unwrap
        : software.amazon.awssdk.services.devicefarm.model.SampleType =
      software.amazon.awssdk.services.devicefarm.model.SampleType.TX_RATE
  }
  case object RX extends zio.aws.devicefarm.model.SampleType {
    override def unwrap
        : software.amazon.awssdk.services.devicefarm.model.SampleType =
      software.amazon.awssdk.services.devicefarm.model.SampleType.RX
  }
  case object TX extends zio.aws.devicefarm.model.SampleType {
    override def unwrap
        : software.amazon.awssdk.services.devicefarm.model.SampleType =
      software.amazon.awssdk.services.devicefarm.model.SampleType.TX
  }
  case object NATIVE_FRAMES extends zio.aws.devicefarm.model.SampleType {
    override def unwrap
        : software.amazon.awssdk.services.devicefarm.model.SampleType =
      software.amazon.awssdk.services.devicefarm.model.SampleType.NATIVE_FRAMES
  }
  case object NATIVE_FPS extends zio.aws.devicefarm.model.SampleType {
    override def unwrap
        : software.amazon.awssdk.services.devicefarm.model.SampleType =
      software.amazon.awssdk.services.devicefarm.model.SampleType.NATIVE_FPS
  }
  case object NATIVE_MIN_DRAWTIME extends zio.aws.devicefarm.model.SampleType {
    override def unwrap
        : software.amazon.awssdk.services.devicefarm.model.SampleType =
      software.amazon.awssdk.services.devicefarm.model.SampleType.NATIVE_MIN_DRAWTIME
  }
  case object NATIVE_AVG_DRAWTIME extends zio.aws.devicefarm.model.SampleType {
    override def unwrap
        : software.amazon.awssdk.services.devicefarm.model.SampleType =
      software.amazon.awssdk.services.devicefarm.model.SampleType.NATIVE_AVG_DRAWTIME
  }
  case object NATIVE_MAX_DRAWTIME extends zio.aws.devicefarm.model.SampleType {
    override def unwrap
        : software.amazon.awssdk.services.devicefarm.model.SampleType =
      software.amazon.awssdk.services.devicefarm.model.SampleType.NATIVE_MAX_DRAWTIME
  }
  case object OPENGL_FRAMES extends zio.aws.devicefarm.model.SampleType {
    override def unwrap
        : software.amazon.awssdk.services.devicefarm.model.SampleType =
      software.amazon.awssdk.services.devicefarm.model.SampleType.OPENGL_FRAMES
  }
  case object OPENGL_FPS extends zio.aws.devicefarm.model.SampleType {
    override def unwrap
        : software.amazon.awssdk.services.devicefarm.model.SampleType =
      software.amazon.awssdk.services.devicefarm.model.SampleType.OPENGL_FPS
  }
  case object OPENGL_MIN_DRAWTIME extends zio.aws.devicefarm.model.SampleType {
    override def unwrap
        : software.amazon.awssdk.services.devicefarm.model.SampleType =
      software.amazon.awssdk.services.devicefarm.model.SampleType.OPENGL_MIN_DRAWTIME
  }
  case object OPENGL_AVG_DRAWTIME extends zio.aws.devicefarm.model.SampleType {
    override def unwrap
        : software.amazon.awssdk.services.devicefarm.model.SampleType =
      software.amazon.awssdk.services.devicefarm.model.SampleType.OPENGL_AVG_DRAWTIME
  }
  case object OPENGL_MAX_DRAWTIME extends zio.aws.devicefarm.model.SampleType {
    override def unwrap
        : software.amazon.awssdk.services.devicefarm.model.SampleType =
      software.amazon.awssdk.services.devicefarm.model.SampleType.OPENGL_MAX_DRAWTIME
  }
}
