package zio.aws.devicefarm.model
import zio.aws.devicefarm.model.primitives.AmazonResourceName
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters.*
final case class ScheduleRunConfiguration(
    extraDataPackageArn: Option[AmazonResourceName] = None,
    networkProfileArn: Option[AmazonResourceName] = None,
    locale: Option[String] = None,
    location: Option[zio.aws.devicefarm.model.Location] = None,
    vpceConfigurationArns: Option[Iterable[AmazonResourceName]] = None,
    customerArtifactPaths: Option[
      zio.aws.devicefarm.model.CustomerArtifactPaths
    ] = None,
    radios: Option[zio.aws.devicefarm.model.Radios] = None,
    auxiliaryApps: Option[Iterable[AmazonResourceName]] = None,
    billingMethod: Option[zio.aws.devicefarm.model.BillingMethod] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.devicefarm.model.ScheduleRunConfiguration = {
    import ScheduleRunConfiguration.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.devicefarm.model.ScheduleRunConfiguration
      .builder()
      .optionallyWith(
        extraDataPackageArn.map(value =>
          AmazonResourceName.unwrap(value): java.lang.String
        )
      )(_.extraDataPackageArn)
      .optionallyWith(
        networkProfileArn.map(value =>
          AmazonResourceName.unwrap(value): java.lang.String
        )
      )(_.networkProfileArn)
      .optionallyWith(locale.map(value => value: java.lang.String))(_.locale)
      .optionallyWith(location.map(value => value.buildAwsValue()))(_.location)
      .optionallyWith(
        vpceConfigurationArns.map(value =>
          value.map { item =>
            AmazonResourceName.unwrap(item): java.lang.String
          }.asJavaCollection
        )
      )(_.vpceConfigurationArns)
      .optionallyWith(
        customerArtifactPaths.map(value => value.buildAwsValue())
      )(_.customerArtifactPaths)
      .optionallyWith(radios.map(value => value.buildAwsValue()))(_.radios)
      .optionallyWith(
        auxiliaryApps.map(value =>
          value.map { item =>
            AmazonResourceName.unwrap(item): java.lang.String
          }.asJavaCollection
        )
      )(_.auxiliaryApps)
      .optionallyWith(billingMethod.map(value => value.unwrap))(_.billingMethod)
      .build()
  }
  def asReadOnly: zio.aws.devicefarm.model.ScheduleRunConfiguration.ReadOnly =
    zio.aws.devicefarm.model.ScheduleRunConfiguration.wrap(buildAwsValue())
}
object ScheduleRunConfiguration {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.devicefarm.model.ScheduleRunConfiguration
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.devicefarm.model.ScheduleRunConfiguration =
      zio.aws.devicefarm.model.ScheduleRunConfiguration(
        extraDataPackageArn.map(value => value),
        networkProfileArn.map(value => value),
        locale.map(value => value),
        location.map(value => value.asEditable),
        vpceConfigurationArns.map(value => value),
        customerArtifactPaths.map(value => value.asEditable),
        radios.map(value => value.asEditable),
        auxiliaryApps.map(value => value),
        billingMethod.map(value => value)
      )
    def extraDataPackageArn: Option[AmazonResourceName]
    def networkProfileArn: Option[AmazonResourceName]
    def locale: Option[String]
    def location: Option[zio.aws.devicefarm.model.Location.ReadOnly]
    def vpceConfigurationArns: Option[List[AmazonResourceName]]
    def customerArtifactPaths
        : Option[zio.aws.devicefarm.model.CustomerArtifactPaths.ReadOnly]
    def radios: Option[zio.aws.devicefarm.model.Radios.ReadOnly]
    def auxiliaryApps: Option[List[AmazonResourceName]]
    def billingMethod: Option[zio.aws.devicefarm.model.BillingMethod]
    def getExtraDataPackageArn: ZIO[Any, AwsError, AmazonResourceName] =
      AwsError.unwrapOptionField("extraDataPackageArn", extraDataPackageArn)
    def getNetworkProfileArn: ZIO[Any, AwsError, AmazonResourceName] =
      AwsError.unwrapOptionField("networkProfileArn", networkProfileArn)
    def getLocale: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("locale", locale)
    def getLocation
        : ZIO[Any, AwsError, zio.aws.devicefarm.model.Location.ReadOnly] =
      AwsError.unwrapOptionField("location", location)
    def getVpceConfigurationArns: ZIO[Any, AwsError, List[AmazonResourceName]] =
      AwsError.unwrapOptionField("vpceConfigurationArns", vpceConfigurationArns)
    def getCustomerArtifactPaths: ZIO[
      Any,
      AwsError,
      zio.aws.devicefarm.model.CustomerArtifactPaths.ReadOnly
    ] =
      AwsError.unwrapOptionField("customerArtifactPaths", customerArtifactPaths)
    def getRadios
        : ZIO[Any, AwsError, zio.aws.devicefarm.model.Radios.ReadOnly] =
      AwsError.unwrapOptionField("radios", radios)
    def getAuxiliaryApps: ZIO[Any, AwsError, List[AmazonResourceName]] =
      AwsError.unwrapOptionField("auxiliaryApps", auxiliaryApps)
    def getBillingMethod
        : ZIO[Any, AwsError, zio.aws.devicefarm.model.BillingMethod] =
      AwsError.unwrapOptionField("billingMethod", billingMethod)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.devicefarm.model.ScheduleRunConfiguration
  ) extends zio.aws.devicefarm.model.ScheduleRunConfiguration.ReadOnly {
    override val extraDataPackageArn: Option[AmazonResourceName] = scala
      .Option(impl.extraDataPackageArn())
      .map(value =>
        zio.aws.devicefarm.model.primitives.AmazonResourceName(value)
      )
    override val networkProfileArn: Option[AmazonResourceName] = scala
      .Option(impl.networkProfileArn())
      .map(value =>
        zio.aws.devicefarm.model.primitives.AmazonResourceName(value)
      )
    override val locale: Option[String] =
      scala.Option(impl.locale()).map(value => value: String)
    override val location: Option[zio.aws.devicefarm.model.Location.ReadOnly] =
      scala
        .Option(impl.location())
        .map(value => zio.aws.devicefarm.model.Location.wrap(value))
    override val vpceConfigurationArns: Option[List[AmazonResourceName]] = scala
      .Option(impl.vpceConfigurationArns())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.devicefarm.model.primitives.AmazonResourceName(item)
        }.toList
      )
    override val customerArtifactPaths
        : Option[zio.aws.devicefarm.model.CustomerArtifactPaths.ReadOnly] =
      scala
        .Option(impl.customerArtifactPaths())
        .map(value =>
          zio.aws.devicefarm.model.CustomerArtifactPaths.wrap(value)
        )
    override val radios: Option[zio.aws.devicefarm.model.Radios.ReadOnly] =
      scala
        .Option(impl.radios())
        .map(value => zio.aws.devicefarm.model.Radios.wrap(value))
    override val auxiliaryApps: Option[List[AmazonResourceName]] = scala
      .Option(impl.auxiliaryApps())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.devicefarm.model.primitives.AmazonResourceName(item)
        }.toList
      )
    override val billingMethod: Option[zio.aws.devicefarm.model.BillingMethod] =
      scala
        .Option(impl.billingMethod())
        .map(value => zio.aws.devicefarm.model.BillingMethod.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.devicefarm.model.ScheduleRunConfiguration
  ): zio.aws.devicefarm.model.ScheduleRunConfiguration.ReadOnly = new Wrapper(
    impl
  )
}
