package zio.aws.devicefarm.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters.*
final case class ScheduleRunResponse(
    run: Option[zio.aws.devicefarm.model.Run] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.devicefarm.model.ScheduleRunResponse = {
    import ScheduleRunResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.devicefarm.model.ScheduleRunResponse
      .builder()
      .optionallyWith(run.map(value => value.buildAwsValue()))(_.run)
      .build()
  }
  def asReadOnly: zio.aws.devicefarm.model.ScheduleRunResponse.ReadOnly =
    zio.aws.devicefarm.model.ScheduleRunResponse.wrap(buildAwsValue())
}
object ScheduleRunResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.devicefarm.model.ScheduleRunResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.devicefarm.model.ScheduleRunResponse =
      zio.aws.devicefarm.model
        .ScheduleRunResponse(run.map(value => value.asEditable))
    def run: Option[zio.aws.devicefarm.model.Run.ReadOnly]
    def getRun: ZIO[Any, AwsError, zio.aws.devicefarm.model.Run.ReadOnly] =
      AwsError.unwrapOptionField("run", run)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.devicefarm.model.ScheduleRunResponse
  ) extends zio.aws.devicefarm.model.ScheduleRunResponse.ReadOnly {
    override val run: Option[zio.aws.devicefarm.model.Run.ReadOnly] = scala
      .Option(impl.run())
      .map(value => zio.aws.devicefarm.model.Run.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.devicefarm.model.ScheduleRunResponse
  ): zio.aws.devicefarm.model.ScheduleRunResponse.ReadOnly = new Wrapper(impl)
}
