package zio.aws.devicefarm.model
import zio.aws.devicefarm.model.primitives.{Filter, AmazonResourceName}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters.*
final case class ScheduleRunTest(
    `type`: zio.aws.devicefarm.model.TestType,
    testPackageArn: Option[AmazonResourceName] = None,
    testSpecArn: Option[AmazonResourceName] = None,
    filter: Option[Filter] = None,
    parameters: Option[Map[String, String]] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.devicefarm.model.ScheduleRunTest = {
    import ScheduleRunTest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.devicefarm.model.ScheduleRunTest
      .builder()
      .`type`(`type`.unwrap)
      .optionallyWith(
        testPackageArn.map(value =>
          AmazonResourceName.unwrap(value): java.lang.String
        )
      )(_.testPackageArn)
      .optionallyWith(
        testSpecArn.map(value =>
          AmazonResourceName.unwrap(value): java.lang.String
        )
      )(_.testSpecArn)
      .optionallyWith(
        filter.map(value => Filter.unwrap(value): java.lang.String)
      )(_.filter)
      .optionallyWith(
        parameters.map(value =>
          value
            .map({ case (key, value) =>
              (key: java.lang.String) -> (value: java.lang.String)
            })
            .asJava
        )
      )(_.parameters)
      .build()
  }
  def asReadOnly: zio.aws.devicefarm.model.ScheduleRunTest.ReadOnly =
    zio.aws.devicefarm.model.ScheduleRunTest.wrap(buildAwsValue())
}
object ScheduleRunTest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.devicefarm.model.ScheduleRunTest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.devicefarm.model.ScheduleRunTest =
      zio.aws.devicefarm.model.ScheduleRunTest(
        `type`,
        testPackageArn.map(value => value),
        testSpecArn.map(value => value),
        filter.map(value => value),
        parameters.map(value => value)
      )
    def `type`: zio.aws.devicefarm.model.TestType
    def testPackageArn: Option[AmazonResourceName]
    def testSpecArn: Option[AmazonResourceName]
    def filter: Option[Filter]
    def parameters: Option[Map[String, String]]
    def getType: ZIO[Any, Nothing, zio.aws.devicefarm.model.TestType] =
      ZIO.succeed(`type`)
    def getTestPackageArn: ZIO[Any, AwsError, AmazonResourceName] =
      AwsError.unwrapOptionField("testPackageArn", testPackageArn)
    def getTestSpecArn: ZIO[Any, AwsError, AmazonResourceName] =
      AwsError.unwrapOptionField("testSpecArn", testSpecArn)
    def getFilter: ZIO[Any, AwsError, Filter] =
      AwsError.unwrapOptionField("filter", filter)
    def getParameters: ZIO[Any, AwsError, Map[String, String]] =
      AwsError.unwrapOptionField("parameters", parameters)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.devicefarm.model.ScheduleRunTest
  ) extends zio.aws.devicefarm.model.ScheduleRunTest.ReadOnly {
    override val `type`: zio.aws.devicefarm.model.TestType =
      zio.aws.devicefarm.model.TestType.wrap(impl.`type`())
    override val testPackageArn: Option[AmazonResourceName] = scala
      .Option(impl.testPackageArn())
      .map(value =>
        zio.aws.devicefarm.model.primitives.AmazonResourceName(value)
      )
    override val testSpecArn: Option[AmazonResourceName] = scala
      .Option(impl.testSpecArn())
      .map(value =>
        zio.aws.devicefarm.model.primitives.AmazonResourceName(value)
      )
    override val filter: Option[Filter] = scala
      .Option(impl.filter())
      .map(value => zio.aws.devicefarm.model.primitives.Filter(value))
    override val parameters: Option[Map[String, String]] = scala
      .Option(impl.parameters())
      .map(value =>
        value.asScala
          .map({ case (key, value) =>
            (key: String) -> (value: String)
          })
          .toMap
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.devicefarm.model.ScheduleRunTest
  ): zio.aws.devicefarm.model.ScheduleRunTest.ReadOnly = new Wrapper(impl)
}
