package zio.aws.devicefarm.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters.*
final case class StopJobResponse(
    job: Option[zio.aws.devicefarm.model.Job] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.devicefarm.model.StopJobResponse = {
    import StopJobResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.devicefarm.model.StopJobResponse
      .builder()
      .optionallyWith(job.map(value => value.buildAwsValue()))(_.job)
      .build()
  }
  def asReadOnly: zio.aws.devicefarm.model.StopJobResponse.ReadOnly =
    zio.aws.devicefarm.model.StopJobResponse.wrap(buildAwsValue())
}
object StopJobResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.devicefarm.model.StopJobResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.devicefarm.model.StopJobResponse =
      zio.aws.devicefarm.model
        .StopJobResponse(job.map(value => value.asEditable))
    def job: Option[zio.aws.devicefarm.model.Job.ReadOnly]
    def getJob: ZIO[Any, AwsError, zio.aws.devicefarm.model.Job.ReadOnly] =
      AwsError.unwrapOptionField("job", job)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.devicefarm.model.StopJobResponse
  ) extends zio.aws.devicefarm.model.StopJobResponse.ReadOnly {
    override val job: Option[zio.aws.devicefarm.model.Job.ReadOnly] = scala
      .Option(impl.job())
      .map(value => zio.aws.devicefarm.model.Job.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.devicefarm.model.StopJobResponse
  ): zio.aws.devicefarm.model.StopJobResponse.ReadOnly = new Wrapper(impl)
}
