package zio.aws.devicefarm.model
import zio.aws.devicefarm.model.primitives.{
  Message,
  DateTime,
  Name,
  AmazonResourceName
}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import java.time.Instant
import scala.jdk.CollectionConverters.*
final case class Test(
    arn: Option[AmazonResourceName] = None,
    name: Option[Name] = None,
    `type`: Option[zio.aws.devicefarm.model.TestType] = None,
    created: Option[DateTime] = None,
    status: Option[zio.aws.devicefarm.model.ExecutionStatus] = None,
    result: Option[zio.aws.devicefarm.model.ExecutionResult] = None,
    started: Option[DateTime] = None,
    stopped: Option[DateTime] = None,
    counters: Option[zio.aws.devicefarm.model.Counters] = None,
    message: Option[Message] = None,
    deviceMinutes: Option[zio.aws.devicefarm.model.DeviceMinutes] = None
) {
  def buildAwsValue(): software.amazon.awssdk.services.devicefarm.model.Test = {
    import Test.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.devicefarm.model.Test
      .builder()
      .optionallyWith(
        arn.map(value => AmazonResourceName.unwrap(value): java.lang.String)
      )(_.arn)
      .optionallyWith(name.map(value => Name.unwrap(value): java.lang.String))(
        _.name
      )
      .optionallyWith(`type`.map(value => value.unwrap))(_.`type`)
      .optionallyWith(created.map(value => DateTime.unwrap(value): Instant))(
        _.created
      )
      .optionallyWith(status.map(value => value.unwrap))(_.status)
      .optionallyWith(result.map(value => value.unwrap))(_.result)
      .optionallyWith(started.map(value => DateTime.unwrap(value): Instant))(
        _.started
      )
      .optionallyWith(stopped.map(value => DateTime.unwrap(value): Instant))(
        _.stopped
      )
      .optionallyWith(counters.map(value => value.buildAwsValue()))(_.counters)
      .optionallyWith(
        message.map(value => Message.unwrap(value): java.lang.String)
      )(_.message)
      .optionallyWith(deviceMinutes.map(value => value.buildAwsValue()))(
        _.deviceMinutes
      )
      .build()
  }
  def asReadOnly: zio.aws.devicefarm.model.Test.ReadOnly =
    zio.aws.devicefarm.model.Test.wrap(buildAwsValue())
}
object Test {
  private lazy val zioAwsBuilderHelper
      : BuilderHelper[software.amazon.awssdk.services.devicefarm.model.Test] =
    BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.devicefarm.model.Test =
      zio.aws.devicefarm.model.Test(
        arn.map(value => value),
        name.map(value => value),
        `type`.map(value => value),
        created.map(value => value),
        status.map(value => value),
        result.map(value => value),
        started.map(value => value),
        stopped.map(value => value),
        counters.map(value => value.asEditable),
        message.map(value => value),
        deviceMinutes.map(value => value.asEditable)
      )
    def arn: Option[AmazonResourceName]
    def name: Option[Name]
    def `type`: Option[zio.aws.devicefarm.model.TestType]
    def created: Option[DateTime]
    def status: Option[zio.aws.devicefarm.model.ExecutionStatus]
    def result: Option[zio.aws.devicefarm.model.ExecutionResult]
    def started: Option[DateTime]
    def stopped: Option[DateTime]
    def counters: Option[zio.aws.devicefarm.model.Counters.ReadOnly]
    def message: Option[Message]
    def deviceMinutes: Option[zio.aws.devicefarm.model.DeviceMinutes.ReadOnly]
    def getArn: ZIO[Any, AwsError, AmazonResourceName] =
      AwsError.unwrapOptionField("arn", arn)
    def getName: ZIO[Any, AwsError, Name] =
      AwsError.unwrapOptionField("name", name)
    def getType: ZIO[Any, AwsError, zio.aws.devicefarm.model.TestType] =
      AwsError.unwrapOptionField("type", `type`)
    def getCreated: ZIO[Any, AwsError, DateTime] =
      AwsError.unwrapOptionField("created", created)
    def getStatus
        : ZIO[Any, AwsError, zio.aws.devicefarm.model.ExecutionStatus] =
      AwsError.unwrapOptionField("status", status)
    def getResult
        : ZIO[Any, AwsError, zio.aws.devicefarm.model.ExecutionResult] =
      AwsError.unwrapOptionField("result", result)
    def getStarted: ZIO[Any, AwsError, DateTime] =
      AwsError.unwrapOptionField("started", started)
    def getStopped: ZIO[Any, AwsError, DateTime] =
      AwsError.unwrapOptionField("stopped", stopped)
    def getCounters
        : ZIO[Any, AwsError, zio.aws.devicefarm.model.Counters.ReadOnly] =
      AwsError.unwrapOptionField("counters", counters)
    def getMessage: ZIO[Any, AwsError, Message] =
      AwsError.unwrapOptionField("message", message)
    def getDeviceMinutes
        : ZIO[Any, AwsError, zio.aws.devicefarm.model.DeviceMinutes.ReadOnly] =
      AwsError.unwrapOptionField("deviceMinutes", deviceMinutes)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.devicefarm.model.Test
  ) extends zio.aws.devicefarm.model.Test.ReadOnly {
    override val arn: Option[AmazonResourceName] = scala
      .Option(impl.arn())
      .map(value =>
        zio.aws.devicefarm.model.primitives.AmazonResourceName(value)
      )
    override val name: Option[Name] = scala
      .Option(impl.name())
      .map(value => zio.aws.devicefarm.model.primitives.Name(value))
    override val `type`: Option[zio.aws.devicefarm.model.TestType] = scala
      .Option(impl.`type`())
      .map(value => zio.aws.devicefarm.model.TestType.wrap(value))
    override val created: Option[DateTime] = scala
      .Option(impl.created())
      .map(value => zio.aws.devicefarm.model.primitives.DateTime(value))
    override val status: Option[zio.aws.devicefarm.model.ExecutionStatus] =
      scala
        .Option(impl.status())
        .map(value => zio.aws.devicefarm.model.ExecutionStatus.wrap(value))
    override val result: Option[zio.aws.devicefarm.model.ExecutionResult] =
      scala
        .Option(impl.result())
        .map(value => zio.aws.devicefarm.model.ExecutionResult.wrap(value))
    override val started: Option[DateTime] = scala
      .Option(impl.started())
      .map(value => zio.aws.devicefarm.model.primitives.DateTime(value))
    override val stopped: Option[DateTime] = scala
      .Option(impl.stopped())
      .map(value => zio.aws.devicefarm.model.primitives.DateTime(value))
    override val counters: Option[zio.aws.devicefarm.model.Counters.ReadOnly] =
      scala
        .Option(impl.counters())
        .map(value => zio.aws.devicefarm.model.Counters.wrap(value))
    override val message: Option[Message] = scala
      .Option(impl.message())
      .map(value => zio.aws.devicefarm.model.primitives.Message(value))
    override val deviceMinutes
        : Option[zio.aws.devicefarm.model.DeviceMinutes.ReadOnly] = scala
      .Option(impl.deviceMinutes())
      .map(value => zio.aws.devicefarm.model.DeviceMinutes.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.devicefarm.model.Test
  ): zio.aws.devicefarm.model.Test.ReadOnly = new Wrapper(impl)
}
