package zio.aws.devicefarm.model
import zio.aws.devicefarm.model.primitives.{DateTime, DeviceFarmArn}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import java.time.Instant
import scala.jdk.CollectionConverters.*
final case class TestGridProject(
    arn: Option[DeviceFarmArn] = None,
    name: Option[String] = None,
    description: Option[String] = None,
    vpcConfig: Option[zio.aws.devicefarm.model.TestGridVpcConfig] = None,
    created: Option[DateTime] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.devicefarm.model.TestGridProject = {
    import TestGridProject.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.devicefarm.model.TestGridProject
      .builder()
      .optionallyWith(
        arn.map(value => DeviceFarmArn.unwrap(value): java.lang.String)
      )(_.arn)
      .optionallyWith(name.map(value => value: java.lang.String))(_.name)
      .optionallyWith(description.map(value => value: java.lang.String))(
        _.description
      )
      .optionallyWith(vpcConfig.map(value => value.buildAwsValue()))(
        _.vpcConfig
      )
      .optionallyWith(created.map(value => DateTime.unwrap(value): Instant))(
        _.created
      )
      .build()
  }
  def asReadOnly: zio.aws.devicefarm.model.TestGridProject.ReadOnly =
    zio.aws.devicefarm.model.TestGridProject.wrap(buildAwsValue())
}
object TestGridProject {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.devicefarm.model.TestGridProject
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.devicefarm.model.TestGridProject =
      zio.aws.devicefarm.model.TestGridProject(
        arn.map(value => value),
        name.map(value => value),
        description.map(value => value),
        vpcConfig.map(value => value.asEditable),
        created.map(value => value)
      )
    def arn: Option[DeviceFarmArn]
    def name: Option[String]
    def description: Option[String]
    def vpcConfig: Option[zio.aws.devicefarm.model.TestGridVpcConfig.ReadOnly]
    def created: Option[DateTime]
    def getArn: ZIO[Any, AwsError, DeviceFarmArn] =
      AwsError.unwrapOptionField("arn", arn)
    def getName: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("name", name)
    def getDescription: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("description", description)
    def getVpcConfig: ZIO[
      Any,
      AwsError,
      zio.aws.devicefarm.model.TestGridVpcConfig.ReadOnly
    ] = AwsError.unwrapOptionField("vpcConfig", vpcConfig)
    def getCreated: ZIO[Any, AwsError, DateTime] =
      AwsError.unwrapOptionField("created", created)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.devicefarm.model.TestGridProject
  ) extends zio.aws.devicefarm.model.TestGridProject.ReadOnly {
    override val arn: Option[DeviceFarmArn] = scala
      .Option(impl.arn())
      .map(value => zio.aws.devicefarm.model.primitives.DeviceFarmArn(value))
    override val name: Option[String] =
      scala.Option(impl.name()).map(value => value: String)
    override val description: Option[String] =
      scala.Option(impl.description()).map(value => value: String)
    override val vpcConfig
        : Option[zio.aws.devicefarm.model.TestGridVpcConfig.ReadOnly] = scala
      .Option(impl.vpcConfig())
      .map(value => zio.aws.devicefarm.model.TestGridVpcConfig.wrap(value))
    override val created: Option[DateTime] = scala
      .Option(impl.created())
      .map(value => zio.aws.devicefarm.model.primitives.DateTime(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.devicefarm.model.TestGridProject
  ): zio.aws.devicefarm.model.TestGridProject.ReadOnly = new Wrapper(impl)
}
