package zio.aws.devicefarm.model
import zio.aws.devicefarm.model.primitives.{DateTime, DeviceFarmArn}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import java.time.Instant
import scala.jdk.CollectionConverters.*
final case class TestGridSession(
    arn: Option[DeviceFarmArn] = None,
    status: Option[zio.aws.devicefarm.model.TestGridSessionStatus] = None,
    created: Option[DateTime] = None,
    ended: Option[DateTime] = None,
    billingMinutes: Option[Double] = None,
    seleniumProperties: Option[String] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.devicefarm.model.TestGridSession = {
    import TestGridSession.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.devicefarm.model.TestGridSession
      .builder()
      .optionallyWith(
        arn.map(value => DeviceFarmArn.unwrap(value): java.lang.String)
      )(_.arn)
      .optionallyWith(status.map(value => value.unwrap))(_.status)
      .optionallyWith(created.map(value => DateTime.unwrap(value): Instant))(
        _.created
      )
      .optionallyWith(ended.map(value => DateTime.unwrap(value): Instant))(
        _.ended
      )
      .optionallyWith(billingMinutes.map(value => value: java.lang.Double))(
        _.billingMinutes
      )
      .optionallyWith(seleniumProperties.map(value => value: java.lang.String))(
        _.seleniumProperties
      )
      .build()
  }
  def asReadOnly: zio.aws.devicefarm.model.TestGridSession.ReadOnly =
    zio.aws.devicefarm.model.TestGridSession.wrap(buildAwsValue())
}
object TestGridSession {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.devicefarm.model.TestGridSession
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.devicefarm.model.TestGridSession =
      zio.aws.devicefarm.model.TestGridSession(
        arn.map(value => value),
        status.map(value => value),
        created.map(value => value),
        ended.map(value => value),
        billingMinutes.map(value => value),
        seleniumProperties.map(value => value)
      )
    def arn: Option[DeviceFarmArn]
    def status: Option[zio.aws.devicefarm.model.TestGridSessionStatus]
    def created: Option[DateTime]
    def ended: Option[DateTime]
    def billingMinutes: Option[Double]
    def seleniumProperties: Option[String]
    def getArn: ZIO[Any, AwsError, DeviceFarmArn] =
      AwsError.unwrapOptionField("arn", arn)
    def getStatus
        : ZIO[Any, AwsError, zio.aws.devicefarm.model.TestGridSessionStatus] =
      AwsError.unwrapOptionField("status", status)
    def getCreated: ZIO[Any, AwsError, DateTime] =
      AwsError.unwrapOptionField("created", created)
    def getEnded: ZIO[Any, AwsError, DateTime] =
      AwsError.unwrapOptionField("ended", ended)
    def getBillingMinutes: ZIO[Any, AwsError, Double] =
      AwsError.unwrapOptionField("billingMinutes", billingMinutes)
    def getSeleniumProperties: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("seleniumProperties", seleniumProperties)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.devicefarm.model.TestGridSession
  ) extends zio.aws.devicefarm.model.TestGridSession.ReadOnly {
    override val arn: Option[DeviceFarmArn] = scala
      .Option(impl.arn())
      .map(value => zio.aws.devicefarm.model.primitives.DeviceFarmArn(value))
    override val status
        : Option[zio.aws.devicefarm.model.TestGridSessionStatus] = scala
      .Option(impl.status())
      .map(value => zio.aws.devicefarm.model.TestGridSessionStatus.wrap(value))
    override val created: Option[DateTime] = scala
      .Option(impl.created())
      .map(value => zio.aws.devicefarm.model.primitives.DateTime(value))
    override val ended: Option[DateTime] = scala
      .Option(impl.ended())
      .map(value => zio.aws.devicefarm.model.primitives.DateTime(value))
    override val billingMinutes: Option[Double] =
      scala.Option(impl.billingMinutes()).map(value => value: Double)
    override val seleniumProperties: Option[String] =
      scala.Option(impl.seleniumProperties()).map(value => value: String)
  }
  def wrap(
      impl: software.amazon.awssdk.services.devicefarm.model.TestGridSession
  ): zio.aws.devicefarm.model.TestGridSession.ReadOnly = new Wrapper(impl)
}
