package zio.aws.devicefarm.model
import zio.aws.devicefarm.model.primitives.SensitiveString
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters.*
final case class TestGridSessionArtifact(
    filename: Option[String] = None,
    `type`: Option[zio.aws.devicefarm.model.TestGridSessionArtifactType] = None,
    url: Option[SensitiveString] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.devicefarm.model.TestGridSessionArtifact = {
    import TestGridSessionArtifact.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.devicefarm.model.TestGridSessionArtifact
      .builder()
      .optionallyWith(filename.map(value => value: java.lang.String))(
        _.filename
      )
      .optionallyWith(`type`.map(value => value.unwrap))(_.`type`)
      .optionallyWith(
        url.map(value => SensitiveString.unwrap(value): java.lang.String)
      )(_.url)
      .build()
  }
  def asReadOnly: zio.aws.devicefarm.model.TestGridSessionArtifact.ReadOnly =
    zio.aws.devicefarm.model.TestGridSessionArtifact.wrap(buildAwsValue())
}
object TestGridSessionArtifact {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.devicefarm.model.TestGridSessionArtifact
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.devicefarm.model.TestGridSessionArtifact =
      zio.aws.devicefarm.model.TestGridSessionArtifact(
        filename.map(value => value),
        `type`.map(value => value),
        url.map(value => value)
      )
    def filename: Option[String]
    def `type`: Option[zio.aws.devicefarm.model.TestGridSessionArtifactType]
    def url: Option[SensitiveString]
    def getFilename: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("filename", filename)
    def getType: ZIO[
      Any,
      AwsError,
      zio.aws.devicefarm.model.TestGridSessionArtifactType
    ] = AwsError.unwrapOptionField("type", `type`)
    def getUrl: ZIO[Any, AwsError, SensitiveString] =
      AwsError.unwrapOptionField("url", url)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.devicefarm.model.TestGridSessionArtifact
  ) extends zio.aws.devicefarm.model.TestGridSessionArtifact.ReadOnly {
    override val filename: Option[String] =
      scala.Option(impl.filename()).map(value => value: String)
    override val `type`
        : Option[zio.aws.devicefarm.model.TestGridSessionArtifactType] = scala
      .Option(impl.`type`())
      .map(value =>
        zio.aws.devicefarm.model.TestGridSessionArtifactType.wrap(value)
      )
    override val url: Option[SensitiveString] = scala
      .Option(impl.url())
      .map(value => zio.aws.devicefarm.model.primitives.SensitiveString(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.devicefarm.model.TestGridSessionArtifact
  ): zio.aws.devicefarm.model.TestGridSessionArtifact.ReadOnly = new Wrapper(
    impl
  )
}
