package zio.aws.devicefarm.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters.*
final case class TrialMinutes(
    total: Option[Double] = None,
    remaining: Option[Double] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.devicefarm.model.TrialMinutes = {
    import TrialMinutes.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.devicefarm.model.TrialMinutes
      .builder()
      .optionallyWith(total.map(value => value: java.lang.Double))(_.total)
      .optionallyWith(remaining.map(value => value: java.lang.Double))(
        _.remaining
      )
      .build()
  }
  def asReadOnly: zio.aws.devicefarm.model.TrialMinutes.ReadOnly =
    zio.aws.devicefarm.model.TrialMinutes.wrap(buildAwsValue())
}
object TrialMinutes {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.devicefarm.model.TrialMinutes
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.devicefarm.model.TrialMinutes =
      zio.aws.devicefarm.model
        .TrialMinutes(total.map(value => value), remaining.map(value => value))
    def total: Option[Double]
    def remaining: Option[Double]
    def getTotal: ZIO[Any, AwsError, Double] =
      AwsError.unwrapOptionField("total", total)
    def getRemaining: ZIO[Any, AwsError, Double] =
      AwsError.unwrapOptionField("remaining", remaining)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.devicefarm.model.TrialMinutes
  ) extends zio.aws.devicefarm.model.TrialMinutes.ReadOnly {
    override val total: Option[Double] =
      scala.Option(impl.total()).map(value => value: Double)
    override val remaining: Option[Double] =
      scala.Option(impl.remaining()).map(value => value: Double)
  }
  def wrap(
      impl: software.amazon.awssdk.services.devicefarm.model.TrialMinutes
  ): zio.aws.devicefarm.model.TrialMinutes.ReadOnly = new Wrapper(impl)
}
