package zio.aws.devicefarm.model
import zio.aws.devicefarm.model.primitives.Message
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters.*
final case class UniqueProblem(
    message: Option[Message] = None,
    problems: Option[Iterable[zio.aws.devicefarm.model.Problem]] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.devicefarm.model.UniqueProblem = {
    import UniqueProblem.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.devicefarm.model.UniqueProblem
      .builder()
      .optionallyWith(
        message.map(value => Message.unwrap(value): java.lang.String)
      )(_.message)
      .optionallyWith(
        problems.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.problems)
      .build()
  }
  def asReadOnly: zio.aws.devicefarm.model.UniqueProblem.ReadOnly =
    zio.aws.devicefarm.model.UniqueProblem.wrap(buildAwsValue())
}
object UniqueProblem {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.devicefarm.model.UniqueProblem
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.devicefarm.model.UniqueProblem =
      zio.aws.devicefarm.model.UniqueProblem(
        message.map(value => value),
        problems.map(value =>
          value.map { item =>
            item.asEditable
          }
        )
      )
    def message: Option[Message]
    def problems: Option[List[zio.aws.devicefarm.model.Problem.ReadOnly]]
    def getMessage: ZIO[Any, AwsError, Message] =
      AwsError.unwrapOptionField("message", message)
    def getProblems
        : ZIO[Any, AwsError, List[zio.aws.devicefarm.model.Problem.ReadOnly]] =
      AwsError.unwrapOptionField("problems", problems)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.devicefarm.model.UniqueProblem
  ) extends zio.aws.devicefarm.model.UniqueProblem.ReadOnly {
    override val message: Option[Message] = scala
      .Option(impl.message())
      .map(value => zio.aws.devicefarm.model.primitives.Message(value))
    override val problems
        : Option[List[zio.aws.devicefarm.model.Problem.ReadOnly]] = scala
      .Option(impl.problems())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.devicefarm.model.Problem.wrap(item)
        }.toList
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.devicefarm.model.UniqueProblem
  ): zio.aws.devicefarm.model.UniqueProblem.ReadOnly = new Wrapper(impl)
}
