package zio.aws.devicefarm.model
import zio.aws.devicefarm.model.primitives.{TagKey, DeviceFarmArn}
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters.*
final case class UntagResourceRequest(
    resourceARN: DeviceFarmArn,
    tagKeys: Iterable[TagKey]
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.devicefarm.model.UntagResourceRequest = {
    import UntagResourceRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.devicefarm.model.UntagResourceRequest
      .builder()
      .resourceARN(DeviceFarmArn.unwrap(resourceARN): java.lang.String)
      .tagKeys(tagKeys.map { item =>
        TagKey.unwrap(item): java.lang.String
      }.asJavaCollection)
      .build()
  }
  def asReadOnly: zio.aws.devicefarm.model.UntagResourceRequest.ReadOnly =
    zio.aws.devicefarm.model.UntagResourceRequest.wrap(buildAwsValue())
}
object UntagResourceRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.devicefarm.model.UntagResourceRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.devicefarm.model.UntagResourceRequest =
      zio.aws.devicefarm.model.UntagResourceRequest(resourceARN, tagKeys)
    def resourceARN: DeviceFarmArn
    def tagKeys: List[TagKey]
    def getResourceARN: ZIO[Any, Nothing, DeviceFarmArn] =
      ZIO.succeed(resourceARN)
    def getTagKeys: ZIO[Any, Nothing, List[TagKey]] = ZIO.succeed(tagKeys)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.devicefarm.model.UntagResourceRequest
  ) extends zio.aws.devicefarm.model.UntagResourceRequest.ReadOnly {
    override val resourceARN: DeviceFarmArn =
      zio.aws.devicefarm.model.primitives.DeviceFarmArn(impl.resourceARN())
    override val tagKeys: List[TagKey] = impl
      .tagKeys()
      .asScala
      .map { item =>
        zio.aws.devicefarm.model.primitives.TagKey(item)
      }
      .toList
  }
  def wrap(
      impl: software.amazon.awssdk.services.devicefarm.model.UntagResourceRequest
  ): zio.aws.devicefarm.model.UntagResourceRequest.ReadOnly = new Wrapper(impl)
}
