package zio.aws.devicefarm.model
import zio.aws.devicefarm.model.primitives.AmazonResourceName
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters.*
final case class UpdateDeviceInstanceRequest(
    arn: AmazonResourceName,
    profileArn: Option[AmazonResourceName] = None,
    labels: Option[Iterable[String]] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.devicefarm.model.UpdateDeviceInstanceRequest = {
    import UpdateDeviceInstanceRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.devicefarm.model.UpdateDeviceInstanceRequest
      .builder()
      .arn(AmazonResourceName.unwrap(arn): java.lang.String)
      .optionallyWith(
        profileArn.map(value =>
          AmazonResourceName.unwrap(value): java.lang.String
        )
      )(_.profileArn)
      .optionallyWith(
        labels.map(value =>
          value.map { item =>
            item: java.lang.String
          }.asJavaCollection
        )
      )(_.labels)
      .build()
  }
  def asReadOnly
      : zio.aws.devicefarm.model.UpdateDeviceInstanceRequest.ReadOnly =
    zio.aws.devicefarm.model.UpdateDeviceInstanceRequest.wrap(buildAwsValue())
}
object UpdateDeviceInstanceRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.devicefarm.model.UpdateDeviceInstanceRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.devicefarm.model.UpdateDeviceInstanceRequest =
      zio.aws.devicefarm.model.UpdateDeviceInstanceRequest(
        arn,
        profileArn.map(value => value),
        labels.map(value => value)
      )
    def arn: AmazonResourceName
    def profileArn: Option[AmazonResourceName]
    def labels: Option[List[String]]
    def getArn: ZIO[Any, Nothing, AmazonResourceName] = ZIO.succeed(arn)
    def getProfileArn: ZIO[Any, AwsError, AmazonResourceName] =
      AwsError.unwrapOptionField("profileArn", profileArn)
    def getLabels: ZIO[Any, AwsError, List[String]] =
      AwsError.unwrapOptionField("labels", labels)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.devicefarm.model.UpdateDeviceInstanceRequest
  ) extends zio.aws.devicefarm.model.UpdateDeviceInstanceRequest.ReadOnly {
    override val arn: AmazonResourceName =
      zio.aws.devicefarm.model.primitives.AmazonResourceName(impl.arn())
    override val profileArn: Option[AmazonResourceName] = scala
      .Option(impl.profileArn())
      .map(value =>
        zio.aws.devicefarm.model.primitives.AmazonResourceName(value)
      )
    override val labels: Option[List[String]] = scala
      .Option(impl.labels())
      .map(value =>
        value.asScala.map { item =>
          item: String
        }.toList
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.devicefarm.model.UpdateDeviceInstanceRequest
  ): zio.aws.devicefarm.model.UpdateDeviceInstanceRequest.ReadOnly =
    new Wrapper(impl)
}
