package zio.aws.devicefarm.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters.*
final case class UpdateDevicePoolResponse(
    devicePool: Option[zio.aws.devicefarm.model.DevicePool] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.devicefarm.model.UpdateDevicePoolResponse = {
    import UpdateDevicePoolResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.devicefarm.model.UpdateDevicePoolResponse
      .builder()
      .optionallyWith(devicePool.map(value => value.buildAwsValue()))(
        _.devicePool
      )
      .build()
  }
  def asReadOnly: zio.aws.devicefarm.model.UpdateDevicePoolResponse.ReadOnly =
    zio.aws.devicefarm.model.UpdateDevicePoolResponse.wrap(buildAwsValue())
}
object UpdateDevicePoolResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.devicefarm.model.UpdateDevicePoolResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.devicefarm.model.UpdateDevicePoolResponse =
      zio.aws.devicefarm.model
        .UpdateDevicePoolResponse(devicePool.map(value => value.asEditable))
    def devicePool: Option[zio.aws.devicefarm.model.DevicePool.ReadOnly]
    def getDevicePool
        : ZIO[Any, AwsError, zio.aws.devicefarm.model.DevicePool.ReadOnly] =
      AwsError.unwrapOptionField("devicePool", devicePool)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.devicefarm.model.UpdateDevicePoolResponse
  ) extends zio.aws.devicefarm.model.UpdateDevicePoolResponse.ReadOnly {
    override val devicePool
        : Option[zio.aws.devicefarm.model.DevicePool.ReadOnly] = scala
      .Option(impl.devicePool())
      .map(value => zio.aws.devicefarm.model.DevicePool.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.devicefarm.model.UpdateDevicePoolResponse
  ): zio.aws.devicefarm.model.UpdateDevicePoolResponse.ReadOnly = new Wrapper(
    impl
  )
}
