package zio.aws.devicefarm.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters.*
final case class UpdateInstanceProfileResponse(
    instanceProfile: Option[zio.aws.devicefarm.model.InstanceProfile] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.devicefarm.model.UpdateInstanceProfileResponse = {
    import UpdateInstanceProfileResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.devicefarm.model.UpdateInstanceProfileResponse
      .builder()
      .optionallyWith(instanceProfile.map(value => value.buildAwsValue()))(
        _.instanceProfile
      )
      .build()
  }
  def asReadOnly
      : zio.aws.devicefarm.model.UpdateInstanceProfileResponse.ReadOnly =
    zio.aws.devicefarm.model.UpdateInstanceProfileResponse.wrap(buildAwsValue())
}
object UpdateInstanceProfileResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.devicefarm.model.UpdateInstanceProfileResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.devicefarm.model.UpdateInstanceProfileResponse =
      zio.aws.devicefarm.model.UpdateInstanceProfileResponse(
        instanceProfile.map(value => value.asEditable)
      )
    def instanceProfile
        : Option[zio.aws.devicefarm.model.InstanceProfile.ReadOnly]
    def getInstanceProfile: ZIO[
      Any,
      AwsError,
      zio.aws.devicefarm.model.InstanceProfile.ReadOnly
    ] = AwsError.unwrapOptionField("instanceProfile", instanceProfile)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.devicefarm.model.UpdateInstanceProfileResponse
  ) extends zio.aws.devicefarm.model.UpdateInstanceProfileResponse.ReadOnly {
    override val instanceProfile
        : Option[zio.aws.devicefarm.model.InstanceProfile.ReadOnly] = scala
      .Option(impl.instanceProfile())
      .map(value => zio.aws.devicefarm.model.InstanceProfile.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.devicefarm.model.UpdateInstanceProfileResponse
  ): zio.aws.devicefarm.model.UpdateInstanceProfileResponse.ReadOnly =
    new Wrapper(impl)
}
