package zio.aws.devicefarm.model
import zio.aws.devicefarm.model.primitives.{
  ResourceDescription,
  ResourceName,
  DeviceFarmArn
}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters.*
final case class UpdateTestGridProjectRequest(
    projectArn: DeviceFarmArn,
    name: Option[ResourceName] = None,
    description: Option[ResourceDescription] = None,
    vpcConfig: Option[zio.aws.devicefarm.model.TestGridVpcConfig] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.devicefarm.model.UpdateTestGridProjectRequest = {
    import UpdateTestGridProjectRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.devicefarm.model.UpdateTestGridProjectRequest
      .builder()
      .projectArn(DeviceFarmArn.unwrap(projectArn): java.lang.String)
      .optionallyWith(
        name.map(value => ResourceName.unwrap(value): java.lang.String)
      )(_.name)
      .optionallyWith(
        description.map(value =>
          ResourceDescription.unwrap(value): java.lang.String
        )
      )(_.description)
      .optionallyWith(vpcConfig.map(value => value.buildAwsValue()))(
        _.vpcConfig
      )
      .build()
  }
  def asReadOnly
      : zio.aws.devicefarm.model.UpdateTestGridProjectRequest.ReadOnly =
    zio.aws.devicefarm.model.UpdateTestGridProjectRequest.wrap(buildAwsValue())
}
object UpdateTestGridProjectRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.devicefarm.model.UpdateTestGridProjectRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.devicefarm.model.UpdateTestGridProjectRequest =
      zio.aws.devicefarm.model.UpdateTestGridProjectRequest(
        projectArn,
        name.map(value => value),
        description.map(value => value),
        vpcConfig.map(value => value.asEditable)
      )
    def projectArn: DeviceFarmArn
    def name: Option[ResourceName]
    def description: Option[ResourceDescription]
    def vpcConfig: Option[zio.aws.devicefarm.model.TestGridVpcConfig.ReadOnly]
    def getProjectArn: ZIO[Any, Nothing, DeviceFarmArn] =
      ZIO.succeed(projectArn)
    def getName: ZIO[Any, AwsError, ResourceName] =
      AwsError.unwrapOptionField("name", name)
    def getDescription: ZIO[Any, AwsError, ResourceDescription] =
      AwsError.unwrapOptionField("description", description)
    def getVpcConfig: ZIO[
      Any,
      AwsError,
      zio.aws.devicefarm.model.TestGridVpcConfig.ReadOnly
    ] = AwsError.unwrapOptionField("vpcConfig", vpcConfig)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.devicefarm.model.UpdateTestGridProjectRequest
  ) extends zio.aws.devicefarm.model.UpdateTestGridProjectRequest.ReadOnly {
    override val projectArn: DeviceFarmArn =
      zio.aws.devicefarm.model.primitives.DeviceFarmArn(impl.projectArn())
    override val name: Option[ResourceName] = scala
      .Option(impl.name())
      .map(value => zio.aws.devicefarm.model.primitives.ResourceName(value))
    override val description: Option[ResourceDescription] = scala
      .Option(impl.description())
      .map(value =>
        zio.aws.devicefarm.model.primitives.ResourceDescription(value)
      )
    override val vpcConfig
        : Option[zio.aws.devicefarm.model.TestGridVpcConfig.ReadOnly] = scala
      .Option(impl.vpcConfig())
      .map(value => zio.aws.devicefarm.model.TestGridVpcConfig.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.devicefarm.model.UpdateTestGridProjectRequest
  ): zio.aws.devicefarm.model.UpdateTestGridProjectRequest.ReadOnly =
    new Wrapper(impl)
}
