package zio.aws.devicefarm.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters.*
final case class UpdateUploadResponse(
    upload: Option[zio.aws.devicefarm.model.Upload] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.devicefarm.model.UpdateUploadResponse = {
    import UpdateUploadResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.devicefarm.model.UpdateUploadResponse
      .builder()
      .optionallyWith(upload.map(value => value.buildAwsValue()))(_.upload)
      .build()
  }
  def asReadOnly: zio.aws.devicefarm.model.UpdateUploadResponse.ReadOnly =
    zio.aws.devicefarm.model.UpdateUploadResponse.wrap(buildAwsValue())
}
object UpdateUploadResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.devicefarm.model.UpdateUploadResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.devicefarm.model.UpdateUploadResponse =
      zio.aws.devicefarm.model
        .UpdateUploadResponse(upload.map(value => value.asEditable))
    def upload: Option[zio.aws.devicefarm.model.Upload.ReadOnly]
    def getUpload
        : ZIO[Any, AwsError, zio.aws.devicefarm.model.Upload.ReadOnly] =
      AwsError.unwrapOptionField("upload", upload)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.devicefarm.model.UpdateUploadResponse
  ) extends zio.aws.devicefarm.model.UpdateUploadResponse.ReadOnly {
    override val upload: Option[zio.aws.devicefarm.model.Upload.ReadOnly] =
      scala
        .Option(impl.upload())
        .map(value => zio.aws.devicefarm.model.Upload.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.devicefarm.model.UpdateUploadResponse
  ): zio.aws.devicefarm.model.UpdateUploadResponse.ReadOnly = new Wrapper(impl)
}
