package zio.aws.devicefarm.model
import zio.aws.devicefarm.model.primitives.{
  ContentType,
  SensitiveURL,
  Message,
  DateTime,
  AmazonResourceName,
  Name,
  Metadata
}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import java.time.Instant
import scala.jdk.CollectionConverters.*
final case class Upload(
    arn: Option[AmazonResourceName] = None,
    name: Option[Name] = None,
    created: Option[DateTime] = None,
    `type`: Option[zio.aws.devicefarm.model.UploadType] = None,
    status: Option[zio.aws.devicefarm.model.UploadStatus] = None,
    url: Option[SensitiveURL] = None,
    metadata: Option[Metadata] = None,
    contentType: Option[ContentType] = None,
    message: Option[Message] = None,
    category: Option[zio.aws.devicefarm.model.UploadCategory] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.devicefarm.model.Upload = {
    import Upload.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.devicefarm.model.Upload
      .builder()
      .optionallyWith(
        arn.map(value => AmazonResourceName.unwrap(value): java.lang.String)
      )(_.arn)
      .optionallyWith(name.map(value => Name.unwrap(value): java.lang.String))(
        _.name
      )
      .optionallyWith(created.map(value => DateTime.unwrap(value): Instant))(
        _.created
      )
      .optionallyWith(`type`.map(value => value.unwrap))(_.`type`)
      .optionallyWith(status.map(value => value.unwrap))(_.status)
      .optionallyWith(
        url.map(value => SensitiveURL.unwrap(value): java.lang.String)
      )(_.url)
      .optionallyWith(
        metadata.map(value => Metadata.unwrap(value): java.lang.String)
      )(_.metadata)
      .optionallyWith(
        contentType.map(value => ContentType.unwrap(value): java.lang.String)
      )(_.contentType)
      .optionallyWith(
        message.map(value => Message.unwrap(value): java.lang.String)
      )(_.message)
      .optionallyWith(category.map(value => value.unwrap))(_.category)
      .build()
  }
  def asReadOnly: zio.aws.devicefarm.model.Upload.ReadOnly =
    zio.aws.devicefarm.model.Upload.wrap(buildAwsValue())
}
object Upload {
  private lazy val zioAwsBuilderHelper
      : BuilderHelper[software.amazon.awssdk.services.devicefarm.model.Upload] =
    BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.devicefarm.model.Upload =
      zio.aws.devicefarm.model.Upload(
        arn.map(value => value),
        name.map(value => value),
        created.map(value => value),
        `type`.map(value => value),
        status.map(value => value),
        url.map(value => value),
        metadata.map(value => value),
        contentType.map(value => value),
        message.map(value => value),
        category.map(value => value)
      )
    def arn: Option[AmazonResourceName]
    def name: Option[Name]
    def created: Option[DateTime]
    def `type`: Option[zio.aws.devicefarm.model.UploadType]
    def status: Option[zio.aws.devicefarm.model.UploadStatus]
    def url: Option[SensitiveURL]
    def metadata: Option[Metadata]
    def contentType: Option[ContentType]
    def message: Option[Message]
    def category: Option[zio.aws.devicefarm.model.UploadCategory]
    def getArn: ZIO[Any, AwsError, AmazonResourceName] =
      AwsError.unwrapOptionField("arn", arn)
    def getName: ZIO[Any, AwsError, Name] =
      AwsError.unwrapOptionField("name", name)
    def getCreated: ZIO[Any, AwsError, DateTime] =
      AwsError.unwrapOptionField("created", created)
    def getType: ZIO[Any, AwsError, zio.aws.devicefarm.model.UploadType] =
      AwsError.unwrapOptionField("type", `type`)
    def getStatus: ZIO[Any, AwsError, zio.aws.devicefarm.model.UploadStatus] =
      AwsError.unwrapOptionField("status", status)
    def getUrl: ZIO[Any, AwsError, SensitiveURL] =
      AwsError.unwrapOptionField("url", url)
    def getMetadata: ZIO[Any, AwsError, Metadata] =
      AwsError.unwrapOptionField("metadata", metadata)
    def getContentType: ZIO[Any, AwsError, ContentType] =
      AwsError.unwrapOptionField("contentType", contentType)
    def getMessage: ZIO[Any, AwsError, Message] =
      AwsError.unwrapOptionField("message", message)
    def getCategory
        : ZIO[Any, AwsError, zio.aws.devicefarm.model.UploadCategory] =
      AwsError.unwrapOptionField("category", category)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.devicefarm.model.Upload
  ) extends zio.aws.devicefarm.model.Upload.ReadOnly {
    override val arn: Option[AmazonResourceName] = scala
      .Option(impl.arn())
      .map(value =>
        zio.aws.devicefarm.model.primitives.AmazonResourceName(value)
      )
    override val name: Option[Name] = scala
      .Option(impl.name())
      .map(value => zio.aws.devicefarm.model.primitives.Name(value))
    override val created: Option[DateTime] = scala
      .Option(impl.created())
      .map(value => zio.aws.devicefarm.model.primitives.DateTime(value))
    override val `type`: Option[zio.aws.devicefarm.model.UploadType] = scala
      .Option(impl.`type`())
      .map(value => zio.aws.devicefarm.model.UploadType.wrap(value))
    override val status: Option[zio.aws.devicefarm.model.UploadStatus] = scala
      .Option(impl.status())
      .map(value => zio.aws.devicefarm.model.UploadStatus.wrap(value))
    override val url: Option[SensitiveURL] = scala
      .Option(impl.url())
      .map(value => zio.aws.devicefarm.model.primitives.SensitiveURL(value))
    override val metadata: Option[Metadata] = scala
      .Option(impl.metadata())
      .map(value => zio.aws.devicefarm.model.primitives.Metadata(value))
    override val contentType: Option[ContentType] = scala
      .Option(impl.contentType())
      .map(value => zio.aws.devicefarm.model.primitives.ContentType(value))
    override val message: Option[Message] = scala
      .Option(impl.message())
      .map(value => zio.aws.devicefarm.model.primitives.Message(value))
    override val category: Option[zio.aws.devicefarm.model.UploadCategory] =
      scala
        .Option(impl.category())
        .map(value => zio.aws.devicefarm.model.UploadCategory.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.devicefarm.model.Upload
  ): zio.aws.devicefarm.model.Upload.ReadOnly = new Wrapper(impl)
}
