package zio.aws.devicefarm.model
import scala.jdk.CollectionConverters.*
sealed trait UploadStatus {
  def unwrap: software.amazon.awssdk.services.devicefarm.model.UploadStatus
}
object UploadStatus {
  def wrap(
      value: software.amazon.awssdk.services.devicefarm.model.UploadStatus
  ): zio.aws.devicefarm.model.UploadStatus = value match {
    case software.amazon.awssdk.services.devicefarm.model.UploadStatus.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.devicefarm.model.UploadStatus.INITIALIZED =>
      val r = INITIALIZED
      r
    case software.amazon.awssdk.services.devicefarm.model.UploadStatus.PROCESSING =>
      val r = PROCESSING
      r
    case software.amazon.awssdk.services.devicefarm.model.UploadStatus.SUCCEEDED =>
      val r = SUCCEEDED
      r
    case software.amazon.awssdk.services.devicefarm.model.UploadStatus.FAILED =>
      val r = FAILED
      r
  }
  case object unknownToSdkVersion
      extends zio.aws.devicefarm.model.UploadStatus {
    override def unwrap
        : software.amazon.awssdk.services.devicefarm.model.UploadStatus =
      software.amazon.awssdk.services.devicefarm.model.UploadStatus.UNKNOWN_TO_SDK_VERSION
  }
  case object INITIALIZED extends zio.aws.devicefarm.model.UploadStatus {
    override def unwrap
        : software.amazon.awssdk.services.devicefarm.model.UploadStatus =
      software.amazon.awssdk.services.devicefarm.model.UploadStatus.INITIALIZED
  }
  case object PROCESSING extends zio.aws.devicefarm.model.UploadStatus {
    override def unwrap
        : software.amazon.awssdk.services.devicefarm.model.UploadStatus =
      software.amazon.awssdk.services.devicefarm.model.UploadStatus.PROCESSING
  }
  case object SUCCEEDED extends zio.aws.devicefarm.model.UploadStatus {
    override def unwrap
        : software.amazon.awssdk.services.devicefarm.model.UploadStatus =
      software.amazon.awssdk.services.devicefarm.model.UploadStatus.SUCCEEDED
  }
  case object FAILED extends zio.aws.devicefarm.model.UploadStatus {
    override def unwrap
        : software.amazon.awssdk.services.devicefarm.model.UploadStatus =
      software.amazon.awssdk.services.devicefarm.model.UploadStatus.FAILED
  }
}
