package zio.aws.devicefarm.model
import zio.aws.devicefarm.model.primitives.{
  ServiceDnsName,
  VPCEConfigurationName,
  AmazonResourceName,
  VPCEServiceName,
  VPCEConfigurationDescription
}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters.*
final case class VPCEConfiguration(
    arn: Option[AmazonResourceName] = None,
    vpceConfigurationName: Option[VPCEConfigurationName] = None,
    vpceServiceName: Option[VPCEServiceName] = None,
    serviceDnsName: Option[ServiceDnsName] = None,
    vpceConfigurationDescription: Option[VPCEConfigurationDescription] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.devicefarm.model.VPCEConfiguration = {
    import VPCEConfiguration.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.devicefarm.model.VPCEConfiguration
      .builder()
      .optionallyWith(
        arn.map(value => AmazonResourceName.unwrap(value): java.lang.String)
      )(_.arn)
      .optionallyWith(
        vpceConfigurationName.map(value =>
          VPCEConfigurationName.unwrap(value): java.lang.String
        )
      )(_.vpceConfigurationName)
      .optionallyWith(
        vpceServiceName.map(value =>
          VPCEServiceName.unwrap(value): java.lang.String
        )
      )(_.vpceServiceName)
      .optionallyWith(
        serviceDnsName.map(value =>
          ServiceDnsName.unwrap(value): java.lang.String
        )
      )(_.serviceDnsName)
      .optionallyWith(
        vpceConfigurationDescription.map(value =>
          VPCEConfigurationDescription.unwrap(value): java.lang.String
        )
      )(_.vpceConfigurationDescription)
      .build()
  }
  def asReadOnly: zio.aws.devicefarm.model.VPCEConfiguration.ReadOnly =
    zio.aws.devicefarm.model.VPCEConfiguration.wrap(buildAwsValue())
}
object VPCEConfiguration {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.devicefarm.model.VPCEConfiguration
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.devicefarm.model.VPCEConfiguration =
      zio.aws.devicefarm.model.VPCEConfiguration(
        arn.map(value => value),
        vpceConfigurationName.map(value => value),
        vpceServiceName.map(value => value),
        serviceDnsName.map(value => value),
        vpceConfigurationDescription.map(value => value)
      )
    def arn: Option[AmazonResourceName]
    def vpceConfigurationName: Option[VPCEConfigurationName]
    def vpceServiceName: Option[VPCEServiceName]
    def serviceDnsName: Option[ServiceDnsName]
    def vpceConfigurationDescription: Option[VPCEConfigurationDescription]
    def getArn: ZIO[Any, AwsError, AmazonResourceName] =
      AwsError.unwrapOptionField("arn", arn)
    def getVpceConfigurationName: ZIO[Any, AwsError, VPCEConfigurationName] =
      AwsError.unwrapOptionField("vpceConfigurationName", vpceConfigurationName)
    def getVpceServiceName: ZIO[Any, AwsError, VPCEServiceName] =
      AwsError.unwrapOptionField("vpceServiceName", vpceServiceName)
    def getServiceDnsName: ZIO[Any, AwsError, ServiceDnsName] =
      AwsError.unwrapOptionField("serviceDnsName", serviceDnsName)
    def getVpceConfigurationDescription
        : ZIO[Any, AwsError, VPCEConfigurationDescription] =
      AwsError.unwrapOptionField(
        "vpceConfigurationDescription",
        vpceConfigurationDescription
      )
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.devicefarm.model.VPCEConfiguration
  ) extends zio.aws.devicefarm.model.VPCEConfiguration.ReadOnly {
    override val arn: Option[AmazonResourceName] = scala
      .Option(impl.arn())
      .map(value =>
        zio.aws.devicefarm.model.primitives.AmazonResourceName(value)
      )
    override val vpceConfigurationName: Option[VPCEConfigurationName] = scala
      .Option(impl.vpceConfigurationName())
      .map(value =>
        zio.aws.devicefarm.model.primitives.VPCEConfigurationName(value)
      )
    override val vpceServiceName: Option[VPCEServiceName] = scala
      .Option(impl.vpceServiceName())
      .map(value => zio.aws.devicefarm.model.primitives.VPCEServiceName(value))
    override val serviceDnsName: Option[ServiceDnsName] = scala
      .Option(impl.serviceDnsName())
      .map(value => zio.aws.devicefarm.model.primitives.ServiceDnsName(value))
    override val vpceConfigurationDescription
        : Option[VPCEConfigurationDescription] = scala
      .Option(impl.vpceConfigurationDescription())
      .map(value =>
        zio.aws.devicefarm.model.primitives.VPCEConfigurationDescription(value)
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.devicefarm.model.VPCEConfiguration
  ): zio.aws.devicefarm.model.VPCEConfiguration.ReadOnly = new Wrapper(impl)
}
