package zio.aws.devopsguru.model
import java.lang.Integer
import zio.aws.devopsguru.model.primitives.{
  AwsAccountId,
  UuidNextToken,
  ListAnomaliesForInsightMaxResults,
  InsightId
}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters.*
final case class ListAnomaliesForInsightRequest(
    insightId: InsightId,
    startTimeRange: Option[zio.aws.devopsguru.model.StartTimeRange] = None,
    maxResults: Option[ListAnomaliesForInsightMaxResults] = None,
    nextToken: Option[UuidNextToken] = None,
    accountId: Option[AwsAccountId] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.devopsguru.model.ListAnomaliesForInsightRequest = {
    import ListAnomaliesForInsightRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.devopsguru.model.ListAnomaliesForInsightRequest
      .builder()
      .insightId(InsightId.unwrap(insightId): java.lang.String)
      .optionallyWith(startTimeRange.map(value => value.buildAwsValue()))(
        _.startTimeRange
      )
      .optionallyWith(
        maxResults.map(value =>
          ListAnomaliesForInsightMaxResults.unwrap(value): Integer
        )
      )(_.maxResults)
      .optionallyWith(
        nextToken.map(value => UuidNextToken.unwrap(value): java.lang.String)
      )(_.nextToken)
      .optionallyWith(
        accountId.map(value => AwsAccountId.unwrap(value): java.lang.String)
      )(_.accountId)
      .build()
  }
  def asReadOnly
      : zio.aws.devopsguru.model.ListAnomaliesForInsightRequest.ReadOnly =
    zio.aws.devopsguru.model.ListAnomaliesForInsightRequest
      .wrap(buildAwsValue())
}
object ListAnomaliesForInsightRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.devopsguru.model.ListAnomaliesForInsightRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.devopsguru.model.ListAnomaliesForInsightRequest =
      zio.aws.devopsguru.model.ListAnomaliesForInsightRequest(
        insightId,
        startTimeRange.map(value => value.asEditable),
        maxResults.map(value => value),
        nextToken.map(value => value),
        accountId.map(value => value)
      )
    def insightId: InsightId
    def startTimeRange: Option[zio.aws.devopsguru.model.StartTimeRange.ReadOnly]
    def maxResults: Option[ListAnomaliesForInsightMaxResults]
    def nextToken: Option[UuidNextToken]
    def accountId: Option[AwsAccountId]
    def getInsightId: ZIO[Any, Nothing, InsightId] = ZIO.succeed(insightId)
    def getStartTimeRange
        : ZIO[Any, AwsError, zio.aws.devopsguru.model.StartTimeRange.ReadOnly] =
      AwsError.unwrapOptionField("startTimeRange", startTimeRange)
    def getMaxResults: ZIO[Any, AwsError, ListAnomaliesForInsightMaxResults] =
      AwsError.unwrapOptionField("maxResults", maxResults)
    def getNextToken: ZIO[Any, AwsError, UuidNextToken] =
      AwsError.unwrapOptionField("nextToken", nextToken)
    def getAccountId: ZIO[Any, AwsError, AwsAccountId] =
      AwsError.unwrapOptionField("accountId", accountId)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.devopsguru.model.ListAnomaliesForInsightRequest
  ) extends zio.aws.devopsguru.model.ListAnomaliesForInsightRequest.ReadOnly {
    override val insightId: InsightId =
      zio.aws.devopsguru.model.primitives.InsightId(impl.insightId())
    override val startTimeRange
        : Option[zio.aws.devopsguru.model.StartTimeRange.ReadOnly] = scala
      .Option(impl.startTimeRange())
      .map(value => zio.aws.devopsguru.model.StartTimeRange.wrap(value))
    override val maxResults: Option[ListAnomaliesForInsightMaxResults] = scala
      .Option(impl.maxResults())
      .map(value =>
        zio.aws.devopsguru.model.primitives
          .ListAnomaliesForInsightMaxResults(value)
      )
    override val nextToken: Option[UuidNextToken] = scala
      .Option(impl.nextToken())
      .map(value => zio.aws.devopsguru.model.primitives.UuidNextToken(value))
    override val accountId: Option[AwsAccountId] = scala
      .Option(impl.accountId())
      .map(value => zio.aws.devopsguru.model.primitives.AwsAccountId(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.devopsguru.model.ListAnomaliesForInsightRequest
  ): zio.aws.devopsguru.model.ListAnomaliesForInsightRequest.ReadOnly =
    new Wrapper(impl)
}
