package zio.aws.devopsguru.model
import zio.aws.devopsguru.model.primitives.ClientToken
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters.*
final case class StartCostEstimationRequest(
    resourceCollection: zio.aws.devopsguru.model.CostEstimationResourceCollectionFilter,
    clientToken: Option[ClientToken] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.devopsguru.model.StartCostEstimationRequest = {
    import StartCostEstimationRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.devopsguru.model.StartCostEstimationRequest
      .builder()
      .resourceCollection(resourceCollection.buildAwsValue())
      .optionallyWith(
        clientToken.map(value => ClientToken.unwrap(value): java.lang.String)
      )(_.clientToken)
      .build()
  }
  def asReadOnly: zio.aws.devopsguru.model.StartCostEstimationRequest.ReadOnly =
    zio.aws.devopsguru.model.StartCostEstimationRequest.wrap(buildAwsValue())
}
object StartCostEstimationRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.devopsguru.model.StartCostEstimationRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.devopsguru.model.StartCostEstimationRequest =
      zio.aws.devopsguru.model.StartCostEstimationRequest(
        resourceCollection.asEditable,
        clientToken.map(value => value)
      )
    def resourceCollection
        : zio.aws.devopsguru.model.CostEstimationResourceCollectionFilter.ReadOnly
    def clientToken: Option[ClientToken]
    def getResourceCollection: ZIO[
      Any,
      Nothing,
      zio.aws.devopsguru.model.CostEstimationResourceCollectionFilter.ReadOnly
    ] = ZIO.succeed(resourceCollection)
    def getClientToken: ZIO[Any, AwsError, ClientToken] =
      AwsError.unwrapOptionField("clientToken", clientToken)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.devopsguru.model.StartCostEstimationRequest
  ) extends zio.aws.devopsguru.model.StartCostEstimationRequest.ReadOnly {
    override val resourceCollection
        : zio.aws.devopsguru.model.CostEstimationResourceCollectionFilter.ReadOnly =
      zio.aws.devopsguru.model.CostEstimationResourceCollectionFilter
        .wrap(impl.resourceCollection())
    override val clientToken: Option[ClientToken] = scala
      .Option(impl.clientToken())
      .map(value => zio.aws.devopsguru.model.primitives.ClientToken(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.devopsguru.model.StartCostEstimationRequest
  ): zio.aws.devopsguru.model.StartCostEstimationRequest.ReadOnly = new Wrapper(
    impl
  )
}
