package zio.aws.devopsguru
import zio.aws.devopsguru.model.{
  GetCostEstimationRequest,
  UpdateEventSourcesConfigRequest,
  ListNotificationChannelsRequest,
  DescribeInsightRequest,
  ListRecommendationsRequest,
  SearchInsightsRequest,
  UpdateResourceCollectionRequest,
  DescribeOrganizationResourceCollectionHealthRequest,
  ListAnomalousLogGroupsRequest,
  DeleteInsightRequest,
  DescribeAccountHealthRequest,
  DescribeAnomalyRequest,
  ListEventsRequest,
  SearchOrganizationInsightsRequest,
  ListOrganizationInsightsRequest,
  UpdateServiceIntegrationRequest,
  DescribeFeedbackRequest,
  DescribeAccountOverviewRequest,
  DescribeOrganizationOverviewRequest,
  GetResourceCollectionRequest,
  DescribeEventSourcesConfigRequest,
  ListMonitoredResourcesRequest,
  ListAnomaliesForInsightRequest,
  ListInsightsRequest,
  DescribeServiceIntegrationRequest,
  StartCostEstimationRequest,
  PutFeedbackRequest,
  RemoveNotificationChannelRequest,
  DescribeOrganizationHealthRequest,
  DescribeResourceCollectionHealthRequest,
  AddNotificationChannelRequest
}
import zio.aws.devopsguru.model.DescribeAccountHealthResponse.ReadOnly
import zio.aws.core.config.AwsConfig
import software.amazon.awssdk.services.devopsguru.paginators.{
  SearchOrganizationInsightsPublisher,
  DescribeOrganizationResourceCollectionHealthPublisher,
  ListOrganizationInsightsPublisher,
  DescribeResourceCollectionHealthPublisher,
  ListAnomaliesForInsightPublisher,
  SearchInsightsPublisher,
  ListInsightsPublisher
}
import software.amazon.awssdk.services.devopsguru.{
  DevOpsGuruAsyncClientBuilder,
  DevOpsGuruAsyncClient
}
import zio.aws.core.{AwsServiceBase, StreamingOutputResult, AwsError}
import zio.aws.core.aspects.{AwsCallAspect, AspectSupport}
import zio.{ZEnvironment, IO, ZIO, ZLayer, Scope}
import software.amazon.awssdk.services.devopsguru.model.{
  DescribeOrganizationOverviewResponse,
  AnomalousLogGroup,
  GetCostEstimationResponse,
  ReactiveAnomalySummary,
  DescribeAnomalyResponse,
  GetResourceCollectionResponse,
  SearchOrganizationInsightsResponse,
  ListNotificationChannelsResponse,
  StartCostEstimationResponse,
  DescribeEventSourcesConfigResponse,
  MonitoredResourceIdentifier,
  ListEventsResponse,
  ListAnomalousLogGroupsResponse,
  DescribeResourceCollectionHealthResponse,
  SearchInsightsResponse,
  DescribeServiceIntegrationResponse,
  ProactiveOrganizationInsightSummary,
  UpdateResourceCollectionResponse,
  AddNotificationChannelResponse,
  ListAnomaliesForInsightResponse,
  DeleteInsightResponse,
  DescribeAccountOverviewResponse,
  RemoveNotificationChannelResponse,
  UpdateServiceIntegrationResponse,
  Recommendation,
  DescribeAccountHealthResponse,
  DescribeFeedbackResponse,
  ListInsightsResponse,
  DescribeOrganizationResourceCollectionHealthResponse,
  Event,
  ProactiveInsightSummary,
  NotificationChannel,
  ListMonitoredResourcesResponse,
  DescribeOrganizationHealthResponse,
  PutFeedbackResponse,
  ListOrganizationInsightsResponse,
  ListRecommendationsResponse,
  ServiceResourceCost,
  UpdateEventSourcesConfigResponse,
  DescribeInsightResponse,
  CloudFormationHealth
}
import zio.stream.ZStream
import scala.jdk.CollectionConverters.*
trait DevOpsGuru extends AspectSupport[DevOpsGuru] {
  val api: DevOpsGuruAsyncClient
  def describeServiceIntegration(
      request: DescribeServiceIntegrationRequest
  ): IO[
    AwsError,
    zio.aws.devopsguru.model.DescribeServiceIntegrationResponse.ReadOnly
  ]
  def describeEventSourcesConfig(
      request: DescribeEventSourcesConfigRequest
  ): IO[
    AwsError,
    zio.aws.devopsguru.model.DescribeEventSourcesConfigResponse.ReadOnly
  ]
  def startCostEstimation(
      request: StartCostEstimationRequest
  ): IO[AwsError, zio.aws.devopsguru.model.StartCostEstimationResponse.ReadOnly]
  def getCostEstimation(
      request: GetCostEstimationRequest
  ): ZIO[Any, AwsError, StreamingOutputResult[
    Any,
    zio.aws.devopsguru.model.GetCostEstimationResponse.ReadOnly,
    zio.aws.devopsguru.model.ServiceResourceCost.ReadOnly
  ]]
  def getCostEstimationPaginated(
      request: GetCostEstimationRequest
  ): IO[AwsError, zio.aws.devopsguru.model.GetCostEstimationResponse.ReadOnly]
  def searchInsights(request: SearchInsightsRequest): ZStream[
    Any,
    AwsError,
    zio.aws.devopsguru.model.ProactiveInsightSummary.ReadOnly
  ]
  def searchInsightsPaginated(
      request: SearchInsightsRequest
  ): IO[AwsError, zio.aws.devopsguru.model.SearchInsightsResponse.ReadOnly]
  def describeInsight(
      request: DescribeInsightRequest
  ): IO[AwsError, zio.aws.devopsguru.model.DescribeInsightResponse.ReadOnly]
  def describeAccountOverview(request: DescribeAccountOverviewRequest): IO[
    AwsError,
    zio.aws.devopsguru.model.DescribeAccountOverviewResponse.ReadOnly
  ]
  def describeResourceCollectionHealth(
      request: DescribeResourceCollectionHealthRequest
  ): ZStream[
    Any,
    AwsError,
    zio.aws.devopsguru.model.CloudFormationHealth.ReadOnly
  ]
  def describeResourceCollectionHealthPaginated(
      request: DescribeResourceCollectionHealthRequest
  ): IO[
    AwsError,
    zio.aws.devopsguru.model.DescribeResourceCollectionHealthResponse.ReadOnly
  ]
  def getResourceCollection(request: GetResourceCollectionRequest): IO[
    AwsError,
    zio.aws.devopsguru.model.GetResourceCollectionResponse.ReadOnly
  ]
  def deleteInsight(
      request: DeleteInsightRequest
  ): IO[AwsError, zio.aws.devopsguru.model.DeleteInsightResponse.ReadOnly]
  def listAnomalousLogGroups(
      request: ListAnomalousLogGroupsRequest
  ): ZIO[Any, AwsError, StreamingOutputResult[
    Any,
    zio.aws.devopsguru.model.ListAnomalousLogGroupsResponse.ReadOnly,
    zio.aws.devopsguru.model.AnomalousLogGroup.ReadOnly
  ]]
  def listAnomalousLogGroupsPaginated(
      request: ListAnomalousLogGroupsRequest
  ): IO[
    AwsError,
    zio.aws.devopsguru.model.ListAnomalousLogGroupsResponse.ReadOnly
  ]
  def listRecommendations(
      request: ListRecommendationsRequest
  ): ZStream[Any, AwsError, zio.aws.devopsguru.model.Recommendation.ReadOnly]
  def listRecommendationsPaginated(
      request: ListRecommendationsRequest
  ): IO[AwsError, zio.aws.devopsguru.model.ListRecommendationsResponse.ReadOnly]
  def listMonitoredResources(request: ListMonitoredResourcesRequest): ZStream[
    Any,
    AwsError,
    zio.aws.devopsguru.model.MonitoredResourceIdentifier.ReadOnly
  ]
  def listMonitoredResourcesPaginated(
      request: ListMonitoredResourcesRequest
  ): IO[
    AwsError,
    zio.aws.devopsguru.model.ListMonitoredResourcesResponse.ReadOnly
  ]
  def searchOrganizationInsights(
      request: SearchOrganizationInsightsRequest
  ): ZStream[
    Any,
    AwsError,
    zio.aws.devopsguru.model.ProactiveInsightSummary.ReadOnly
  ]
  def searchOrganizationInsightsPaginated(
      request: SearchOrganizationInsightsRequest
  ): IO[
    AwsError,
    zio.aws.devopsguru.model.SearchOrganizationInsightsResponse.ReadOnly
  ]
  def listEvents(
      request: ListEventsRequest
  ): ZStream[Any, AwsError, zio.aws.devopsguru.model.Event.ReadOnly]
  def listEventsPaginated(
      request: ListEventsRequest
  ): IO[AwsError, zio.aws.devopsguru.model.ListEventsResponse.ReadOnly]
  def describeAccountHealth(
      request: DescribeAccountHealthRequest
  ): IO[AwsError, ReadOnly]
  def listOrganizationInsights(
      request: ListOrganizationInsightsRequest
  ): ZStream[
    Any,
    AwsError,
    zio.aws.devopsguru.model.ProactiveOrganizationInsightSummary.ReadOnly
  ]
  def listOrganizationInsightsPaginated(
      request: ListOrganizationInsightsRequest
  ): IO[
    AwsError,
    zio.aws.devopsguru.model.ListOrganizationInsightsResponse.ReadOnly
  ]
  def removeNotificationChannel(request: RemoveNotificationChannelRequest): IO[
    AwsError,
    zio.aws.devopsguru.model.RemoveNotificationChannelResponse.ReadOnly
  ]
  def describeFeedback(
      request: DescribeFeedbackRequest
  ): IO[AwsError, zio.aws.devopsguru.model.DescribeFeedbackResponse.ReadOnly]
  def describeOrganizationOverview(
      request: DescribeOrganizationOverviewRequest
  ): IO[
    AwsError,
    zio.aws.devopsguru.model.DescribeOrganizationOverviewResponse.ReadOnly
  ]
  def updateServiceIntegration(request: UpdateServiceIntegrationRequest): IO[
    AwsError,
    zio.aws.devopsguru.model.UpdateServiceIntegrationResponse.ReadOnly
  ]
  def updateResourceCollection(request: UpdateResourceCollectionRequest): IO[
    AwsError,
    zio.aws.devopsguru.model.UpdateResourceCollectionResponse.ReadOnly
  ]
  def putFeedback(
      request: PutFeedbackRequest
  ): IO[AwsError, zio.aws.devopsguru.model.PutFeedbackResponse.ReadOnly]
  def describeOrganizationHealth(
      request: DescribeOrganizationHealthRequest
  ): IO[
    AwsError,
    zio.aws.devopsguru.model.DescribeOrganizationHealthResponse.ReadOnly
  ]
  def describeAnomaly(
      request: DescribeAnomalyRequest
  ): IO[AwsError, zio.aws.devopsguru.model.DescribeAnomalyResponse.ReadOnly]
  def addNotificationChannel(request: AddNotificationChannelRequest): IO[
    AwsError,
    zio.aws.devopsguru.model.AddNotificationChannelResponse.ReadOnly
  ]
  def updateEventSourcesConfig(request: UpdateEventSourcesConfigRequest): IO[
    AwsError,
    zio.aws.devopsguru.model.UpdateEventSourcesConfigResponse.ReadOnly
  ]
  def listInsights(request: ListInsightsRequest): ZStream[
    Any,
    AwsError,
    zio.aws.devopsguru.model.ProactiveInsightSummary.ReadOnly
  ]
  def listInsightsPaginated(
      request: ListInsightsRequest
  ): IO[AwsError, zio.aws.devopsguru.model.ListInsightsResponse.ReadOnly]
  def describeOrganizationResourceCollectionHealth(
      request: DescribeOrganizationResourceCollectionHealthRequest
  ): ZStream[
    Any,
    AwsError,
    zio.aws.devopsguru.model.CloudFormationHealth.ReadOnly
  ]
  def describeOrganizationResourceCollectionHealthPaginated(
      request: DescribeOrganizationResourceCollectionHealthRequest
  ): IO[
    AwsError,
    zio.aws.devopsguru.model.DescribeOrganizationResourceCollectionHealthResponse.ReadOnly
  ]
  def listNotificationChannels(
      request: ListNotificationChannelsRequest
  ): ZStream[
    Any,
    AwsError,
    zio.aws.devopsguru.model.NotificationChannel.ReadOnly
  ]
  def listNotificationChannelsPaginated(
      request: ListNotificationChannelsRequest
  ): IO[
    AwsError,
    zio.aws.devopsguru.model.ListNotificationChannelsResponse.ReadOnly
  ]
  def listAnomaliesForInsight(request: ListAnomaliesForInsightRequest): ZStream[
    Any,
    AwsError,
    zio.aws.devopsguru.model.ReactiveAnomalySummary.ReadOnly
  ]
  def listAnomaliesForInsightPaginated(
      request: ListAnomaliesForInsightRequest
  ): IO[
    AwsError,
    zio.aws.devopsguru.model.ListAnomaliesForInsightResponse.ReadOnly
  ]
}
object DevOpsGuru {
  val live: ZLayer[AwsConfig, java.lang.Throwable, DevOpsGuru] = customized(
    identity
  )
  def customized(
      customization: DevOpsGuruAsyncClientBuilder => DevOpsGuruAsyncClientBuilder
  ): ZLayer[AwsConfig, java.lang.Throwable, DevOpsGuru] =
    ZLayer.scoped(scoped(customization))
  def scoped(
      customization: DevOpsGuruAsyncClientBuilder => DevOpsGuruAsyncClientBuilder
  ): ZIO[AwsConfig with Scope, java.lang.Throwable, DevOpsGuru] = for (
    awsConfig <- ZIO.service[AwsConfig]; executor <- ZIO.executor;
    builder = DevOpsGuruAsyncClient
      .builder()
      .asyncConfiguration(
        software.amazon.awssdk.core.client.config.ClientAsyncConfiguration
          .builder()
          .advancedOption(
            software.amazon.awssdk.core.client.config.SdkAdvancedAsyncClientOption.FUTURE_COMPLETION_EXECUTOR,
            executor.asJava
          )
          .build()
      );
    b0 <- awsConfig
      .configure[DevOpsGuruAsyncClient, DevOpsGuruAsyncClientBuilder](builder);
    b1 <- awsConfig
      .configureHttpClient[DevOpsGuruAsyncClient, DevOpsGuruAsyncClientBuilder](
        b0,
        zio.aws.core.httpclient.ServiceHttpCapabilities(supportsHttp2 = false)
      ); client <- ZIO.attempt(customization(b1).build())
  ) yield new DevOpsGuruImpl(client, AwsCallAspect.identity, ZEnvironment.empty)
  private class DevOpsGuruImpl[R](
      override val api: DevOpsGuruAsyncClient,
      override val aspect: AwsCallAspect[R],
      r: ZEnvironment[R]
  ) extends DevOpsGuru
      with AwsServiceBase[R] {
    override val serviceName: String = "DevOpsGuru"
    override def withAspect[R1](
        newAspect: AwsCallAspect[R1],
        r: ZEnvironment[R1]
    ): DevOpsGuruImpl[R1] = new DevOpsGuruImpl(api, newAspect, r)
    def describeServiceIntegration(
        request: DescribeServiceIntegrationRequest
    ): IO[
      AwsError,
      zio.aws.devopsguru.model.DescribeServiceIntegrationResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.devopsguru.model.DescribeServiceIntegrationRequest,
      DescribeServiceIntegrationResponse
    ]("describeServiceIntegration", api.describeServiceIntegration)(
      request.buildAwsValue()
    ).map(zio.aws.devopsguru.model.DescribeServiceIntegrationResponse.wrap)
      .provideEnvironment(r)
    def describeEventSourcesConfig(
        request: DescribeEventSourcesConfigRequest
    ): IO[
      AwsError,
      zio.aws.devopsguru.model.DescribeEventSourcesConfigResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.devopsguru.model.DescribeEventSourcesConfigRequest,
      DescribeEventSourcesConfigResponse
    ]("describeEventSourcesConfig", api.describeEventSourcesConfig)(
      request.buildAwsValue()
    ).map(zio.aws.devopsguru.model.DescribeEventSourcesConfigResponse.wrap)
      .provideEnvironment(r)
    def startCostEstimation(request: StartCostEstimationRequest): IO[
      AwsError,
      zio.aws.devopsguru.model.StartCostEstimationResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.devopsguru.model.StartCostEstimationRequest,
      StartCostEstimationResponse
    ]("startCostEstimation", api.startCostEstimation)(request.buildAwsValue())
      .map(zio.aws.devopsguru.model.StartCostEstimationResponse.wrap)
      .provideEnvironment(r)
    def getCostEstimation(
        request: GetCostEstimationRequest
    ): ZIO[Any, AwsError, StreamingOutputResult[
      Any,
      zio.aws.devopsguru.model.GetCostEstimationResponse.ReadOnly,
      zio.aws.devopsguru.model.ServiceResourceCost.ReadOnly
    ]] = asyncPaginatedRequest[
      software.amazon.awssdk.services.devopsguru.model.GetCostEstimationRequest,
      GetCostEstimationResponse,
      ServiceResourceCost
    ](
      "getCostEstimation",
      api.getCostEstimation,
      (r, token) => r.toBuilder().nextToken(token).build(),
      r => scala.Option(r.nextToken()),
      r => zio.Chunk.fromIterable(r.costs().asScala)
    )(request.buildAwsValue())
      .map(result =>
        result
          .mapResponse(zio.aws.devopsguru.model.GetCostEstimationResponse.wrap)
          .mapOutput(
            _.map(item =>
              zio.aws.devopsguru.model.ServiceResourceCost.wrap(item)
            )
          )
          .provideEnvironment(r)
      )
      .provideEnvironment(r)
    def getCostEstimationPaginated(request: GetCostEstimationRequest): IO[
      AwsError,
      zio.aws.devopsguru.model.GetCostEstimationResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.devopsguru.model.GetCostEstimationRequest,
      GetCostEstimationResponse
    ]("getCostEstimation", api.getCostEstimation)(request.buildAwsValue())
      .map(zio.aws.devopsguru.model.GetCostEstimationResponse.wrap)
      .provideEnvironment(r)
    def searchInsights(request: SearchInsightsRequest): ZStream[
      Any,
      AwsError,
      zio.aws.devopsguru.model.ProactiveInsightSummary.ReadOnly
    ] = asyncJavaPaginatedRequest[
      software.amazon.awssdk.services.devopsguru.model.SearchInsightsRequest,
      ProactiveInsightSummary,
      SearchInsightsPublisher
    ]("searchInsights", api.searchInsightsPaginator, _.proactiveInsights())(
      request.buildAwsValue()
    ).map(item => zio.aws.devopsguru.model.ProactiveInsightSummary.wrap(item))
      .provideEnvironment(r)
    def searchInsightsPaginated(
        request: SearchInsightsRequest
    ): IO[AwsError, zio.aws.devopsguru.model.SearchInsightsResponse.ReadOnly] =
      asyncRequestResponse[
        software.amazon.awssdk.services.devopsguru.model.SearchInsightsRequest,
        SearchInsightsResponse
      ]("searchInsights", api.searchInsights)(request.buildAwsValue())
        .map(zio.aws.devopsguru.model.SearchInsightsResponse.wrap)
        .provideEnvironment(r)
    def describeInsight(
        request: DescribeInsightRequest
    ): IO[AwsError, zio.aws.devopsguru.model.DescribeInsightResponse.ReadOnly] =
      asyncRequestResponse[
        software.amazon.awssdk.services.devopsguru.model.DescribeInsightRequest,
        DescribeInsightResponse
      ]("describeInsight", api.describeInsight)(request.buildAwsValue())
        .map(zio.aws.devopsguru.model.DescribeInsightResponse.wrap)
        .provideEnvironment(r)
    def describeAccountOverview(request: DescribeAccountOverviewRequest): IO[
      AwsError,
      zio.aws.devopsguru.model.DescribeAccountOverviewResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.devopsguru.model.DescribeAccountOverviewRequest,
      DescribeAccountOverviewResponse
    ]("describeAccountOverview", api.describeAccountOverview)(
      request.buildAwsValue()
    ).map(zio.aws.devopsguru.model.DescribeAccountOverviewResponse.wrap)
      .provideEnvironment(r)
    def describeResourceCollectionHealth(
        request: DescribeResourceCollectionHealthRequest
    ): ZStream[
      Any,
      AwsError,
      zio.aws.devopsguru.model.CloudFormationHealth.ReadOnly
    ] = asyncJavaPaginatedRequest[
      software.amazon.awssdk.services.devopsguru.model.DescribeResourceCollectionHealthRequest,
      CloudFormationHealth,
      DescribeResourceCollectionHealthPublisher
    ](
      "describeResourceCollectionHealth",
      api.describeResourceCollectionHealthPaginator,
      _.cloudFormation()
    )(request.buildAwsValue())
      .map(item => zio.aws.devopsguru.model.CloudFormationHealth.wrap(item))
      .provideEnvironment(r)
    def describeResourceCollectionHealthPaginated(
        request: DescribeResourceCollectionHealthRequest
    ): IO[
      AwsError,
      zio.aws.devopsguru.model.DescribeResourceCollectionHealthResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.devopsguru.model.DescribeResourceCollectionHealthRequest,
      DescribeResourceCollectionHealthResponse
    ]("describeResourceCollectionHealth", api.describeResourceCollectionHealth)(
      request.buildAwsValue()
    ).map(
      zio.aws.devopsguru.model.DescribeResourceCollectionHealthResponse.wrap
    ).provideEnvironment(r)
    def getResourceCollection(request: GetResourceCollectionRequest): IO[
      AwsError,
      zio.aws.devopsguru.model.GetResourceCollectionResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.devopsguru.model.GetResourceCollectionRequest,
      GetResourceCollectionResponse
    ]("getResourceCollection", api.getResourceCollection)(
      request.buildAwsValue()
    ).map(zio.aws.devopsguru.model.GetResourceCollectionResponse.wrap)
      .provideEnvironment(r)
    def deleteInsight(
        request: DeleteInsightRequest
    ): IO[AwsError, zio.aws.devopsguru.model.DeleteInsightResponse.ReadOnly] =
      asyncRequestResponse[
        software.amazon.awssdk.services.devopsguru.model.DeleteInsightRequest,
        DeleteInsightResponse
      ]("deleteInsight", api.deleteInsight)(request.buildAwsValue())
        .map(zio.aws.devopsguru.model.DeleteInsightResponse.wrap)
        .provideEnvironment(r)
    def listAnomalousLogGroups(
        request: ListAnomalousLogGroupsRequest
    ): ZIO[Any, AwsError, StreamingOutputResult[
      Any,
      zio.aws.devopsguru.model.ListAnomalousLogGroupsResponse.ReadOnly,
      zio.aws.devopsguru.model.AnomalousLogGroup.ReadOnly
    ]] = asyncPaginatedRequest[
      software.amazon.awssdk.services.devopsguru.model.ListAnomalousLogGroupsRequest,
      ListAnomalousLogGroupsResponse,
      AnomalousLogGroup
    ](
      "listAnomalousLogGroups",
      api.listAnomalousLogGroups,
      (r, token) => r.toBuilder().nextToken(token).build(),
      r => scala.Option(r.nextToken()),
      r => zio.Chunk.fromIterable(r.anomalousLogGroups().asScala)
    )(request.buildAwsValue())
      .map(result =>
        result
          .mapResponse(
            zio.aws.devopsguru.model.ListAnomalousLogGroupsResponse.wrap
          )
          .mapOutput(
            _.map(item => zio.aws.devopsguru.model.AnomalousLogGroup.wrap(item))
          )
          .provideEnvironment(r)
      )
      .provideEnvironment(r)
    def listAnomalousLogGroupsPaginated(
        request: ListAnomalousLogGroupsRequest
    ): IO[
      AwsError,
      zio.aws.devopsguru.model.ListAnomalousLogGroupsResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.devopsguru.model.ListAnomalousLogGroupsRequest,
      ListAnomalousLogGroupsResponse
    ]("listAnomalousLogGroups", api.listAnomalousLogGroups)(
      request.buildAwsValue()
    ).map(zio.aws.devopsguru.model.ListAnomalousLogGroupsResponse.wrap)
      .provideEnvironment(r)
    def listRecommendations(request: ListRecommendationsRequest): ZStream[
      Any,
      AwsError,
      zio.aws.devopsguru.model.Recommendation.ReadOnly
    ] = asyncSimplePaginatedRequest[
      software.amazon.awssdk.services.devopsguru.model.ListRecommendationsRequest,
      ListRecommendationsResponse,
      Recommendation
    ](
      "listRecommendations",
      api.listRecommendations,
      (r, token) => r.toBuilder().nextToken(token).build(),
      r => scala.Option(r.nextToken()),
      r => zio.Chunk.fromIterable(r.recommendations().asScala)
    )(request.buildAwsValue())
      .map(item => zio.aws.devopsguru.model.Recommendation.wrap(item))
      .provideEnvironment(r)
    def listRecommendationsPaginated(request: ListRecommendationsRequest): IO[
      AwsError,
      zio.aws.devopsguru.model.ListRecommendationsResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.devopsguru.model.ListRecommendationsRequest,
      ListRecommendationsResponse
    ]("listRecommendations", api.listRecommendations)(request.buildAwsValue())
      .map(zio.aws.devopsguru.model.ListRecommendationsResponse.wrap)
      .provideEnvironment(r)
    def listMonitoredResources(request: ListMonitoredResourcesRequest): ZStream[
      Any,
      AwsError,
      zio.aws.devopsguru.model.MonitoredResourceIdentifier.ReadOnly
    ] = asyncSimplePaginatedRequest[
      software.amazon.awssdk.services.devopsguru.model.ListMonitoredResourcesRequest,
      ListMonitoredResourcesResponse,
      MonitoredResourceIdentifier
    ](
      "listMonitoredResources",
      api.listMonitoredResources,
      (r, token) => r.toBuilder().nextToken(token).build(),
      r => scala.Option(r.nextToken()),
      r => zio.Chunk.fromIterable(r.monitoredResourceIdentifiers().asScala)
    )(request.buildAwsValue())
      .map(item =>
        zio.aws.devopsguru.model.MonitoredResourceIdentifier.wrap(item)
      )
      .provideEnvironment(r)
    def listMonitoredResourcesPaginated(
        request: ListMonitoredResourcesRequest
    ): IO[
      AwsError,
      zio.aws.devopsguru.model.ListMonitoredResourcesResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.devopsguru.model.ListMonitoredResourcesRequest,
      ListMonitoredResourcesResponse
    ]("listMonitoredResources", api.listMonitoredResources)(
      request.buildAwsValue()
    ).map(zio.aws.devopsguru.model.ListMonitoredResourcesResponse.wrap)
      .provideEnvironment(r)
    def searchOrganizationInsights(
        request: SearchOrganizationInsightsRequest
    ): ZStream[
      Any,
      AwsError,
      zio.aws.devopsguru.model.ProactiveInsightSummary.ReadOnly
    ] = asyncJavaPaginatedRequest[
      software.amazon.awssdk.services.devopsguru.model.SearchOrganizationInsightsRequest,
      ProactiveInsightSummary,
      SearchOrganizationInsightsPublisher
    ](
      "searchOrganizationInsights",
      api.searchOrganizationInsightsPaginator,
      _.proactiveInsights()
    )(request.buildAwsValue())
      .map(item => zio.aws.devopsguru.model.ProactiveInsightSummary.wrap(item))
      .provideEnvironment(r)
    def searchOrganizationInsightsPaginated(
        request: SearchOrganizationInsightsRequest
    ): IO[
      AwsError,
      zio.aws.devopsguru.model.SearchOrganizationInsightsResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.devopsguru.model.SearchOrganizationInsightsRequest,
      SearchOrganizationInsightsResponse
    ]("searchOrganizationInsights", api.searchOrganizationInsights)(
      request.buildAwsValue()
    ).map(zio.aws.devopsguru.model.SearchOrganizationInsightsResponse.wrap)
      .provideEnvironment(r)
    def listEvents(
        request: ListEventsRequest
    ): ZStream[Any, AwsError, zio.aws.devopsguru.model.Event.ReadOnly] =
      asyncSimplePaginatedRequest[
        software.amazon.awssdk.services.devopsguru.model.ListEventsRequest,
        ListEventsResponse,
        Event
      ](
        "listEvents",
        api.listEvents,
        (r, token) => r.toBuilder().nextToken(token).build(),
        r => scala.Option(r.nextToken()),
        r => zio.Chunk.fromIterable(r.events().asScala)
      )(request.buildAwsValue())
        .map(item => zio.aws.devopsguru.model.Event.wrap(item))
        .provideEnvironment(r)
    def listEventsPaginated(
        request: ListEventsRequest
    ): IO[AwsError, zio.aws.devopsguru.model.ListEventsResponse.ReadOnly] =
      asyncRequestResponse[
        software.amazon.awssdk.services.devopsguru.model.ListEventsRequest,
        ListEventsResponse
      ]("listEvents", api.listEvents)(request.buildAwsValue())
        .map(zio.aws.devopsguru.model.ListEventsResponse.wrap)
        .provideEnvironment(r)
    def describeAccountHealth(
        request: DescribeAccountHealthRequest
    ): IO[AwsError, ReadOnly] = asyncRequestResponse[
      software.amazon.awssdk.services.devopsguru.model.DescribeAccountHealthRequest,
      DescribeAccountHealthResponse
    ]("describeAccountHealth", api.describeAccountHealth)(
      request.buildAwsValue()
    ).map(zio.aws.devopsguru.model.DescribeAccountHealthResponse.wrap)
      .provideEnvironment(r)
    def listOrganizationInsights(
        request: ListOrganizationInsightsRequest
    ): ZStream[
      Any,
      AwsError,
      zio.aws.devopsguru.model.ProactiveOrganizationInsightSummary.ReadOnly
    ] = asyncJavaPaginatedRequest[
      software.amazon.awssdk.services.devopsguru.model.ListOrganizationInsightsRequest,
      ProactiveOrganizationInsightSummary,
      ListOrganizationInsightsPublisher
    ](
      "listOrganizationInsights",
      api.listOrganizationInsightsPaginator,
      _.proactiveInsights()
    )(request.buildAwsValue())
      .map(item =>
        zio.aws.devopsguru.model.ProactiveOrganizationInsightSummary.wrap(item)
      )
      .provideEnvironment(r)
    def listOrganizationInsightsPaginated(
        request: ListOrganizationInsightsRequest
    ): IO[
      AwsError,
      zio.aws.devopsguru.model.ListOrganizationInsightsResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.devopsguru.model.ListOrganizationInsightsRequest,
      ListOrganizationInsightsResponse
    ]("listOrganizationInsights", api.listOrganizationInsights)(
      request.buildAwsValue()
    ).map(zio.aws.devopsguru.model.ListOrganizationInsightsResponse.wrap)
      .provideEnvironment(r)
    def removeNotificationChannel(
        request: RemoveNotificationChannelRequest
    ): IO[
      AwsError,
      zio.aws.devopsguru.model.RemoveNotificationChannelResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.devopsguru.model.RemoveNotificationChannelRequest,
      RemoveNotificationChannelResponse
    ]("removeNotificationChannel", api.removeNotificationChannel)(
      request.buildAwsValue()
    ).map(zio.aws.devopsguru.model.RemoveNotificationChannelResponse.wrap)
      .provideEnvironment(r)
    def describeFeedback(request: DescribeFeedbackRequest): IO[
      AwsError,
      zio.aws.devopsguru.model.DescribeFeedbackResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.devopsguru.model.DescribeFeedbackRequest,
      DescribeFeedbackResponse
    ]("describeFeedback", api.describeFeedback)(request.buildAwsValue())
      .map(zio.aws.devopsguru.model.DescribeFeedbackResponse.wrap)
      .provideEnvironment(r)
    def describeOrganizationOverview(
        request: DescribeOrganizationOverviewRequest
    ): IO[
      AwsError,
      zio.aws.devopsguru.model.DescribeOrganizationOverviewResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.devopsguru.model.DescribeOrganizationOverviewRequest,
      DescribeOrganizationOverviewResponse
    ]("describeOrganizationOverview", api.describeOrganizationOverview)(
      request.buildAwsValue()
    ).map(zio.aws.devopsguru.model.DescribeOrganizationOverviewResponse.wrap)
      .provideEnvironment(r)
    def updateServiceIntegration(request: UpdateServiceIntegrationRequest): IO[
      AwsError,
      zio.aws.devopsguru.model.UpdateServiceIntegrationResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.devopsguru.model.UpdateServiceIntegrationRequest,
      UpdateServiceIntegrationResponse
    ]("updateServiceIntegration", api.updateServiceIntegration)(
      request.buildAwsValue()
    ).map(zio.aws.devopsguru.model.UpdateServiceIntegrationResponse.wrap)
      .provideEnvironment(r)
    def updateResourceCollection(request: UpdateResourceCollectionRequest): IO[
      AwsError,
      zio.aws.devopsguru.model.UpdateResourceCollectionResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.devopsguru.model.UpdateResourceCollectionRequest,
      UpdateResourceCollectionResponse
    ]("updateResourceCollection", api.updateResourceCollection)(
      request.buildAwsValue()
    ).map(zio.aws.devopsguru.model.UpdateResourceCollectionResponse.wrap)
      .provideEnvironment(r)
    def putFeedback(
        request: PutFeedbackRequest
    ): IO[AwsError, zio.aws.devopsguru.model.PutFeedbackResponse.ReadOnly] =
      asyncRequestResponse[
        software.amazon.awssdk.services.devopsguru.model.PutFeedbackRequest,
        PutFeedbackResponse
      ]("putFeedback", api.putFeedback)(request.buildAwsValue())
        .map(zio.aws.devopsguru.model.PutFeedbackResponse.wrap)
        .provideEnvironment(r)
    def describeOrganizationHealth(
        request: DescribeOrganizationHealthRequest
    ): IO[
      AwsError,
      zio.aws.devopsguru.model.DescribeOrganizationHealthResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.devopsguru.model.DescribeOrganizationHealthRequest,
      DescribeOrganizationHealthResponse
    ]("describeOrganizationHealth", api.describeOrganizationHealth)(
      request.buildAwsValue()
    ).map(zio.aws.devopsguru.model.DescribeOrganizationHealthResponse.wrap)
      .provideEnvironment(r)
    def describeAnomaly(
        request: DescribeAnomalyRequest
    ): IO[AwsError, zio.aws.devopsguru.model.DescribeAnomalyResponse.ReadOnly] =
      asyncRequestResponse[
        software.amazon.awssdk.services.devopsguru.model.DescribeAnomalyRequest,
        DescribeAnomalyResponse
      ]("describeAnomaly", api.describeAnomaly)(request.buildAwsValue())
        .map(zio.aws.devopsguru.model.DescribeAnomalyResponse.wrap)
        .provideEnvironment(r)
    def addNotificationChannel(request: AddNotificationChannelRequest): IO[
      AwsError,
      zio.aws.devopsguru.model.AddNotificationChannelResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.devopsguru.model.AddNotificationChannelRequest,
      AddNotificationChannelResponse
    ]("addNotificationChannel", api.addNotificationChannel)(
      request.buildAwsValue()
    ).map(zio.aws.devopsguru.model.AddNotificationChannelResponse.wrap)
      .provideEnvironment(r)
    def updateEventSourcesConfig(request: UpdateEventSourcesConfigRequest): IO[
      AwsError,
      zio.aws.devopsguru.model.UpdateEventSourcesConfigResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.devopsguru.model.UpdateEventSourcesConfigRequest,
      UpdateEventSourcesConfigResponse
    ]("updateEventSourcesConfig", api.updateEventSourcesConfig)(
      request.buildAwsValue()
    ).map(zio.aws.devopsguru.model.UpdateEventSourcesConfigResponse.wrap)
      .provideEnvironment(r)
    def listInsights(request: ListInsightsRequest): ZStream[
      Any,
      AwsError,
      zio.aws.devopsguru.model.ProactiveInsightSummary.ReadOnly
    ] = asyncJavaPaginatedRequest[
      software.amazon.awssdk.services.devopsguru.model.ListInsightsRequest,
      ProactiveInsightSummary,
      ListInsightsPublisher
    ]("listInsights", api.listInsightsPaginator, _.proactiveInsights())(
      request.buildAwsValue()
    ).map(item => zio.aws.devopsguru.model.ProactiveInsightSummary.wrap(item))
      .provideEnvironment(r)
    def listInsightsPaginated(
        request: ListInsightsRequest
    ): IO[AwsError, zio.aws.devopsguru.model.ListInsightsResponse.ReadOnly] =
      asyncRequestResponse[
        software.amazon.awssdk.services.devopsguru.model.ListInsightsRequest,
        ListInsightsResponse
      ]("listInsights", api.listInsights)(request.buildAwsValue())
        .map(zio.aws.devopsguru.model.ListInsightsResponse.wrap)
        .provideEnvironment(r)
    def describeOrganizationResourceCollectionHealth(
        request: DescribeOrganizationResourceCollectionHealthRequest
    ): ZStream[
      Any,
      AwsError,
      zio.aws.devopsguru.model.CloudFormationHealth.ReadOnly
    ] = asyncJavaPaginatedRequest[
      software.amazon.awssdk.services.devopsguru.model.DescribeOrganizationResourceCollectionHealthRequest,
      CloudFormationHealth,
      DescribeOrganizationResourceCollectionHealthPublisher
    ](
      "describeOrganizationResourceCollectionHealth",
      api.describeOrganizationResourceCollectionHealthPaginator,
      _.cloudFormation()
    )(request.buildAwsValue())
      .map(item => zio.aws.devopsguru.model.CloudFormationHealth.wrap(item))
      .provideEnvironment(r)
    def describeOrganizationResourceCollectionHealthPaginated(
        request: DescribeOrganizationResourceCollectionHealthRequest
    ): IO[
      AwsError,
      zio.aws.devopsguru.model.DescribeOrganizationResourceCollectionHealthResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.devopsguru.model.DescribeOrganizationResourceCollectionHealthRequest,
      DescribeOrganizationResourceCollectionHealthResponse
    ](
      "describeOrganizationResourceCollectionHealth",
      api.describeOrganizationResourceCollectionHealth
    )(request.buildAwsValue())
      .map(
        zio.aws.devopsguru.model.DescribeOrganizationResourceCollectionHealthResponse.wrap
      )
      .provideEnvironment(r)
    def listNotificationChannels(
        request: ListNotificationChannelsRequest
    ): ZStream[
      Any,
      AwsError,
      zio.aws.devopsguru.model.NotificationChannel.ReadOnly
    ] = asyncSimplePaginatedRequest[
      software.amazon.awssdk.services.devopsguru.model.ListNotificationChannelsRequest,
      ListNotificationChannelsResponse,
      NotificationChannel
    ](
      "listNotificationChannels",
      api.listNotificationChannels,
      (r, token) => r.toBuilder().nextToken(token).build(),
      r => scala.Option(r.nextToken()),
      r => zio.Chunk.fromIterable(r.channels().asScala)
    )(request.buildAwsValue())
      .map(item => zio.aws.devopsguru.model.NotificationChannel.wrap(item))
      .provideEnvironment(r)
    def listNotificationChannelsPaginated(
        request: ListNotificationChannelsRequest
    ): IO[
      AwsError,
      zio.aws.devopsguru.model.ListNotificationChannelsResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.devopsguru.model.ListNotificationChannelsRequest,
      ListNotificationChannelsResponse
    ]("listNotificationChannels", api.listNotificationChannels)(
      request.buildAwsValue()
    ).map(zio.aws.devopsguru.model.ListNotificationChannelsResponse.wrap)
      .provideEnvironment(r)
    def listAnomaliesForInsight(
        request: ListAnomaliesForInsightRequest
    ): ZStream[
      Any,
      AwsError,
      zio.aws.devopsguru.model.ReactiveAnomalySummary.ReadOnly
    ] = asyncJavaPaginatedRequest[
      software.amazon.awssdk.services.devopsguru.model.ListAnomaliesForInsightRequest,
      ReactiveAnomalySummary,
      ListAnomaliesForInsightPublisher
    ](
      "listAnomaliesForInsight",
      api.listAnomaliesForInsightPaginator,
      _.reactiveAnomalies()
    )(request.buildAwsValue())
      .map(item => zio.aws.devopsguru.model.ReactiveAnomalySummary.wrap(item))
      .provideEnvironment(r)
    def listAnomaliesForInsightPaginated(
        request: ListAnomaliesForInsightRequest
    ): IO[
      AwsError,
      zio.aws.devopsguru.model.ListAnomaliesForInsightResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.devopsguru.model.ListAnomaliesForInsightRequest,
      ListAnomaliesForInsightResponse
    ]("listAnomaliesForInsight", api.listAnomaliesForInsight)(
      request.buildAwsValue()
    ).map(zio.aws.devopsguru.model.ListAnomaliesForInsightResponse.wrap)
      .provideEnvironment(r)
  }
  def describeServiceIntegration(
      request: DescribeServiceIntegrationRequest
  ): ZIO[
    zio.aws.devopsguru.DevOpsGuru,
    AwsError,
    zio.aws.devopsguru.model.DescribeServiceIntegrationResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.describeServiceIntegration(request))
  def describeEventSourcesConfig(
      request: DescribeEventSourcesConfigRequest
  ): ZIO[
    zio.aws.devopsguru.DevOpsGuru,
    AwsError,
    zio.aws.devopsguru.model.DescribeEventSourcesConfigResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.describeEventSourcesConfig(request))
  def startCostEstimation(request: StartCostEstimationRequest): ZIO[
    zio.aws.devopsguru.DevOpsGuru,
    AwsError,
    zio.aws.devopsguru.model.StartCostEstimationResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.startCostEstimation(request))
  def getCostEstimation(
      request: GetCostEstimationRequest
  ): ZIO[zio.aws.devopsguru.DevOpsGuru, AwsError, StreamingOutputResult[
    Any,
    zio.aws.devopsguru.model.GetCostEstimationResponse.ReadOnly,
    zio.aws.devopsguru.model.ServiceResourceCost.ReadOnly
  ]] = ZIO.serviceWithZIO(_.getCostEstimation(request))
  def getCostEstimationPaginated(request: GetCostEstimationRequest): ZIO[
    zio.aws.devopsguru.DevOpsGuru,
    AwsError,
    zio.aws.devopsguru.model.GetCostEstimationResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.getCostEstimationPaginated(request))
  def searchInsights(request: SearchInsightsRequest): ZStream[
    zio.aws.devopsguru.DevOpsGuru,
    AwsError,
    zio.aws.devopsguru.model.ProactiveInsightSummary.ReadOnly
  ] = ZStream.serviceWithStream(_.searchInsights(request))
  def searchInsightsPaginated(request: SearchInsightsRequest): ZIO[
    zio.aws.devopsguru.DevOpsGuru,
    AwsError,
    zio.aws.devopsguru.model.SearchInsightsResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.searchInsightsPaginated(request))
  def describeInsight(request: DescribeInsightRequest): ZIO[
    zio.aws.devopsguru.DevOpsGuru,
    AwsError,
    zio.aws.devopsguru.model.DescribeInsightResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.describeInsight(request))
  def describeAccountOverview(request: DescribeAccountOverviewRequest): ZIO[
    zio.aws.devopsguru.DevOpsGuru,
    AwsError,
    zio.aws.devopsguru.model.DescribeAccountOverviewResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.describeAccountOverview(request))
  def describeResourceCollectionHealth(
      request: DescribeResourceCollectionHealthRequest
  ): ZStream[
    zio.aws.devopsguru.DevOpsGuru,
    AwsError,
    zio.aws.devopsguru.model.CloudFormationHealth.ReadOnly
  ] = ZStream.serviceWithStream(_.describeResourceCollectionHealth(request))
  def describeResourceCollectionHealthPaginated(
      request: DescribeResourceCollectionHealthRequest
  ): ZIO[
    zio.aws.devopsguru.DevOpsGuru,
    AwsError,
    zio.aws.devopsguru.model.DescribeResourceCollectionHealthResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.describeResourceCollectionHealthPaginated(request))
  def getResourceCollection(request: GetResourceCollectionRequest): ZIO[
    zio.aws.devopsguru.DevOpsGuru,
    AwsError,
    zio.aws.devopsguru.model.GetResourceCollectionResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.getResourceCollection(request))
  def deleteInsight(request: DeleteInsightRequest): ZIO[
    zio.aws.devopsguru.DevOpsGuru,
    AwsError,
    zio.aws.devopsguru.model.DeleteInsightResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.deleteInsight(request))
  def listAnomalousLogGroups(
      request: ListAnomalousLogGroupsRequest
  ): ZIO[zio.aws.devopsguru.DevOpsGuru, AwsError, StreamingOutputResult[
    Any,
    zio.aws.devopsguru.model.ListAnomalousLogGroupsResponse.ReadOnly,
    zio.aws.devopsguru.model.AnomalousLogGroup.ReadOnly
  ]] = ZIO.serviceWithZIO(_.listAnomalousLogGroups(request))
  def listAnomalousLogGroupsPaginated(
      request: ListAnomalousLogGroupsRequest
  ): ZIO[
    zio.aws.devopsguru.DevOpsGuru,
    AwsError,
    zio.aws.devopsguru.model.ListAnomalousLogGroupsResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.listAnomalousLogGroupsPaginated(request))
  def listRecommendations(request: ListRecommendationsRequest): ZStream[
    zio.aws.devopsguru.DevOpsGuru,
    AwsError,
    zio.aws.devopsguru.model.Recommendation.ReadOnly
  ] = ZStream.serviceWithStream(_.listRecommendations(request))
  def listRecommendationsPaginated(request: ListRecommendationsRequest): ZIO[
    zio.aws.devopsguru.DevOpsGuru,
    AwsError,
    zio.aws.devopsguru.model.ListRecommendationsResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.listRecommendationsPaginated(request))
  def listMonitoredResources(request: ListMonitoredResourcesRequest): ZStream[
    zio.aws.devopsguru.DevOpsGuru,
    AwsError,
    zio.aws.devopsguru.model.MonitoredResourceIdentifier.ReadOnly
  ] = ZStream.serviceWithStream(_.listMonitoredResources(request))
  def listMonitoredResourcesPaginated(
      request: ListMonitoredResourcesRequest
  ): ZIO[
    zio.aws.devopsguru.DevOpsGuru,
    AwsError,
    zio.aws.devopsguru.model.ListMonitoredResourcesResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.listMonitoredResourcesPaginated(request))
  def searchOrganizationInsights(
      request: SearchOrganizationInsightsRequest
  ): ZStream[
    zio.aws.devopsguru.DevOpsGuru,
    AwsError,
    zio.aws.devopsguru.model.ProactiveInsightSummary.ReadOnly
  ] = ZStream.serviceWithStream(_.searchOrganizationInsights(request))
  def searchOrganizationInsightsPaginated(
      request: SearchOrganizationInsightsRequest
  ): ZIO[
    zio.aws.devopsguru.DevOpsGuru,
    AwsError,
    zio.aws.devopsguru.model.SearchOrganizationInsightsResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.searchOrganizationInsightsPaginated(request))
  def listEvents(request: ListEventsRequest): ZStream[
    zio.aws.devopsguru.DevOpsGuru,
    AwsError,
    zio.aws.devopsguru.model.Event.ReadOnly
  ] = ZStream.serviceWithStream(_.listEvents(request))
  def listEventsPaginated(request: ListEventsRequest): ZIO[
    zio.aws.devopsguru.DevOpsGuru,
    AwsError,
    zio.aws.devopsguru.model.ListEventsResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.listEventsPaginated(request))
  def describeAccountHealth(
      request: DescribeAccountHealthRequest
  ): ZIO[zio.aws.devopsguru.DevOpsGuru, AwsError, ReadOnly] =
    ZIO.serviceWithZIO(_.describeAccountHealth(request))
  def listOrganizationInsights(
      request: ListOrganizationInsightsRequest
  ): ZStream[
    zio.aws.devopsguru.DevOpsGuru,
    AwsError,
    zio.aws.devopsguru.model.ProactiveOrganizationInsightSummary.ReadOnly
  ] = ZStream.serviceWithStream(_.listOrganizationInsights(request))
  def listOrganizationInsightsPaginated(
      request: ListOrganizationInsightsRequest
  ): ZIO[
    zio.aws.devopsguru.DevOpsGuru,
    AwsError,
    zio.aws.devopsguru.model.ListOrganizationInsightsResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.listOrganizationInsightsPaginated(request))
  def removeNotificationChannel(request: RemoveNotificationChannelRequest): ZIO[
    zio.aws.devopsguru.DevOpsGuru,
    AwsError,
    zio.aws.devopsguru.model.RemoveNotificationChannelResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.removeNotificationChannel(request))
  def describeFeedback(request: DescribeFeedbackRequest): ZIO[
    zio.aws.devopsguru.DevOpsGuru,
    AwsError,
    zio.aws.devopsguru.model.DescribeFeedbackResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.describeFeedback(request))
  def describeOrganizationOverview(
      request: DescribeOrganizationOverviewRequest
  ): ZIO[
    zio.aws.devopsguru.DevOpsGuru,
    AwsError,
    zio.aws.devopsguru.model.DescribeOrganizationOverviewResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.describeOrganizationOverview(request))
  def updateServiceIntegration(request: UpdateServiceIntegrationRequest): ZIO[
    zio.aws.devopsguru.DevOpsGuru,
    AwsError,
    zio.aws.devopsguru.model.UpdateServiceIntegrationResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.updateServiceIntegration(request))
  def updateResourceCollection(request: UpdateResourceCollectionRequest): ZIO[
    zio.aws.devopsguru.DevOpsGuru,
    AwsError,
    zio.aws.devopsguru.model.UpdateResourceCollectionResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.updateResourceCollection(request))
  def putFeedback(request: PutFeedbackRequest): ZIO[
    zio.aws.devopsguru.DevOpsGuru,
    AwsError,
    zio.aws.devopsguru.model.PutFeedbackResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.putFeedback(request))
  def describeOrganizationHealth(
      request: DescribeOrganizationHealthRequest
  ): ZIO[
    zio.aws.devopsguru.DevOpsGuru,
    AwsError,
    zio.aws.devopsguru.model.DescribeOrganizationHealthResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.describeOrganizationHealth(request))
  def describeAnomaly(request: DescribeAnomalyRequest): ZIO[
    zio.aws.devopsguru.DevOpsGuru,
    AwsError,
    zio.aws.devopsguru.model.DescribeAnomalyResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.describeAnomaly(request))
  def addNotificationChannel(request: AddNotificationChannelRequest): ZIO[
    zio.aws.devopsguru.DevOpsGuru,
    AwsError,
    zio.aws.devopsguru.model.AddNotificationChannelResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.addNotificationChannel(request))
  def updateEventSourcesConfig(request: UpdateEventSourcesConfigRequest): ZIO[
    zio.aws.devopsguru.DevOpsGuru,
    AwsError,
    zio.aws.devopsguru.model.UpdateEventSourcesConfigResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.updateEventSourcesConfig(request))
  def listInsights(request: ListInsightsRequest): ZStream[
    zio.aws.devopsguru.DevOpsGuru,
    AwsError,
    zio.aws.devopsguru.model.ProactiveInsightSummary.ReadOnly
  ] = ZStream.serviceWithStream(_.listInsights(request))
  def listInsightsPaginated(request: ListInsightsRequest): ZIO[
    zio.aws.devopsguru.DevOpsGuru,
    AwsError,
    zio.aws.devopsguru.model.ListInsightsResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.listInsightsPaginated(request))
  def describeOrganizationResourceCollectionHealth(
      request: DescribeOrganizationResourceCollectionHealthRequest
  ): ZStream[
    zio.aws.devopsguru.DevOpsGuru,
    AwsError,
    zio.aws.devopsguru.model.CloudFormationHealth.ReadOnly
  ] = ZStream.serviceWithStream(
    _.describeOrganizationResourceCollectionHealth(request)
  )
  def describeOrganizationResourceCollectionHealthPaginated(
      request: DescribeOrganizationResourceCollectionHealthRequest
  ): ZIO[
    zio.aws.devopsguru.DevOpsGuru,
    AwsError,
    zio.aws.devopsguru.model.DescribeOrganizationResourceCollectionHealthResponse.ReadOnly
  ] = ZIO.serviceWithZIO(
    _.describeOrganizationResourceCollectionHealthPaginated(request)
  )
  def listNotificationChannels(
      request: ListNotificationChannelsRequest
  ): ZStream[
    zio.aws.devopsguru.DevOpsGuru,
    AwsError,
    zio.aws.devopsguru.model.NotificationChannel.ReadOnly
  ] = ZStream.serviceWithStream(_.listNotificationChannels(request))
  def listNotificationChannelsPaginated(
      request: ListNotificationChannelsRequest
  ): ZIO[
    zio.aws.devopsguru.DevOpsGuru,
    AwsError,
    zio.aws.devopsguru.model.ListNotificationChannelsResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.listNotificationChannelsPaginated(request))
  def listAnomaliesForInsight(request: ListAnomaliesForInsightRequest): ZStream[
    zio.aws.devopsguru.DevOpsGuru,
    AwsError,
    zio.aws.devopsguru.model.ReactiveAnomalySummary.ReadOnly
  ] = ZStream.serviceWithStream(_.listAnomaliesForInsight(request))
  def listAnomaliesForInsightPaginated(
      request: ListAnomaliesForInsightRequest
  ): ZIO[
    zio.aws.devopsguru.DevOpsGuru,
    AwsError,
    zio.aws.devopsguru.model.ListAnomaliesForInsightResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.listAnomaliesForInsightPaginated(request))
}
