package zio.aws.devopsguru.model
import zio.aws.devopsguru.model.primitives.AwsAccountId
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class AccountHealth(
    accountId: Optional[AwsAccountId] = Optional.Absent,
    insight: Optional[zio.aws.devopsguru.model.AccountInsightHealth] =
      Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.devopsguru.model.AccountHealth = {
    import AccountHealth.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.devopsguru.model.AccountHealth
      .builder()
      .optionallyWith(
        accountId.map(value => AwsAccountId.unwrap(value): java.lang.String)
      )(_.accountId)
      .optionallyWith(insight.map(value => value.buildAwsValue()))(_.insight)
      .build()
  }
  def asReadOnly: zio.aws.devopsguru.model.AccountHealth.ReadOnly =
    zio.aws.devopsguru.model.AccountHealth.wrap(buildAwsValue())
}
object AccountHealth {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.devopsguru.model.AccountHealth
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.devopsguru.model.AccountHealth =
      zio.aws.devopsguru.model.AccountHealth(
        accountId.map(value => value),
        insight.map(value => value.asEditable)
      )
    def accountId: Optional[AwsAccountId]
    def insight
        : Optional[zio.aws.devopsguru.model.AccountInsightHealth.ReadOnly]
    def getAccountId: ZIO[Any, AwsError, AwsAccountId] =
      AwsError.unwrapOptionField("accountId", accountId)
    def getInsight: ZIO[
      Any,
      AwsError,
      zio.aws.devopsguru.model.AccountInsightHealth.ReadOnly
    ] = AwsError.unwrapOptionField("insight", insight)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.devopsguru.model.AccountHealth
  ) extends zio.aws.devopsguru.model.AccountHealth.ReadOnly {
    override val accountId: Optional[AwsAccountId] = zio.aws.core.internal
      .optionalFromNullable(impl.accountId())
      .map(value => zio.aws.devopsguru.model.primitives.AwsAccountId(value))
    override val insight
        : Optional[zio.aws.devopsguru.model.AccountInsightHealth.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.insight())
        .map(value => zio.aws.devopsguru.model.AccountInsightHealth.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.devopsguru.model.AccountHealth
  ): zio.aws.devopsguru.model.AccountHealth.ReadOnly = new Wrapper(impl)
}
