package zio.aws.devopsguru.model
import scala.jdk.CollectionConverters.*
sealed trait AnomalyStatus {
  def unwrap: software.amazon.awssdk.services.devopsguru.model.AnomalyStatus
}
object AnomalyStatus {
  def wrap(
      value: software.amazon.awssdk.services.devopsguru.model.AnomalyStatus
  ): zio.aws.devopsguru.model.AnomalyStatus = value match {
    case software.amazon.awssdk.services.devopsguru.model.AnomalyStatus.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.devopsguru.model.AnomalyStatus.ONGOING =>
      val r = ONGOING
      r
    case software.amazon.awssdk.services.devopsguru.model.AnomalyStatus.CLOSED =>
      val r = CLOSED
      r
  }
  case object unknownToSdkVersion
      extends zio.aws.devopsguru.model.AnomalyStatus {
    override def unwrap
        : software.amazon.awssdk.services.devopsguru.model.AnomalyStatus =
      software.amazon.awssdk.services.devopsguru.model.AnomalyStatus.UNKNOWN_TO_SDK_VERSION
  }
  case object ONGOING extends zio.aws.devopsguru.model.AnomalyStatus {
    override def unwrap
        : software.amazon.awssdk.services.devopsguru.model.AnomalyStatus =
      software.amazon.awssdk.services.devopsguru.model.AnomalyStatus.ONGOING
  }
  case object CLOSED extends zio.aws.devopsguru.model.AnomalyStatus {
    override def unwrap
        : software.amazon.awssdk.services.devopsguru.model.AnomalyStatus =
      software.amazon.awssdk.services.devopsguru.model.AnomalyStatus.CLOSED
  }
}
