package zio.aws.devopsguru.model
import java.time.Instant
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import zio.aws.devopsguru.model.primitives.Timestamp
import scala.jdk.CollectionConverters.*
final case class EndTimeRange(
    fromTime: Optional[Timestamp] = Optional.Absent,
    toTime: Optional[Timestamp] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.devopsguru.model.EndTimeRange = {
    import EndTimeRange.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.devopsguru.model.EndTimeRange
      .builder()
      .optionallyWith(fromTime.map(value => Timestamp.unwrap(value): Instant))(
        _.fromTime
      )
      .optionallyWith(toTime.map(value => Timestamp.unwrap(value): Instant))(
        _.toTime
      )
      .build()
  }
  def asReadOnly: zio.aws.devopsguru.model.EndTimeRange.ReadOnly =
    zio.aws.devopsguru.model.EndTimeRange.wrap(buildAwsValue())
}
object EndTimeRange {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.devopsguru.model.EndTimeRange
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.devopsguru.model.EndTimeRange =
      zio.aws.devopsguru.model
        .EndTimeRange(fromTime.map(value => value), toTime.map(value => value))
    def fromTime: Optional[Timestamp]
    def toTime: Optional[Timestamp]
    def getFromTime: ZIO[Any, AwsError, Timestamp] =
      AwsError.unwrapOptionField("fromTime", fromTime)
    def getToTime: ZIO[Any, AwsError, Timestamp] =
      AwsError.unwrapOptionField("toTime", toTime)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.devopsguru.model.EndTimeRange
  ) extends zio.aws.devopsguru.model.EndTimeRange.ReadOnly {
    override val fromTime: Optional[Timestamp] = zio.aws.core.internal
      .optionalFromNullable(impl.fromTime())
      .map(value => zio.aws.devopsguru.model.primitives.Timestamp(value))
    override val toTime: Optional[Timestamp] = zio.aws.core.internal
      .optionalFromNullable(impl.toTime())
      .map(value => zio.aws.devopsguru.model.primitives.Timestamp(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.devopsguru.model.EndTimeRange
  ): zio.aws.devopsguru.model.EndTimeRange.ReadOnly = new Wrapper(impl)
}
