package zio.aws.devopsguru.model
import zio.aws.devopsguru.model.primitives.{UuidNextToken, InsightId}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class ListAnomalousLogGroupsResponse(
    insightId: InsightId,
    anomalousLogGroups: Iterable[zio.aws.devopsguru.model.AnomalousLogGroup],
    nextToken: Optional[UuidNextToken] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.devopsguru.model.ListAnomalousLogGroupsResponse = {
    import ListAnomalousLogGroupsResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.devopsguru.model.ListAnomalousLogGroupsResponse
      .builder()
      .insightId(InsightId.unwrap(insightId): java.lang.String)
      .anomalousLogGroups(anomalousLogGroups.map { item =>
        item.buildAwsValue()
      }.asJavaCollection)
      .optionallyWith(
        nextToken.map(value => UuidNextToken.unwrap(value): java.lang.String)
      )(_.nextToken)
      .build()
  }
  def asReadOnly
      : zio.aws.devopsguru.model.ListAnomalousLogGroupsResponse.ReadOnly =
    zio.aws.devopsguru.model.ListAnomalousLogGroupsResponse
      .wrap(buildAwsValue())
}
object ListAnomalousLogGroupsResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.devopsguru.model.ListAnomalousLogGroupsResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.devopsguru.model.ListAnomalousLogGroupsResponse =
      zio.aws.devopsguru.model.ListAnomalousLogGroupsResponse(
        insightId,
        anomalousLogGroups.map { item =>
          item.asEditable
        },
        nextToken.map(value => value)
      )
    def insightId: InsightId
    def anomalousLogGroups
        : List[zio.aws.devopsguru.model.AnomalousLogGroup.ReadOnly]
    def nextToken: Optional[UuidNextToken]
    def getInsightId: ZIO[Any, Nothing, InsightId] = ZIO.succeed(insightId)
    def getAnomalousLogGroups: ZIO[Any, Nothing, List[
      zio.aws.devopsguru.model.AnomalousLogGroup.ReadOnly
    ]] = ZIO.succeed(anomalousLogGroups)
    def getNextToken: ZIO[Any, AwsError, UuidNextToken] =
      AwsError.unwrapOptionField("nextToken", nextToken)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.devopsguru.model.ListAnomalousLogGroupsResponse
  ) extends zio.aws.devopsguru.model.ListAnomalousLogGroupsResponse.ReadOnly {
    override val insightId: InsightId =
      zio.aws.devopsguru.model.primitives.InsightId(impl.insightId())
    override val anomalousLogGroups
        : List[zio.aws.devopsguru.model.AnomalousLogGroup.ReadOnly] = impl
      .anomalousLogGroups()
      .asScala
      .map { item =>
        zio.aws.devopsguru.model.AnomalousLogGroup.wrap(item)
      }
      .toList
    override val nextToken: Optional[UuidNextToken] = zio.aws.core.internal
      .optionalFromNullable(impl.nextToken())
      .map(value => zio.aws.devopsguru.model.primitives.UuidNextToken(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.devopsguru.model.ListAnomalousLogGroupsResponse
  ): zio.aws.devopsguru.model.ListAnomalousLogGroupsResponse.ReadOnly =
    new Wrapper(impl)
}
