package zio.aws.devopsguru.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class ListInsightsStatusFilter(
    ongoing: Optional[
      zio.aws.devopsguru.model.ListInsightsOngoingStatusFilter
    ] = Optional.Absent,
    closed: Optional[zio.aws.devopsguru.model.ListInsightsClosedStatusFilter] =
      Optional.Absent,
    any: Optional[zio.aws.devopsguru.model.ListInsightsAnyStatusFilter] =
      Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.devopsguru.model.ListInsightsStatusFilter = {
    import ListInsightsStatusFilter.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.devopsguru.model.ListInsightsStatusFilter
      .builder()
      .optionallyWith(ongoing.map(value => value.buildAwsValue()))(_.ongoing)
      .optionallyWith(closed.map(value => value.buildAwsValue()))(_.closed)
      .optionallyWith(any.map(value => value.buildAwsValue()))(_.any)
      .build()
  }
  def asReadOnly: zio.aws.devopsguru.model.ListInsightsStatusFilter.ReadOnly =
    zio.aws.devopsguru.model.ListInsightsStatusFilter.wrap(buildAwsValue())
}
object ListInsightsStatusFilter {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.devopsguru.model.ListInsightsStatusFilter
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.devopsguru.model.ListInsightsStatusFilter =
      zio.aws.devopsguru.model.ListInsightsStatusFilter(
        ongoing.map(value => value.asEditable),
        closed.map(value => value.asEditable),
        any.map(value => value.asEditable)
      )
    def ongoing: Optional[
      zio.aws.devopsguru.model.ListInsightsOngoingStatusFilter.ReadOnly
    ]
    def closed: Optional[
      zio.aws.devopsguru.model.ListInsightsClosedStatusFilter.ReadOnly
    ]
    def any: Optional[
      zio.aws.devopsguru.model.ListInsightsAnyStatusFilter.ReadOnly
    ]
    def getOngoing: ZIO[
      Any,
      AwsError,
      zio.aws.devopsguru.model.ListInsightsOngoingStatusFilter.ReadOnly
    ] = AwsError.unwrapOptionField("ongoing", ongoing)
    def getClosed: ZIO[
      Any,
      AwsError,
      zio.aws.devopsguru.model.ListInsightsClosedStatusFilter.ReadOnly
    ] = AwsError.unwrapOptionField("closed", closed)
    def getAny: ZIO[
      Any,
      AwsError,
      zio.aws.devopsguru.model.ListInsightsAnyStatusFilter.ReadOnly
    ] = AwsError.unwrapOptionField("any", any)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.devopsguru.model.ListInsightsStatusFilter
  ) extends zio.aws.devopsguru.model.ListInsightsStatusFilter.ReadOnly {
    override val ongoing: Optional[
      zio.aws.devopsguru.model.ListInsightsOngoingStatusFilter.ReadOnly
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.ongoing())
      .map(value =>
        zio.aws.devopsguru.model.ListInsightsOngoingStatusFilter.wrap(value)
      )
    override val closed: Optional[
      zio.aws.devopsguru.model.ListInsightsClosedStatusFilter.ReadOnly
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.closed())
      .map(value =>
        zio.aws.devopsguru.model.ListInsightsClosedStatusFilter.wrap(value)
      )
    override val any: Optional[
      zio.aws.devopsguru.model.ListInsightsAnyStatusFilter.ReadOnly
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.any())
      .map(value =>
        zio.aws.devopsguru.model.ListInsightsAnyStatusFilter.wrap(value)
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.devopsguru.model.ListInsightsStatusFilter
  ): zio.aws.devopsguru.model.ListInsightsStatusFilter.ReadOnly = new Wrapper(
    impl
  )
}
