package zio.aws.devopsguru.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class LogAnomalyShowcase(
    logAnomalyClasses: Optional[
      Iterable[zio.aws.devopsguru.model.LogAnomalyClass]
    ] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.devopsguru.model.LogAnomalyShowcase = {
    import LogAnomalyShowcase.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.devopsguru.model.LogAnomalyShowcase
      .builder()
      .optionallyWith(
        logAnomalyClasses.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.logAnomalyClasses)
      .build()
  }
  def asReadOnly: zio.aws.devopsguru.model.LogAnomalyShowcase.ReadOnly =
    zio.aws.devopsguru.model.LogAnomalyShowcase.wrap(buildAwsValue())
}
object LogAnomalyShowcase {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.devopsguru.model.LogAnomalyShowcase
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.devopsguru.model.LogAnomalyShowcase =
      zio.aws.devopsguru.model.LogAnomalyShowcase(
        logAnomalyClasses.map(value =>
          value.map { item =>
            item.asEditable
          }
        )
      )
    def logAnomalyClasses
        : Optional[List[zio.aws.devopsguru.model.LogAnomalyClass.ReadOnly]]
    def getLogAnomalyClasses: ZIO[Any, AwsError, List[
      zio.aws.devopsguru.model.LogAnomalyClass.ReadOnly
    ]] = AwsError.unwrapOptionField("logAnomalyClasses", logAnomalyClasses)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.devopsguru.model.LogAnomalyShowcase
  ) extends zio.aws.devopsguru.model.LogAnomalyShowcase.ReadOnly {
    override val logAnomalyClasses
        : Optional[List[zio.aws.devopsguru.model.LogAnomalyClass.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.logAnomalyClasses())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.devopsguru.model.LogAnomalyClass.wrap(item)
          }.toList
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.devopsguru.model.LogAnomalyShowcase
  ): zio.aws.devopsguru.model.LogAnomalyShowcase.ReadOnly = new Wrapper(impl)
}
