package zio.aws.devopsguru.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class LogsAnomalyDetectionIntegrationConfig(
    optInStatus: Optional[zio.aws.devopsguru.model.OptInStatus] =
      Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.devopsguru.model.LogsAnomalyDetectionIntegrationConfig = {
    import LogsAnomalyDetectionIntegrationConfig.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.devopsguru.model.LogsAnomalyDetectionIntegrationConfig
      .builder()
      .optionallyWith(optInStatus.map(value => value.unwrap))(_.optInStatus)
      .build()
  }
  def asReadOnly
      : zio.aws.devopsguru.model.LogsAnomalyDetectionIntegrationConfig.ReadOnly =
    zio.aws.devopsguru.model.LogsAnomalyDetectionIntegrationConfig
      .wrap(buildAwsValue())
}
object LogsAnomalyDetectionIntegrationConfig {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.devopsguru.model.LogsAnomalyDetectionIntegrationConfig
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.devopsguru.model.LogsAnomalyDetectionIntegrationConfig =
      zio.aws.devopsguru.model
        .LogsAnomalyDetectionIntegrationConfig(optInStatus.map(value => value))
    def optInStatus: Optional[zio.aws.devopsguru.model.OptInStatus]
    def getOptInStatus
        : ZIO[Any, AwsError, zio.aws.devopsguru.model.OptInStatus] =
      AwsError.unwrapOptionField("optInStatus", optInStatus)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.devopsguru.model.LogsAnomalyDetectionIntegrationConfig
  ) extends zio.aws.devopsguru.model.LogsAnomalyDetectionIntegrationConfig.ReadOnly {
    override val optInStatus: Optional[zio.aws.devopsguru.model.OptInStatus] =
      zio.aws.core.internal
        .optionalFromNullable(impl.optInStatus())
        .map(value => zio.aws.devopsguru.model.OptInStatus.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.devopsguru.model.LogsAnomalyDetectionIntegrationConfig
  ): zio.aws.devopsguru.model.LogsAnomalyDetectionIntegrationConfig.ReadOnly =
    new Wrapper(impl)
}
