package zio.aws.devopsguru.model
import zio.aws.devopsguru.model.primitives.{
  PerformanceInsightsMetricUnit,
  PerformanceInsightsMetricDisplayName
}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class PerformanceInsightsMetricsDetail(
    metricDisplayName: Optional[PerformanceInsightsMetricDisplayName] =
      Optional.Absent,
    unit: Optional[PerformanceInsightsMetricUnit] = Optional.Absent,
    metricQuery: Optional[
      zio.aws.devopsguru.model.PerformanceInsightsMetricQuery
    ] = Optional.Absent,
    referenceData: Optional[
      Iterable[zio.aws.devopsguru.model.PerformanceInsightsReferenceData]
    ] = Optional.Absent,
    statsAtAnomaly: Optional[
      Iterable[zio.aws.devopsguru.model.PerformanceInsightsStat]
    ] = Optional.Absent,
    statsAtBaseline: Optional[
      Iterable[zio.aws.devopsguru.model.PerformanceInsightsStat]
    ] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.devopsguru.model.PerformanceInsightsMetricsDetail = {
    import PerformanceInsightsMetricsDetail.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.devopsguru.model.PerformanceInsightsMetricsDetail
      .builder()
      .optionallyWith(
        metricDisplayName.map(value =>
          PerformanceInsightsMetricDisplayName.unwrap(value): java.lang.String
        )
      )(_.metricDisplayName)
      .optionallyWith(
        unit.map(value =>
          PerformanceInsightsMetricUnit.unwrap(value): java.lang.String
        )
      )(_.unit)
      .optionallyWith(metricQuery.map(value => value.buildAwsValue()))(
        _.metricQuery
      )
      .optionallyWith(
        referenceData.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.referenceData)
      .optionallyWith(
        statsAtAnomaly.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.statsAtAnomaly)
      .optionallyWith(
        statsAtBaseline.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.statsAtBaseline)
      .build()
  }
  def asReadOnly
      : zio.aws.devopsguru.model.PerformanceInsightsMetricsDetail.ReadOnly =
    zio.aws.devopsguru.model.PerformanceInsightsMetricsDetail
      .wrap(buildAwsValue())
}
object PerformanceInsightsMetricsDetail {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.devopsguru.model.PerformanceInsightsMetricsDetail
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.devopsguru.model.PerformanceInsightsMetricsDetail =
      zio.aws.devopsguru.model.PerformanceInsightsMetricsDetail(
        metricDisplayName.map(value => value),
        unit.map(value => value),
        metricQuery.map(value => value.asEditable),
        referenceData.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        statsAtAnomaly.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        statsAtBaseline.map(value =>
          value.map { item =>
            item.asEditable
          }
        )
      )
    def metricDisplayName: Optional[PerformanceInsightsMetricDisplayName]
    def unit: Optional[PerformanceInsightsMetricUnit]
    def metricQuery: Optional[
      zio.aws.devopsguru.model.PerformanceInsightsMetricQuery.ReadOnly
    ]
    def referenceData: Optional[
      List[zio.aws.devopsguru.model.PerformanceInsightsReferenceData.ReadOnly]
    ]
    def statsAtAnomaly: Optional[
      List[zio.aws.devopsguru.model.PerformanceInsightsStat.ReadOnly]
    ]
    def statsAtBaseline: Optional[
      List[zio.aws.devopsguru.model.PerformanceInsightsStat.ReadOnly]
    ]
    def getMetricDisplayName
        : ZIO[Any, AwsError, PerformanceInsightsMetricDisplayName] =
      AwsError.unwrapOptionField("metricDisplayName", metricDisplayName)
    def getUnit: ZIO[Any, AwsError, PerformanceInsightsMetricUnit] =
      AwsError.unwrapOptionField("unit", unit)
    def getMetricQuery: ZIO[
      Any,
      AwsError,
      zio.aws.devopsguru.model.PerformanceInsightsMetricQuery.ReadOnly
    ] = AwsError.unwrapOptionField("metricQuery", metricQuery)
    def getReferenceData: ZIO[Any, AwsError, List[
      zio.aws.devopsguru.model.PerformanceInsightsReferenceData.ReadOnly
    ]] = AwsError.unwrapOptionField("referenceData", referenceData)
    def getStatsAtAnomaly: ZIO[Any, AwsError, List[
      zio.aws.devopsguru.model.PerformanceInsightsStat.ReadOnly
    ]] = AwsError.unwrapOptionField("statsAtAnomaly", statsAtAnomaly)
    def getStatsAtBaseline: ZIO[Any, AwsError, List[
      zio.aws.devopsguru.model.PerformanceInsightsStat.ReadOnly
    ]] = AwsError.unwrapOptionField("statsAtBaseline", statsAtBaseline)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.devopsguru.model.PerformanceInsightsMetricsDetail
  ) extends zio.aws.devopsguru.model.PerformanceInsightsMetricsDetail.ReadOnly {
    override val metricDisplayName
        : Optional[PerformanceInsightsMetricDisplayName] = zio.aws.core.internal
      .optionalFromNullable(impl.metricDisplayName())
      .map(value =>
        zio.aws.devopsguru.model.primitives
          .PerformanceInsightsMetricDisplayName(value)
      )
    override val unit: Optional[PerformanceInsightsMetricUnit] =
      zio.aws.core.internal
        .optionalFromNullable(impl.unit())
        .map(value =>
          zio.aws.devopsguru.model.primitives
            .PerformanceInsightsMetricUnit(value)
        )
    override val metricQuery: Optional[
      zio.aws.devopsguru.model.PerformanceInsightsMetricQuery.ReadOnly
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.metricQuery())
      .map(value =>
        zio.aws.devopsguru.model.PerformanceInsightsMetricQuery.wrap(value)
      )
    override val referenceData: Optional[
      List[zio.aws.devopsguru.model.PerformanceInsightsReferenceData.ReadOnly]
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.referenceData())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.devopsguru.model.PerformanceInsightsReferenceData.wrap(item)
        }.toList
      )
    override val statsAtAnomaly: Optional[
      List[zio.aws.devopsguru.model.PerformanceInsightsStat.ReadOnly]
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.statsAtAnomaly())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.devopsguru.model.PerformanceInsightsStat.wrap(item)
        }.toList
      )
    override val statsAtBaseline: Optional[
      List[zio.aws.devopsguru.model.PerformanceInsightsStat.ReadOnly]
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.statsAtBaseline())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.devopsguru.model.PerformanceInsightsStat.wrap(item)
        }.toList
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.devopsguru.model.PerformanceInsightsMetricsDetail
  ): zio.aws.devopsguru.model.PerformanceInsightsMetricsDetail.ReadOnly =
    new Wrapper(impl)
}
