package zio.aws.devopsguru.model
import zio.aws.devopsguru.model.primitives.{
  AnomalyDescription,
  AnomalyName,
  InsightId,
  AnomalyId
}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class ReactiveAnomaly(
    id: Optional[AnomalyId] = Optional.Absent,
    severity: Optional[zio.aws.devopsguru.model.AnomalySeverity] =
      Optional.Absent,
    status: Optional[zio.aws.devopsguru.model.AnomalyStatus] = Optional.Absent,
    anomalyTimeRange: Optional[zio.aws.devopsguru.model.AnomalyTimeRange] =
      Optional.Absent,
    anomalyReportedTimeRange: Optional[
      zio.aws.devopsguru.model.AnomalyReportedTimeRange
    ] = Optional.Absent,
    sourceDetails: Optional[zio.aws.devopsguru.model.AnomalySourceDetails] =
      Optional.Absent,
    associatedInsightId: Optional[InsightId] = Optional.Absent,
    resourceCollection: Optional[zio.aws.devopsguru.model.ResourceCollection] =
      Optional.Absent,
    `type`: Optional[zio.aws.devopsguru.model.AnomalyType] = Optional.Absent,
    name: Optional[AnomalyName] = Optional.Absent,
    description: Optional[AnomalyDescription] = Optional.Absent,
    causalAnomalyId: Optional[AnomalyId] = Optional.Absent,
    anomalyResources: Optional[
      Iterable[zio.aws.devopsguru.model.AnomalyResource]
    ] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.devopsguru.model.ReactiveAnomaly = {
    import ReactiveAnomaly.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.devopsguru.model.ReactiveAnomaly
      .builder()
      .optionallyWith(
        id.map(value => AnomalyId.unwrap(value): java.lang.String)
      )(_.id)
      .optionallyWith(severity.map(value => value.unwrap))(_.severity)
      .optionallyWith(status.map(value => value.unwrap))(_.status)
      .optionallyWith(anomalyTimeRange.map(value => value.buildAwsValue()))(
        _.anomalyTimeRange
      )
      .optionallyWith(
        anomalyReportedTimeRange.map(value => value.buildAwsValue())
      )(_.anomalyReportedTimeRange)
      .optionallyWith(sourceDetails.map(value => value.buildAwsValue()))(
        _.sourceDetails
      )
      .optionallyWith(
        associatedInsightId.map(value =>
          InsightId.unwrap(value): java.lang.String
        )
      )(_.associatedInsightId)
      .optionallyWith(resourceCollection.map(value => value.buildAwsValue()))(
        _.resourceCollection
      )
      .optionallyWith(`type`.map(value => value.unwrap))(_.`type`)
      .optionallyWith(
        name.map(value => AnomalyName.unwrap(value): java.lang.String)
      )(_.name)
      .optionallyWith(
        description.map(value =>
          AnomalyDescription.unwrap(value): java.lang.String
        )
      )(_.description)
      .optionallyWith(
        causalAnomalyId.map(value => AnomalyId.unwrap(value): java.lang.String)
      )(_.causalAnomalyId)
      .optionallyWith(
        anomalyResources.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.anomalyResources)
      .build()
  }
  def asReadOnly: zio.aws.devopsguru.model.ReactiveAnomaly.ReadOnly =
    zio.aws.devopsguru.model.ReactiveAnomaly.wrap(buildAwsValue())
}
object ReactiveAnomaly {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.devopsguru.model.ReactiveAnomaly
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.devopsguru.model.ReactiveAnomaly =
      zio.aws.devopsguru.model.ReactiveAnomaly(
        id.map(value => value),
        severity.map(value => value),
        status.map(value => value),
        anomalyTimeRange.map(value => value.asEditable),
        anomalyReportedTimeRange.map(value => value.asEditable),
        sourceDetails.map(value => value.asEditable),
        associatedInsightId.map(value => value),
        resourceCollection.map(value => value.asEditable),
        `type`.map(value => value),
        name.map(value => value),
        description.map(value => value),
        causalAnomalyId.map(value => value),
        anomalyResources.map(value =>
          value.map { item =>
            item.asEditable
          }
        )
      )
    def id: Optional[AnomalyId]
    def severity: Optional[zio.aws.devopsguru.model.AnomalySeverity]
    def status: Optional[zio.aws.devopsguru.model.AnomalyStatus]
    def anomalyTimeRange
        : Optional[zio.aws.devopsguru.model.AnomalyTimeRange.ReadOnly]
    def anomalyReportedTimeRange
        : Optional[zio.aws.devopsguru.model.AnomalyReportedTimeRange.ReadOnly]
    def sourceDetails
        : Optional[zio.aws.devopsguru.model.AnomalySourceDetails.ReadOnly]
    def associatedInsightId: Optional[InsightId]
    def resourceCollection
        : Optional[zio.aws.devopsguru.model.ResourceCollection.ReadOnly]
    def `type`: Optional[zio.aws.devopsguru.model.AnomalyType]
    def name: Optional[AnomalyName]
    def description: Optional[AnomalyDescription]
    def causalAnomalyId: Optional[AnomalyId]
    def anomalyResources
        : Optional[List[zio.aws.devopsguru.model.AnomalyResource.ReadOnly]]
    def getId: ZIO[Any, AwsError, AnomalyId] =
      AwsError.unwrapOptionField("id", id)
    def getSeverity
        : ZIO[Any, AwsError, zio.aws.devopsguru.model.AnomalySeverity] =
      AwsError.unwrapOptionField("severity", severity)
    def getStatus: ZIO[Any, AwsError, zio.aws.devopsguru.model.AnomalyStatus] =
      AwsError.unwrapOptionField("status", status)
    def getAnomalyTimeRange: ZIO[
      Any,
      AwsError,
      zio.aws.devopsguru.model.AnomalyTimeRange.ReadOnly
    ] = AwsError.unwrapOptionField("anomalyTimeRange", anomalyTimeRange)
    def getAnomalyReportedTimeRange: ZIO[
      Any,
      AwsError,
      zio.aws.devopsguru.model.AnomalyReportedTimeRange.ReadOnly
    ] = AwsError.unwrapOptionField(
      "anomalyReportedTimeRange",
      anomalyReportedTimeRange
    )
    def getSourceDetails: ZIO[
      Any,
      AwsError,
      zio.aws.devopsguru.model.AnomalySourceDetails.ReadOnly
    ] = AwsError.unwrapOptionField("sourceDetails", sourceDetails)
    def getAssociatedInsightId: ZIO[Any, AwsError, InsightId] =
      AwsError.unwrapOptionField("associatedInsightId", associatedInsightId)
    def getResourceCollection: ZIO[
      Any,
      AwsError,
      zio.aws.devopsguru.model.ResourceCollection.ReadOnly
    ] = AwsError.unwrapOptionField("resourceCollection", resourceCollection)
    def getType: ZIO[Any, AwsError, zio.aws.devopsguru.model.AnomalyType] =
      AwsError.unwrapOptionField("type", `type`)
    def getName: ZIO[Any, AwsError, AnomalyName] =
      AwsError.unwrapOptionField("name", name)
    def getDescription: ZIO[Any, AwsError, AnomalyDescription] =
      AwsError.unwrapOptionField("description", description)
    def getCausalAnomalyId: ZIO[Any, AwsError, AnomalyId] =
      AwsError.unwrapOptionField("causalAnomalyId", causalAnomalyId)
    def getAnomalyResources: ZIO[Any, AwsError, List[
      zio.aws.devopsguru.model.AnomalyResource.ReadOnly
    ]] = AwsError.unwrapOptionField("anomalyResources", anomalyResources)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.devopsguru.model.ReactiveAnomaly
  ) extends zio.aws.devopsguru.model.ReactiveAnomaly.ReadOnly {
    override val id: Optional[AnomalyId] = zio.aws.core.internal
      .optionalFromNullable(impl.id())
      .map(value => zio.aws.devopsguru.model.primitives.AnomalyId(value))
    override val severity: Optional[zio.aws.devopsguru.model.AnomalySeverity] =
      zio.aws.core.internal
        .optionalFromNullable(impl.severity())
        .map(value => zio.aws.devopsguru.model.AnomalySeverity.wrap(value))
    override val status: Optional[zio.aws.devopsguru.model.AnomalyStatus] =
      zio.aws.core.internal
        .optionalFromNullable(impl.status())
        .map(value => zio.aws.devopsguru.model.AnomalyStatus.wrap(value))
    override val anomalyTimeRange
        : Optional[zio.aws.devopsguru.model.AnomalyTimeRange.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.anomalyTimeRange())
        .map(value => zio.aws.devopsguru.model.AnomalyTimeRange.wrap(value))
    override val anomalyReportedTimeRange
        : Optional[zio.aws.devopsguru.model.AnomalyReportedTimeRange.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.anomalyReportedTimeRange())
        .map(value =>
          zio.aws.devopsguru.model.AnomalyReportedTimeRange.wrap(value)
        )
    override val sourceDetails
        : Optional[zio.aws.devopsguru.model.AnomalySourceDetails.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.sourceDetails())
        .map(value => zio.aws.devopsguru.model.AnomalySourceDetails.wrap(value))
    override val associatedInsightId: Optional[InsightId] =
      zio.aws.core.internal
        .optionalFromNullable(impl.associatedInsightId())
        .map(value => zio.aws.devopsguru.model.primitives.InsightId(value))
    override val resourceCollection
        : Optional[zio.aws.devopsguru.model.ResourceCollection.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.resourceCollection())
        .map(value => zio.aws.devopsguru.model.ResourceCollection.wrap(value))
    override val `type`: Optional[zio.aws.devopsguru.model.AnomalyType] =
      zio.aws.core.internal
        .optionalFromNullable(impl.`type`())
        .map(value => zio.aws.devopsguru.model.AnomalyType.wrap(value))
    override val name: Optional[AnomalyName] = zio.aws.core.internal
      .optionalFromNullable(impl.name())
      .map(value => zio.aws.devopsguru.model.primitives.AnomalyName(value))
    override val description: Optional[AnomalyDescription] =
      zio.aws.core.internal
        .optionalFromNullable(impl.description())
        .map(value =>
          zio.aws.devopsguru.model.primitives.AnomalyDescription(value)
        )
    override val causalAnomalyId: Optional[AnomalyId] = zio.aws.core.internal
      .optionalFromNullable(impl.causalAnomalyId())
      .map(value => zio.aws.devopsguru.model.primitives.AnomalyId(value))
    override val anomalyResources
        : Optional[List[zio.aws.devopsguru.model.AnomalyResource.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.anomalyResources())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.devopsguru.model.AnomalyResource.wrap(item)
          }.toList
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.devopsguru.model.ReactiveAnomaly
  ): zio.aws.devopsguru.model.ReactiveAnomaly.ReadOnly = new Wrapper(impl)
}
