package zio.aws.devopsguru.model
import zio.aws.devopsguru.model.primitives.{ResourceArn, InsightName, InsightId}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class ReactiveInsightSummary(
    id: Optional[InsightId] = Optional.Absent,
    name: Optional[InsightName] = Optional.Absent,
    severity: Optional[zio.aws.devopsguru.model.InsightSeverity] =
      Optional.Absent,
    status: Optional[zio.aws.devopsguru.model.InsightStatus] = Optional.Absent,
    insightTimeRange: Optional[zio.aws.devopsguru.model.InsightTimeRange] =
      Optional.Absent,
    resourceCollection: Optional[zio.aws.devopsguru.model.ResourceCollection] =
      Optional.Absent,
    serviceCollection: Optional[zio.aws.devopsguru.model.ServiceCollection] =
      Optional.Absent,
    associatedResourceArns: Optional[Iterable[ResourceArn]] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.devopsguru.model.ReactiveInsightSummary = {
    import ReactiveInsightSummary.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.devopsguru.model.ReactiveInsightSummary
      .builder()
      .optionallyWith(
        id.map(value => InsightId.unwrap(value): java.lang.String)
      )(_.id)
      .optionallyWith(
        name.map(value => InsightName.unwrap(value): java.lang.String)
      )(_.name)
      .optionallyWith(severity.map(value => value.unwrap))(_.severity)
      .optionallyWith(status.map(value => value.unwrap))(_.status)
      .optionallyWith(insightTimeRange.map(value => value.buildAwsValue()))(
        _.insightTimeRange
      )
      .optionallyWith(resourceCollection.map(value => value.buildAwsValue()))(
        _.resourceCollection
      )
      .optionallyWith(serviceCollection.map(value => value.buildAwsValue()))(
        _.serviceCollection
      )
      .optionallyWith(
        associatedResourceArns.map(value =>
          value.map { item =>
            ResourceArn.unwrap(item): java.lang.String
          }.asJavaCollection
        )
      )(_.associatedResourceArns)
      .build()
  }
  def asReadOnly: zio.aws.devopsguru.model.ReactiveInsightSummary.ReadOnly =
    zio.aws.devopsguru.model.ReactiveInsightSummary.wrap(buildAwsValue())
}
object ReactiveInsightSummary {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.devopsguru.model.ReactiveInsightSummary
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.devopsguru.model.ReactiveInsightSummary =
      zio.aws.devopsguru.model.ReactiveInsightSummary(
        id.map(value => value),
        name.map(value => value),
        severity.map(value => value),
        status.map(value => value),
        insightTimeRange.map(value => value.asEditable),
        resourceCollection.map(value => value.asEditable),
        serviceCollection.map(value => value.asEditable),
        associatedResourceArns.map(value => value)
      )
    def id: Optional[InsightId]
    def name: Optional[InsightName]
    def severity: Optional[zio.aws.devopsguru.model.InsightSeverity]
    def status: Optional[zio.aws.devopsguru.model.InsightStatus]
    def insightTimeRange
        : Optional[zio.aws.devopsguru.model.InsightTimeRange.ReadOnly]
    def resourceCollection
        : Optional[zio.aws.devopsguru.model.ResourceCollection.ReadOnly]
    def serviceCollection
        : Optional[zio.aws.devopsguru.model.ServiceCollection.ReadOnly]
    def associatedResourceArns: Optional[List[ResourceArn]]
    def getId: ZIO[Any, AwsError, InsightId] =
      AwsError.unwrapOptionField("id", id)
    def getName: ZIO[Any, AwsError, InsightName] =
      AwsError.unwrapOptionField("name", name)
    def getSeverity
        : ZIO[Any, AwsError, zio.aws.devopsguru.model.InsightSeverity] =
      AwsError.unwrapOptionField("severity", severity)
    def getStatus: ZIO[Any, AwsError, zio.aws.devopsguru.model.InsightStatus] =
      AwsError.unwrapOptionField("status", status)
    def getInsightTimeRange: ZIO[
      Any,
      AwsError,
      zio.aws.devopsguru.model.InsightTimeRange.ReadOnly
    ] = AwsError.unwrapOptionField("insightTimeRange", insightTimeRange)
    def getResourceCollection: ZIO[
      Any,
      AwsError,
      zio.aws.devopsguru.model.ResourceCollection.ReadOnly
    ] = AwsError.unwrapOptionField("resourceCollection", resourceCollection)
    def getServiceCollection: ZIO[
      Any,
      AwsError,
      zio.aws.devopsguru.model.ServiceCollection.ReadOnly
    ] = AwsError.unwrapOptionField("serviceCollection", serviceCollection)
    def getAssociatedResourceArns: ZIO[Any, AwsError, List[ResourceArn]] =
      AwsError.unwrapOptionField(
        "associatedResourceArns",
        associatedResourceArns
      )
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.devopsguru.model.ReactiveInsightSummary
  ) extends zio.aws.devopsguru.model.ReactiveInsightSummary.ReadOnly {
    override val id: Optional[InsightId] = zio.aws.core.internal
      .optionalFromNullable(impl.id())
      .map(value => zio.aws.devopsguru.model.primitives.InsightId(value))
    override val name: Optional[InsightName] = zio.aws.core.internal
      .optionalFromNullable(impl.name())
      .map(value => zio.aws.devopsguru.model.primitives.InsightName(value))
    override val severity: Optional[zio.aws.devopsguru.model.InsightSeverity] =
      zio.aws.core.internal
        .optionalFromNullable(impl.severity())
        .map(value => zio.aws.devopsguru.model.InsightSeverity.wrap(value))
    override val status: Optional[zio.aws.devopsguru.model.InsightStatus] =
      zio.aws.core.internal
        .optionalFromNullable(impl.status())
        .map(value => zio.aws.devopsguru.model.InsightStatus.wrap(value))
    override val insightTimeRange
        : Optional[zio.aws.devopsguru.model.InsightTimeRange.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.insightTimeRange())
        .map(value => zio.aws.devopsguru.model.InsightTimeRange.wrap(value))
    override val resourceCollection
        : Optional[zio.aws.devopsguru.model.ResourceCollection.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.resourceCollection())
        .map(value => zio.aws.devopsguru.model.ResourceCollection.wrap(value))
    override val serviceCollection
        : Optional[zio.aws.devopsguru.model.ServiceCollection.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.serviceCollection())
        .map(value => zio.aws.devopsguru.model.ServiceCollection.wrap(value))
    override val associatedResourceArns: Optional[List[ResourceArn]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.associatedResourceArns())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.devopsguru.model.primitives.ResourceArn(item)
          }.toList
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.devopsguru.model.ReactiveInsightSummary
  ): zio.aws.devopsguru.model.ReactiveInsightSummary.ReadOnly = new Wrapper(
    impl
  )
}
