package zio.aws.devopsguru.model
import java.time.Instant
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import zio.aws.devopsguru.model.primitives.{MetricValue, Timestamp}
import scala.jdk.CollectionConverters.*
final case class TimestampMetricValuePair(
    timestamp: Optional[Timestamp] = Optional.Absent,
    metricValue: Optional[MetricValue] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.devopsguru.model.TimestampMetricValuePair = {
    import TimestampMetricValuePair.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.devopsguru.model.TimestampMetricValuePair
      .builder()
      .optionallyWith(timestamp.map(value => Timestamp.unwrap(value): Instant))(
        _.timestamp
      )
      .optionallyWith(
        metricValue.map(value => MetricValue.unwrap(value): java.lang.Double)
      )(_.metricValue)
      .build()
  }
  def asReadOnly: zio.aws.devopsguru.model.TimestampMetricValuePair.ReadOnly =
    zio.aws.devopsguru.model.TimestampMetricValuePair.wrap(buildAwsValue())
}
object TimestampMetricValuePair {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.devopsguru.model.TimestampMetricValuePair
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.devopsguru.model.TimestampMetricValuePair =
      zio.aws.devopsguru.model.TimestampMetricValuePair(
        timestamp.map(value => value),
        metricValue.map(value => value)
      )
    def timestamp: Optional[Timestamp]
    def metricValue: Optional[MetricValue]
    def getTimestamp: ZIO[Any, AwsError, Timestamp] =
      AwsError.unwrapOptionField("timestamp", timestamp)
    def getMetricValue: ZIO[Any, AwsError, MetricValue] =
      AwsError.unwrapOptionField("metricValue", metricValue)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.devopsguru.model.TimestampMetricValuePair
  ) extends zio.aws.devopsguru.model.TimestampMetricValuePair.ReadOnly {
    override val timestamp: Optional[Timestamp] = zio.aws.core.internal
      .optionalFromNullable(impl.timestamp())
      .map(value => zio.aws.devopsguru.model.primitives.Timestamp(value))
    override val metricValue: Optional[MetricValue] = zio.aws.core.internal
      .optionalFromNullable(impl.metricValue())
      .map(value => zio.aws.devopsguru.model.primitives.MetricValue(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.devopsguru.model.TimestampMetricValuePair
  ): zio.aws.devopsguru.model.TimestampMetricValuePair.ReadOnly = new Wrapper(
    impl
  )
}
