package zio.aws.devopsguru.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters.*
final case class UpdateResourceCollectionRequest(
    action: zio.aws.devopsguru.model.UpdateResourceCollectionAction,
    resourceCollection: zio.aws.devopsguru.model.UpdateResourceCollectionFilter
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.devopsguru.model.UpdateResourceCollectionRequest = {
    import UpdateResourceCollectionRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.devopsguru.model.UpdateResourceCollectionRequest
      .builder()
      .action(action.unwrap)
      .resourceCollection(resourceCollection.buildAwsValue())
      .build()
  }
  def asReadOnly
      : zio.aws.devopsguru.model.UpdateResourceCollectionRequest.ReadOnly =
    zio.aws.devopsguru.model.UpdateResourceCollectionRequest
      .wrap(buildAwsValue())
}
object UpdateResourceCollectionRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.devopsguru.model.UpdateResourceCollectionRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.devopsguru.model.UpdateResourceCollectionRequest =
      zio.aws.devopsguru.model
        .UpdateResourceCollectionRequest(action, resourceCollection.asEditable)
    def action: zio.aws.devopsguru.model.UpdateResourceCollectionAction
    def resourceCollection
        : zio.aws.devopsguru.model.UpdateResourceCollectionFilter.ReadOnly
    def getAction: ZIO[
      Any,
      Nothing,
      zio.aws.devopsguru.model.UpdateResourceCollectionAction
    ] = ZIO.succeed(action)
    def getResourceCollection: ZIO[
      Any,
      Nothing,
      zio.aws.devopsguru.model.UpdateResourceCollectionFilter.ReadOnly
    ] = ZIO.succeed(resourceCollection)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.devopsguru.model.UpdateResourceCollectionRequest
  ) extends zio.aws.devopsguru.model.UpdateResourceCollectionRequest.ReadOnly {
    override val action
        : zio.aws.devopsguru.model.UpdateResourceCollectionAction =
      zio.aws.devopsguru.model.UpdateResourceCollectionAction
        .wrap(impl.action())
    override val resourceCollection
        : zio.aws.devopsguru.model.UpdateResourceCollectionFilter.ReadOnly =
      zio.aws.devopsguru.model.UpdateResourceCollectionFilter
        .wrap(impl.resourceCollection())
  }
  def wrap(
      impl: software.amazon.awssdk.services.devopsguru.model.UpdateResourceCollectionRequest
  ): zio.aws.devopsguru.model.UpdateResourceCollectionRequest.ReadOnly =
    new Wrapper(impl)
}
