package zio.aws.devopsguru.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class UpdateServiceIntegrationConfig(
    opsCenter: Optional[zio.aws.devopsguru.model.OpsCenterIntegrationConfig] =
      Optional.Absent,
    logsAnomalyDetection: Optional[
      zio.aws.devopsguru.model.LogsAnomalyDetectionIntegrationConfig
    ] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.devopsguru.model.UpdateServiceIntegrationConfig = {
    import UpdateServiceIntegrationConfig.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.devopsguru.model.UpdateServiceIntegrationConfig
      .builder()
      .optionallyWith(opsCenter.map(value => value.buildAwsValue()))(
        _.opsCenter
      )
      .optionallyWith(logsAnomalyDetection.map(value => value.buildAwsValue()))(
        _.logsAnomalyDetection
      )
      .build()
  }
  def asReadOnly
      : zio.aws.devopsguru.model.UpdateServiceIntegrationConfig.ReadOnly =
    zio.aws.devopsguru.model.UpdateServiceIntegrationConfig
      .wrap(buildAwsValue())
}
object UpdateServiceIntegrationConfig {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.devopsguru.model.UpdateServiceIntegrationConfig
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.devopsguru.model.UpdateServiceIntegrationConfig =
      zio.aws.devopsguru.model.UpdateServiceIntegrationConfig(
        opsCenter.map(value => value.asEditable),
        logsAnomalyDetection.map(value => value.asEditable)
      )
    def opsCenter
        : Optional[zio.aws.devopsguru.model.OpsCenterIntegrationConfig.ReadOnly]
    def logsAnomalyDetection: Optional[
      zio.aws.devopsguru.model.LogsAnomalyDetectionIntegrationConfig.ReadOnly
    ]
    def getOpsCenter: ZIO[
      Any,
      AwsError,
      zio.aws.devopsguru.model.OpsCenterIntegrationConfig.ReadOnly
    ] = AwsError.unwrapOptionField("opsCenter", opsCenter)
    def getLogsAnomalyDetection: ZIO[
      Any,
      AwsError,
      zio.aws.devopsguru.model.LogsAnomalyDetectionIntegrationConfig.ReadOnly
    ] = AwsError.unwrapOptionField("logsAnomalyDetection", logsAnomalyDetection)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.devopsguru.model.UpdateServiceIntegrationConfig
  ) extends zio.aws.devopsguru.model.UpdateServiceIntegrationConfig.ReadOnly {
    override val opsCenter: Optional[
      zio.aws.devopsguru.model.OpsCenterIntegrationConfig.ReadOnly
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.opsCenter())
      .map(value =>
        zio.aws.devopsguru.model.OpsCenterIntegrationConfig.wrap(value)
      )
    override val logsAnomalyDetection: Optional[
      zio.aws.devopsguru.model.LogsAnomalyDetectionIntegrationConfig.ReadOnly
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.logsAnomalyDetection())
      .map(value =>
        zio.aws.devopsguru.model.LogsAnomalyDetectionIntegrationConfig
          .wrap(value)
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.devopsguru.model.UpdateServiceIntegrationConfig
  ): zio.aws.devopsguru.model.UpdateServiceIntegrationConfig.ReadOnly =
    new Wrapper(impl)
}
