package zio.aws.nimble
import zio.aws.nimble.model.GetStudioResponse.ReadOnly
import zio.aws.nimble.model.{
  GetLaunchProfileRequest,
  ListEulaAcceptancesRequest,
  CreateLaunchProfileRequest,
  GetLaunchProfileInitializationRequest,
  ListLaunchProfilesRequest,
  GetEulaRequest,
  DeleteStreamingImageRequest,
  ListStreamingSessionsRequest,
  DeleteStreamingSessionRequest,
  GetStudioMemberRequest,
  GetStreamingSessionStreamRequest,
  GetLaunchProfileDetailsRequest,
  CreateStudioRequest,
  ListStreamingImagesRequest,
  GetStreamingImageRequest,
  GetStudioRequest,
  StartStudioSsoConfigurationRepairRequest,
  ListEulasRequest,
  ListTagsForResourceRequest,
  CreateStreamingSessionStreamRequest,
  AcceptEulasRequest,
  GetStudioComponentRequest,
  DeleteLaunchProfileRequest,
  PutLaunchProfileMembersRequest,
  ListStudioComponentsRequest,
  UpdateStudioRequest,
  ListLaunchProfileMembersRequest,
  UpdateLaunchProfileRequest,
  ListStudiosRequest,
  PutStudioMembersRequest,
  UpdateStudioComponentRequest,
  UntagResourceRequest,
  DeleteStudioComponentRequest,
  CreateStreamingSessionRequest,
  GetLaunchProfileMemberRequest,
  ListStudioMembersRequest,
  UpdateLaunchProfileMemberRequest,
  DeleteLaunchProfileMemberRequest,
  CreateStudioComponentRequest,
  DeleteStudioMemberRequest,
  CreateStreamingImageRequest,
  TagResourceRequest,
  UpdateStreamingImageRequest,
  DeleteStudioRequest,
  StartStreamingSessionRequest,
  GetStreamingSessionRequest,
  StopStreamingSessionRequest
}
import zio.aws.core.config.AwsConfig
import software.amazon.awssdk.services.nimble.paginators.{
  ListEulasPublisher,
  ListStreamingImagesPublisher,
  ListLaunchProfileMembersPublisher,
  ListEulaAcceptancesPublisher,
  ListStudiosPublisher,
  ListStudioMembersPublisher,
  ListStreamingSessionsPublisher,
  ListStudioComponentsPublisher,
  ListLaunchProfilesPublisher
}
import software.amazon.awssdk.services.nimble.model.{
  ListStreamingSessionsResponse,
  ListStudioMembersResponse,
  ListLaunchProfilesResponse,
  GetStudioComponentResponse,
  CreateLaunchProfileResponse,
  GetLaunchProfileMemberResponse,
  UpdateLaunchProfileResponse,
  ListStreamingImagesResponse,
  GetStreamingSessionResponse,
  CreateStreamingSessionResponse,
  GetLaunchProfileResponse,
  GetLaunchProfileDetailsResponse,
  DeleteStreamingImageResponse,
  DeleteLaunchProfileMemberResponse,
  CreateStreamingImageResponse,
  CreateStudioResponse,
  LaunchProfile,
  Studio,
  PutStudioMembersResponse,
  ListEulaAcceptancesResponse,
  GetStudioMemberResponse,
  UpdateLaunchProfileMemberResponse,
  StartStudioSsoConfigurationRepairResponse,
  ListTagsForResourceResponse,
  UntagResourceResponse,
  GetStudioResponse,
  Eula,
  DeleteStudioResponse,
  GetStreamingImageResponse,
  DeleteStudioMemberResponse,
  CreateStudioComponentResponse,
  EulaAcceptance,
  PutLaunchProfileMembersResponse,
  GetEulaResponse,
  StartStreamingSessionResponse,
  UpdateStudioComponentResponse,
  StudioMembership,
  UpdateStudioResponse,
  GetLaunchProfileInitializationResponse,
  GetStreamingSessionStreamResponse,
  ListEulasResponse,
  ListStudiosResponse,
  UpdateStreamingImageResponse,
  DeleteStreamingSessionResponse,
  DeleteLaunchProfileResponse,
  StreamingImage,
  StopStreamingSessionResponse,
  AcceptEulasResponse,
  StreamingSession,
  ListLaunchProfileMembersResponse,
  DeleteStudioComponentResponse,
  TagResourceResponse,
  ListStudioComponentsResponse,
  StudioComponent,
  CreateStreamingSessionStreamResponse,
  LaunchProfileMembership
}
import zio.aws.core.{AwsServiceBase, AwsError}
import zio.aws.core.aspects.{AwsCallAspect, AspectSupport}
import zio.{ZEnvironment, ZManaged, IO, ZIO, ZLayer}
import software.amazon.awssdk.services.nimble.{
  NimbleAsyncClientBuilder,
  NimbleAsyncClient
}
import zio.stream.ZStream
import scala.jdk.CollectionConverters.*
trait Nimble extends AspectSupport[Nimble] {
  val api: NimbleAsyncClient
  def deleteStreamingImage(
      request: DeleteStreamingImageRequest
  ): IO[AwsError, zio.aws.nimble.model.DeleteStreamingImageResponse.ReadOnly]
  def listLaunchProfileMembers(
      request: ListLaunchProfileMembersRequest
  ): ZStream[
    Any,
    AwsError,
    zio.aws.nimble.model.LaunchProfileMembership.ReadOnly
  ]
  def listLaunchProfileMembersPaginated(
      request: ListLaunchProfileMembersRequest
  ): IO[
    AwsError,
    zio.aws.nimble.model.ListLaunchProfileMembersResponse.ReadOnly
  ]
  def createStudio(
      request: CreateStudioRequest
  ): IO[AwsError, zio.aws.nimble.model.CreateStudioResponse.ReadOnly]
  def updateLaunchProfile(
      request: UpdateLaunchProfileRequest
  ): IO[AwsError, zio.aws.nimble.model.UpdateLaunchProfileResponse.ReadOnly]
  def createLaunchProfile(
      request: CreateLaunchProfileRequest
  ): IO[AwsError, zio.aws.nimble.model.CreateLaunchProfileResponse.ReadOnly]
  def acceptEulas(
      request: AcceptEulasRequest
  ): IO[AwsError, zio.aws.nimble.model.AcceptEulasResponse.ReadOnly]
  def getEula(
      request: GetEulaRequest
  ): IO[AwsError, zio.aws.nimble.model.GetEulaResponse.ReadOnly]
  def getLaunchProfile(
      request: GetLaunchProfileRequest
  ): IO[AwsError, zio.aws.nimble.model.GetLaunchProfileResponse.ReadOnly]
  def listEulaAcceptances(
      request: ListEulaAcceptancesRequest
  ): ZStream[Any, AwsError, zio.aws.nimble.model.EulaAcceptance.ReadOnly]
  def listEulaAcceptancesPaginated(
      request: ListEulaAcceptancesRequest
  ): IO[AwsError, zio.aws.nimble.model.ListEulaAcceptancesResponse.ReadOnly]
  def deleteStreamingSession(
      request: DeleteStreamingSessionRequest
  ): IO[AwsError, zio.aws.nimble.model.DeleteStreamingSessionResponse.ReadOnly]
  def deleteLaunchProfile(
      request: DeleteLaunchProfileRequest
  ): IO[AwsError, zio.aws.nimble.model.DeleteLaunchProfileResponse.ReadOnly]
  def getStreamingImage(
      request: GetStreamingImageRequest
  ): IO[AwsError, zio.aws.nimble.model.GetStreamingImageResponse.ReadOnly]
  def updateStudioComponent(
      request: UpdateStudioComponentRequest
  ): IO[AwsError, zio.aws.nimble.model.UpdateStudioComponentResponse.ReadOnly]
  def listStudioComponents(
      request: ListStudioComponentsRequest
  ): ZStream[Any, AwsError, zio.aws.nimble.model.StudioComponent.ReadOnly]
  def listStudioComponentsPaginated(
      request: ListStudioComponentsRequest
  ): IO[AwsError, zio.aws.nimble.model.ListStudioComponentsResponse.ReadOnly]
  def getStudio(request: GetStudioRequest): IO[AwsError, ReadOnly]
  def listStudioMembers(
      request: ListStudioMembersRequest
  ): ZStream[Any, AwsError, zio.aws.nimble.model.StudioMembership.ReadOnly]
  def listStudioMembersPaginated(
      request: ListStudioMembersRequest
  ): IO[AwsError, zio.aws.nimble.model.ListStudioMembersResponse.ReadOnly]
  def listLaunchProfiles(
      request: ListLaunchProfilesRequest
  ): ZStream[Any, AwsError, zio.aws.nimble.model.LaunchProfile.ReadOnly]
  def listLaunchProfilesPaginated(
      request: ListLaunchProfilesRequest
  ): IO[AwsError, zio.aws.nimble.model.ListLaunchProfilesResponse.ReadOnly]
  def deleteStudioComponent(
      request: DeleteStudioComponentRequest
  ): IO[AwsError, zio.aws.nimble.model.DeleteStudioComponentResponse.ReadOnly]
  def createStreamingImage(
      request: CreateStreamingImageRequest
  ): IO[AwsError, zio.aws.nimble.model.CreateStreamingImageResponse.ReadOnly]
  def getStudioMember(
      request: GetStudioMemberRequest
  ): IO[AwsError, zio.aws.nimble.model.GetStudioMemberResponse.ReadOnly]
  def updateStreamingImage(
      request: UpdateStreamingImageRequest
  ): IO[AwsError, zio.aws.nimble.model.UpdateStreamingImageResponse.ReadOnly]
  def updateStudio(
      request: UpdateStudioRequest
  ): IO[AwsError, zio.aws.nimble.model.UpdateStudioResponse.ReadOnly]
  def updateLaunchProfileMember(request: UpdateLaunchProfileMemberRequest): IO[
    AwsError,
    zio.aws.nimble.model.UpdateLaunchProfileMemberResponse.ReadOnly
  ]
  def listStudios(
      request: ListStudiosRequest
  ): ZStream[Any, AwsError, zio.aws.nimble.model.Studio.ReadOnly]
  def listStudiosPaginated(
      request: ListStudiosRequest
  ): IO[AwsError, zio.aws.nimble.model.ListStudiosResponse.ReadOnly]
  def untagResource(
      request: UntagResourceRequest
  ): IO[AwsError, zio.aws.nimble.model.UntagResourceResponse.ReadOnly]
  def listStreamingSessions(
      request: ListStreamingSessionsRequest
  ): ZStream[Any, AwsError, zio.aws.nimble.model.StreamingSession.ReadOnly]
  def listStreamingSessionsPaginated(
      request: ListStreamingSessionsRequest
  ): IO[AwsError, zio.aws.nimble.model.ListStreamingSessionsResponse.ReadOnly]
  def listStreamingImages(
      request: ListStreamingImagesRequest
  ): ZStream[Any, AwsError, zio.aws.nimble.model.StreamingImage.ReadOnly]
  def listStreamingImagesPaginated(
      request: ListStreamingImagesRequest
  ): IO[AwsError, zio.aws.nimble.model.ListStreamingImagesResponse.ReadOnly]
  def putStudioMembers(
      request: PutStudioMembersRequest
  ): IO[AwsError, zio.aws.nimble.model.PutStudioMembersResponse.ReadOnly]
  def listEulas(
      request: ListEulasRequest
  ): ZStream[Any, AwsError, zio.aws.nimble.model.Eula.ReadOnly]
  def listEulasPaginated(
      request: ListEulasRequest
  ): IO[AwsError, zio.aws.nimble.model.ListEulasResponse.ReadOnly]
  def startStreamingSession(
      request: StartStreamingSessionRequest
  ): IO[AwsError, zio.aws.nimble.model.StartStreamingSessionResponse.ReadOnly]
  def getStreamingSessionStream(request: GetStreamingSessionStreamRequest): IO[
    AwsError,
    zio.aws.nimble.model.GetStreamingSessionStreamResponse.ReadOnly
  ]
  def createStreamingSession(
      request: CreateStreamingSessionRequest
  ): IO[AwsError, zio.aws.nimble.model.CreateStreamingSessionResponse.ReadOnly]
  def getStreamingSession(
      request: GetStreamingSessionRequest
  ): IO[AwsError, zio.aws.nimble.model.GetStreamingSessionResponse.ReadOnly]
  def listTagsForResource(
      request: ListTagsForResourceRequest
  ): IO[AwsError, zio.aws.nimble.model.ListTagsForResourceResponse.ReadOnly]
  def getLaunchProfileInitialization(
      request: GetLaunchProfileInitializationRequest
  ): IO[
    AwsError,
    zio.aws.nimble.model.GetLaunchProfileInitializationResponse.ReadOnly
  ]
  def deleteStudio(
      request: DeleteStudioRequest
  ): IO[AwsError, zio.aws.nimble.model.DeleteStudioResponse.ReadOnly]
  def tagResource(
      request: TagResourceRequest
  ): IO[AwsError, zio.aws.nimble.model.TagResourceResponse.ReadOnly]
  def putLaunchProfileMembers(
      request: PutLaunchProfileMembersRequest
  ): IO[AwsError, zio.aws.nimble.model.PutLaunchProfileMembersResponse.ReadOnly]
  def getStudioComponent(
      request: GetStudioComponentRequest
  ): IO[AwsError, zio.aws.nimble.model.GetStudioComponentResponse.ReadOnly]
  def getLaunchProfileMember(
      request: GetLaunchProfileMemberRequest
  ): IO[AwsError, zio.aws.nimble.model.GetLaunchProfileMemberResponse.ReadOnly]
  def deleteStudioMember(
      request: DeleteStudioMemberRequest
  ): IO[AwsError, zio.aws.nimble.model.DeleteStudioMemberResponse.ReadOnly]
  def createStudioComponent(
      request: CreateStudioComponentRequest
  ): IO[AwsError, zio.aws.nimble.model.CreateStudioComponentResponse.ReadOnly]
  def createStreamingSessionStream(
      request: CreateStreamingSessionStreamRequest
  ): IO[
    AwsError,
    zio.aws.nimble.model.CreateStreamingSessionStreamResponse.ReadOnly
  ]
  def startStudioSSOConfigurationRepair(
      request: StartStudioSsoConfigurationRepairRequest
  ): IO[
    AwsError,
    zio.aws.nimble.model.StartStudioSsoConfigurationRepairResponse.ReadOnly
  ]
  def deleteLaunchProfileMember(request: DeleteLaunchProfileMemberRequest): IO[
    AwsError,
    zio.aws.nimble.model.DeleteLaunchProfileMemberResponse.ReadOnly
  ]
  def getLaunchProfileDetails(
      request: GetLaunchProfileDetailsRequest
  ): IO[AwsError, zio.aws.nimble.model.GetLaunchProfileDetailsResponse.ReadOnly]
  def stopStreamingSession(
      request: StopStreamingSessionRequest
  ): IO[AwsError, zio.aws.nimble.model.StopStreamingSessionResponse.ReadOnly]
}
object Nimble {
  val live: ZLayer[AwsConfig, java.lang.Throwable, Nimble] = customized(
    identity
  )
  def customized(
      customization: NimbleAsyncClientBuilder => NimbleAsyncClientBuilder
  ): ZLayer[AwsConfig, java.lang.Throwable, Nimble] = managed(
    customization
  ).toLayer
  def managed(
      customization: NimbleAsyncClientBuilder => NimbleAsyncClientBuilder
  ): ZManaged[AwsConfig, java.lang.Throwable, Nimble] = for (
    awsConfig <- ZManaged.service[AwsConfig];
    executor <- ZIO.executor.toManaged;
    builder = NimbleAsyncClient
      .builder()
      .asyncConfiguration(
        software.amazon.awssdk.core.client.config.ClientAsyncConfiguration
          .builder()
          .advancedOption(
            software.amazon.awssdk.core.client.config.SdkAdvancedAsyncClientOption.FUTURE_COMPLETION_EXECUTOR,
            executor.asJava
          )
          .build()
      );
    b0 <- awsConfig
      .configure[NimbleAsyncClient, NimbleAsyncClientBuilder](builder)
      .toManaged;
    b1 <- awsConfig
      .configureHttpClient[NimbleAsyncClient, NimbleAsyncClientBuilder](
        b0,
        zio.aws.core.httpclient.ServiceHttpCapabilities(supportsHttp2 = false)
      )
      .toManaged; client <- zio.ZIO(customization(b1).build()).toManaged
  ) yield new NimbleImpl(client, AwsCallAspect.identity, ZEnvironment.empty)
  private class NimbleImpl[R](
      override val api: NimbleAsyncClient,
      override val aspect: AwsCallAspect[R],
      r: ZEnvironment[R]
  ) extends Nimble
      with AwsServiceBase[R] {
    override val serviceName: String = "Nimble"
    override def withAspect[R1](
        newAspect: AwsCallAspect[R1],
        r: ZEnvironment[R1]
    ): NimbleImpl[R1] = new NimbleImpl(api, newAspect, r)
    def deleteStreamingImage(request: DeleteStreamingImageRequest): IO[
      AwsError,
      zio.aws.nimble.model.DeleteStreamingImageResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.nimble.model.DeleteStreamingImageRequest,
      DeleteStreamingImageResponse
    ]("deleteStreamingImage", api.deleteStreamingImage)(request.buildAwsValue())
      .map(zio.aws.nimble.model.DeleteStreamingImageResponse.wrap)
      .provideEnvironment(r)
    def listLaunchProfileMembers(
        request: ListLaunchProfileMembersRequest
    ): ZStream[
      Any,
      AwsError,
      zio.aws.nimble.model.LaunchProfileMembership.ReadOnly
    ] = asyncJavaPaginatedRequest[
      software.amazon.awssdk.services.nimble.model.ListLaunchProfileMembersRequest,
      LaunchProfileMembership,
      ListLaunchProfileMembersPublisher
    ](
      "listLaunchProfileMembers",
      api.listLaunchProfileMembersPaginator,
      _.members()
    )(request.buildAwsValue())
      .map(item => zio.aws.nimble.model.LaunchProfileMembership.wrap(item))
      .provideEnvironment(r)
    def listLaunchProfileMembersPaginated(
        request: ListLaunchProfileMembersRequest
    ): IO[
      AwsError,
      zio.aws.nimble.model.ListLaunchProfileMembersResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.nimble.model.ListLaunchProfileMembersRequest,
      ListLaunchProfileMembersResponse
    ]("listLaunchProfileMembers", api.listLaunchProfileMembers)(
      request.buildAwsValue()
    ).map(zio.aws.nimble.model.ListLaunchProfileMembersResponse.wrap)
      .provideEnvironment(r)
    def createStudio(
        request: CreateStudioRequest
    ): IO[AwsError, zio.aws.nimble.model.CreateStudioResponse.ReadOnly] =
      asyncRequestResponse[
        software.amazon.awssdk.services.nimble.model.CreateStudioRequest,
        CreateStudioResponse
      ]("createStudio", api.createStudio)(request.buildAwsValue())
        .map(zio.aws.nimble.model.CreateStudioResponse.wrap)
        .provideEnvironment(r)
    def updateLaunchProfile(
        request: UpdateLaunchProfileRequest
    ): IO[AwsError, zio.aws.nimble.model.UpdateLaunchProfileResponse.ReadOnly] =
      asyncRequestResponse[
        software.amazon.awssdk.services.nimble.model.UpdateLaunchProfileRequest,
        UpdateLaunchProfileResponse
      ]("updateLaunchProfile", api.updateLaunchProfile)(request.buildAwsValue())
        .map(zio.aws.nimble.model.UpdateLaunchProfileResponse.wrap)
        .provideEnvironment(r)
    def createLaunchProfile(
        request: CreateLaunchProfileRequest
    ): IO[AwsError, zio.aws.nimble.model.CreateLaunchProfileResponse.ReadOnly] =
      asyncRequestResponse[
        software.amazon.awssdk.services.nimble.model.CreateLaunchProfileRequest,
        CreateLaunchProfileResponse
      ]("createLaunchProfile", api.createLaunchProfile)(request.buildAwsValue())
        .map(zio.aws.nimble.model.CreateLaunchProfileResponse.wrap)
        .provideEnvironment(r)
    def acceptEulas(
        request: AcceptEulasRequest
    ): IO[AwsError, zio.aws.nimble.model.AcceptEulasResponse.ReadOnly] =
      asyncRequestResponse[
        software.amazon.awssdk.services.nimble.model.AcceptEulasRequest,
        AcceptEulasResponse
      ]("acceptEulas", api.acceptEulas)(request.buildAwsValue())
        .map(zio.aws.nimble.model.AcceptEulasResponse.wrap)
        .provideEnvironment(r)
    def getEula(
        request: GetEulaRequest
    ): IO[AwsError, zio.aws.nimble.model.GetEulaResponse.ReadOnly] =
      asyncRequestResponse[
        software.amazon.awssdk.services.nimble.model.GetEulaRequest,
        GetEulaResponse
      ]("getEula", api.getEula)(request.buildAwsValue())
        .map(zio.aws.nimble.model.GetEulaResponse.wrap)
        .provideEnvironment(r)
    def getLaunchProfile(
        request: GetLaunchProfileRequest
    ): IO[AwsError, zio.aws.nimble.model.GetLaunchProfileResponse.ReadOnly] =
      asyncRequestResponse[
        software.amazon.awssdk.services.nimble.model.GetLaunchProfileRequest,
        GetLaunchProfileResponse
      ]("getLaunchProfile", api.getLaunchProfile)(request.buildAwsValue())
        .map(zio.aws.nimble.model.GetLaunchProfileResponse.wrap)
        .provideEnvironment(r)
    def listEulaAcceptances(
        request: ListEulaAcceptancesRequest
    ): ZStream[Any, AwsError, zio.aws.nimble.model.EulaAcceptance.ReadOnly] =
      asyncJavaPaginatedRequest[
        software.amazon.awssdk.services.nimble.model.ListEulaAcceptancesRequest,
        EulaAcceptance,
        ListEulaAcceptancesPublisher
      ](
        "listEulaAcceptances",
        api.listEulaAcceptancesPaginator,
        _.eulaAcceptances()
      )(request.buildAwsValue())
        .map(item => zio.aws.nimble.model.EulaAcceptance.wrap(item))
        .provideEnvironment(r)
    def listEulaAcceptancesPaginated(
        request: ListEulaAcceptancesRequest
    ): IO[AwsError, zio.aws.nimble.model.ListEulaAcceptancesResponse.ReadOnly] =
      asyncRequestResponse[
        software.amazon.awssdk.services.nimble.model.ListEulaAcceptancesRequest,
        ListEulaAcceptancesResponse
      ]("listEulaAcceptances", api.listEulaAcceptances)(request.buildAwsValue())
        .map(zio.aws.nimble.model.ListEulaAcceptancesResponse.wrap)
        .provideEnvironment(r)
    def deleteStreamingSession(request: DeleteStreamingSessionRequest): IO[
      AwsError,
      zio.aws.nimble.model.DeleteStreamingSessionResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.nimble.model.DeleteStreamingSessionRequest,
      DeleteStreamingSessionResponse
    ]("deleteStreamingSession", api.deleteStreamingSession)(
      request.buildAwsValue()
    ).map(zio.aws.nimble.model.DeleteStreamingSessionResponse.wrap)
      .provideEnvironment(r)
    def deleteLaunchProfile(
        request: DeleteLaunchProfileRequest
    ): IO[AwsError, zio.aws.nimble.model.DeleteLaunchProfileResponse.ReadOnly] =
      asyncRequestResponse[
        software.amazon.awssdk.services.nimble.model.DeleteLaunchProfileRequest,
        DeleteLaunchProfileResponse
      ]("deleteLaunchProfile", api.deleteLaunchProfile)(request.buildAwsValue())
        .map(zio.aws.nimble.model.DeleteLaunchProfileResponse.wrap)
        .provideEnvironment(r)
    def getStreamingImage(
        request: GetStreamingImageRequest
    ): IO[AwsError, zio.aws.nimble.model.GetStreamingImageResponse.ReadOnly] =
      asyncRequestResponse[
        software.amazon.awssdk.services.nimble.model.GetStreamingImageRequest,
        GetStreamingImageResponse
      ]("getStreamingImage", api.getStreamingImage)(request.buildAwsValue())
        .map(zio.aws.nimble.model.GetStreamingImageResponse.wrap)
        .provideEnvironment(r)
    def updateStudioComponent(request: UpdateStudioComponentRequest): IO[
      AwsError,
      zio.aws.nimble.model.UpdateStudioComponentResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.nimble.model.UpdateStudioComponentRequest,
      UpdateStudioComponentResponse
    ]("updateStudioComponent", api.updateStudioComponent)(
      request.buildAwsValue()
    ).map(zio.aws.nimble.model.UpdateStudioComponentResponse.wrap)
      .provideEnvironment(r)
    def listStudioComponents(request: ListStudioComponentsRequest): ZStream[
      Any,
      AwsError,
      zio.aws.nimble.model.StudioComponent.ReadOnly
    ] = asyncJavaPaginatedRequest[
      software.amazon.awssdk.services.nimble.model.ListStudioComponentsRequest,
      StudioComponent,
      ListStudioComponentsPublisher
    ](
      "listStudioComponents",
      api.listStudioComponentsPaginator,
      _.studioComponents()
    )(request.buildAwsValue())
      .map(item => zio.aws.nimble.model.StudioComponent.wrap(item))
      .provideEnvironment(r)
    def listStudioComponentsPaginated(request: ListStudioComponentsRequest): IO[
      AwsError,
      zio.aws.nimble.model.ListStudioComponentsResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.nimble.model.ListStudioComponentsRequest,
      ListStudioComponentsResponse
    ]("listStudioComponents", api.listStudioComponents)(request.buildAwsValue())
      .map(zio.aws.nimble.model.ListStudioComponentsResponse.wrap)
      .provideEnvironment(r)
    def getStudio(request: GetStudioRequest): IO[AwsError, ReadOnly] =
      asyncRequestResponse[
        software.amazon.awssdk.services.nimble.model.GetStudioRequest,
        GetStudioResponse
      ]("getStudio", api.getStudio)(request.buildAwsValue())
        .map(zio.aws.nimble.model.GetStudioResponse.wrap)
        .provideEnvironment(r)
    def listStudioMembers(
        request: ListStudioMembersRequest
    ): ZStream[Any, AwsError, zio.aws.nimble.model.StudioMembership.ReadOnly] =
      asyncJavaPaginatedRequest[
        software.amazon.awssdk.services.nimble.model.ListStudioMembersRequest,
        StudioMembership,
        ListStudioMembersPublisher
      ]("listStudioMembers", api.listStudioMembersPaginator, _.members())(
        request.buildAwsValue()
      ).map(item => zio.aws.nimble.model.StudioMembership.wrap(item))
        .provideEnvironment(r)
    def listStudioMembersPaginated(
        request: ListStudioMembersRequest
    ): IO[AwsError, zio.aws.nimble.model.ListStudioMembersResponse.ReadOnly] =
      asyncRequestResponse[
        software.amazon.awssdk.services.nimble.model.ListStudioMembersRequest,
        ListStudioMembersResponse
      ]("listStudioMembers", api.listStudioMembers)(request.buildAwsValue())
        .map(zio.aws.nimble.model.ListStudioMembersResponse.wrap)
        .provideEnvironment(r)
    def listLaunchProfiles(
        request: ListLaunchProfilesRequest
    ): ZStream[Any, AwsError, zio.aws.nimble.model.LaunchProfile.ReadOnly] =
      asyncJavaPaginatedRequest[
        software.amazon.awssdk.services.nimble.model.ListLaunchProfilesRequest,
        LaunchProfile,
        ListLaunchProfilesPublisher
      ](
        "listLaunchProfiles",
        api.listLaunchProfilesPaginator,
        _.launchProfiles()
      )(request.buildAwsValue())
        .map(item => zio.aws.nimble.model.LaunchProfile.wrap(item))
        .provideEnvironment(r)
    def listLaunchProfilesPaginated(
        request: ListLaunchProfilesRequest
    ): IO[AwsError, zio.aws.nimble.model.ListLaunchProfilesResponse.ReadOnly] =
      asyncRequestResponse[
        software.amazon.awssdk.services.nimble.model.ListLaunchProfilesRequest,
        ListLaunchProfilesResponse
      ]("listLaunchProfiles", api.listLaunchProfiles)(request.buildAwsValue())
        .map(zio.aws.nimble.model.ListLaunchProfilesResponse.wrap)
        .provideEnvironment(r)
    def deleteStudioComponent(request: DeleteStudioComponentRequest): IO[
      AwsError,
      zio.aws.nimble.model.DeleteStudioComponentResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.nimble.model.DeleteStudioComponentRequest,
      DeleteStudioComponentResponse
    ]("deleteStudioComponent", api.deleteStudioComponent)(
      request.buildAwsValue()
    ).map(zio.aws.nimble.model.DeleteStudioComponentResponse.wrap)
      .provideEnvironment(r)
    def createStreamingImage(request: CreateStreamingImageRequest): IO[
      AwsError,
      zio.aws.nimble.model.CreateStreamingImageResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.nimble.model.CreateStreamingImageRequest,
      CreateStreamingImageResponse
    ]("createStreamingImage", api.createStreamingImage)(request.buildAwsValue())
      .map(zio.aws.nimble.model.CreateStreamingImageResponse.wrap)
      .provideEnvironment(r)
    def getStudioMember(
        request: GetStudioMemberRequest
    ): IO[AwsError, zio.aws.nimble.model.GetStudioMemberResponse.ReadOnly] =
      asyncRequestResponse[
        software.amazon.awssdk.services.nimble.model.GetStudioMemberRequest,
        GetStudioMemberResponse
      ]("getStudioMember", api.getStudioMember)(request.buildAwsValue())
        .map(zio.aws.nimble.model.GetStudioMemberResponse.wrap)
        .provideEnvironment(r)
    def updateStreamingImage(request: UpdateStreamingImageRequest): IO[
      AwsError,
      zio.aws.nimble.model.UpdateStreamingImageResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.nimble.model.UpdateStreamingImageRequest,
      UpdateStreamingImageResponse
    ]("updateStreamingImage", api.updateStreamingImage)(request.buildAwsValue())
      .map(zio.aws.nimble.model.UpdateStreamingImageResponse.wrap)
      .provideEnvironment(r)
    def updateStudio(
        request: UpdateStudioRequest
    ): IO[AwsError, zio.aws.nimble.model.UpdateStudioResponse.ReadOnly] =
      asyncRequestResponse[
        software.amazon.awssdk.services.nimble.model.UpdateStudioRequest,
        UpdateStudioResponse
      ]("updateStudio", api.updateStudio)(request.buildAwsValue())
        .map(zio.aws.nimble.model.UpdateStudioResponse.wrap)
        .provideEnvironment(r)
    def updateLaunchProfileMember(
        request: UpdateLaunchProfileMemberRequest
    ): IO[
      AwsError,
      zio.aws.nimble.model.UpdateLaunchProfileMemberResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.nimble.model.UpdateLaunchProfileMemberRequest,
      UpdateLaunchProfileMemberResponse
    ]("updateLaunchProfileMember", api.updateLaunchProfileMember)(
      request.buildAwsValue()
    ).map(zio.aws.nimble.model.UpdateLaunchProfileMemberResponse.wrap)
      .provideEnvironment(r)
    def listStudios(
        request: ListStudiosRequest
    ): ZStream[Any, AwsError, zio.aws.nimble.model.Studio.ReadOnly] =
      asyncJavaPaginatedRequest[
        software.amazon.awssdk.services.nimble.model.ListStudiosRequest,
        Studio,
        ListStudiosPublisher
      ]("listStudios", api.listStudiosPaginator, _.studios())(
        request.buildAwsValue()
      ).map(item => zio.aws.nimble.model.Studio.wrap(item))
        .provideEnvironment(r)
    def listStudiosPaginated(
        request: ListStudiosRequest
    ): IO[AwsError, zio.aws.nimble.model.ListStudiosResponse.ReadOnly] =
      asyncRequestResponse[
        software.amazon.awssdk.services.nimble.model.ListStudiosRequest,
        ListStudiosResponse
      ]("listStudios", api.listStudios)(request.buildAwsValue())
        .map(zio.aws.nimble.model.ListStudiosResponse.wrap)
        .provideEnvironment(r)
    def untagResource(
        request: UntagResourceRequest
    ): IO[AwsError, zio.aws.nimble.model.UntagResourceResponse.ReadOnly] =
      asyncRequestResponse[
        software.amazon.awssdk.services.nimble.model.UntagResourceRequest,
        UntagResourceResponse
      ]("untagResource", api.untagResource)(request.buildAwsValue())
        .map(zio.aws.nimble.model.UntagResourceResponse.wrap)
        .provideEnvironment(r)
    def listStreamingSessions(request: ListStreamingSessionsRequest): ZStream[
      Any,
      AwsError,
      zio.aws.nimble.model.StreamingSession.ReadOnly
    ] = asyncJavaPaginatedRequest[
      software.amazon.awssdk.services.nimble.model.ListStreamingSessionsRequest,
      StreamingSession,
      ListStreamingSessionsPublisher
    ](
      "listStreamingSessions",
      api.listStreamingSessionsPaginator,
      _.sessions()
    )(request.buildAwsValue())
      .map(item => zio.aws.nimble.model.StreamingSession.wrap(item))
      .provideEnvironment(r)
    def listStreamingSessionsPaginated(
        request: ListStreamingSessionsRequest
    ): IO[
      AwsError,
      zio.aws.nimble.model.ListStreamingSessionsResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.nimble.model.ListStreamingSessionsRequest,
      ListStreamingSessionsResponse
    ]("listStreamingSessions", api.listStreamingSessions)(
      request.buildAwsValue()
    ).map(zio.aws.nimble.model.ListStreamingSessionsResponse.wrap)
      .provideEnvironment(r)
    def listStreamingImages(
        request: ListStreamingImagesRequest
    ): ZStream[Any, AwsError, zio.aws.nimble.model.StreamingImage.ReadOnly] =
      asyncJavaPaginatedRequest[
        software.amazon.awssdk.services.nimble.model.ListStreamingImagesRequest,
        StreamingImage,
        ListStreamingImagesPublisher
      ](
        "listStreamingImages",
        api.listStreamingImagesPaginator,
        _.streamingImages()
      )(request.buildAwsValue())
        .map(item => zio.aws.nimble.model.StreamingImage.wrap(item))
        .provideEnvironment(r)
    def listStreamingImagesPaginated(
        request: ListStreamingImagesRequest
    ): IO[AwsError, zio.aws.nimble.model.ListStreamingImagesResponse.ReadOnly] =
      asyncRequestResponse[
        software.amazon.awssdk.services.nimble.model.ListStreamingImagesRequest,
        ListStreamingImagesResponse
      ]("listStreamingImages", api.listStreamingImages)(request.buildAwsValue())
        .map(zio.aws.nimble.model.ListStreamingImagesResponse.wrap)
        .provideEnvironment(r)
    def putStudioMembers(
        request: PutStudioMembersRequest
    ): IO[AwsError, zio.aws.nimble.model.PutStudioMembersResponse.ReadOnly] =
      asyncRequestResponse[
        software.amazon.awssdk.services.nimble.model.PutStudioMembersRequest,
        PutStudioMembersResponse
      ]("putStudioMembers", api.putStudioMembers)(request.buildAwsValue())
        .map(zio.aws.nimble.model.PutStudioMembersResponse.wrap)
        .provideEnvironment(r)
    def listEulas(
        request: ListEulasRequest
    ): ZStream[Any, AwsError, zio.aws.nimble.model.Eula.ReadOnly] =
      asyncJavaPaginatedRequest[
        software.amazon.awssdk.services.nimble.model.ListEulasRequest,
        Eula,
        ListEulasPublisher
      ]("listEulas", api.listEulasPaginator, _.eulas())(request.buildAwsValue())
        .map(item => zio.aws.nimble.model.Eula.wrap(item))
        .provideEnvironment(r)
    def listEulasPaginated(
        request: ListEulasRequest
    ): IO[AwsError, zio.aws.nimble.model.ListEulasResponse.ReadOnly] =
      asyncRequestResponse[
        software.amazon.awssdk.services.nimble.model.ListEulasRequest,
        ListEulasResponse
      ]("listEulas", api.listEulas)(request.buildAwsValue())
        .map(zio.aws.nimble.model.ListEulasResponse.wrap)
        .provideEnvironment(r)
    def startStreamingSession(request: StartStreamingSessionRequest): IO[
      AwsError,
      zio.aws.nimble.model.StartStreamingSessionResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.nimble.model.StartStreamingSessionRequest,
      StartStreamingSessionResponse
    ]("startStreamingSession", api.startStreamingSession)(
      request.buildAwsValue()
    ).map(zio.aws.nimble.model.StartStreamingSessionResponse.wrap)
      .provideEnvironment(r)
    def getStreamingSessionStream(
        request: GetStreamingSessionStreamRequest
    ): IO[
      AwsError,
      zio.aws.nimble.model.GetStreamingSessionStreamResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.nimble.model.GetStreamingSessionStreamRequest,
      GetStreamingSessionStreamResponse
    ]("getStreamingSessionStream", api.getStreamingSessionStream)(
      request.buildAwsValue()
    ).map(zio.aws.nimble.model.GetStreamingSessionStreamResponse.wrap)
      .provideEnvironment(r)
    def createStreamingSession(request: CreateStreamingSessionRequest): IO[
      AwsError,
      zio.aws.nimble.model.CreateStreamingSessionResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.nimble.model.CreateStreamingSessionRequest,
      CreateStreamingSessionResponse
    ]("createStreamingSession", api.createStreamingSession)(
      request.buildAwsValue()
    ).map(zio.aws.nimble.model.CreateStreamingSessionResponse.wrap)
      .provideEnvironment(r)
    def getStreamingSession(
        request: GetStreamingSessionRequest
    ): IO[AwsError, zio.aws.nimble.model.GetStreamingSessionResponse.ReadOnly] =
      asyncRequestResponse[
        software.amazon.awssdk.services.nimble.model.GetStreamingSessionRequest,
        GetStreamingSessionResponse
      ]("getStreamingSession", api.getStreamingSession)(request.buildAwsValue())
        .map(zio.aws.nimble.model.GetStreamingSessionResponse.wrap)
        .provideEnvironment(r)
    def listTagsForResource(
        request: ListTagsForResourceRequest
    ): IO[AwsError, zio.aws.nimble.model.ListTagsForResourceResponse.ReadOnly] =
      asyncRequestResponse[
        software.amazon.awssdk.services.nimble.model.ListTagsForResourceRequest,
        ListTagsForResourceResponse
      ]("listTagsForResource", api.listTagsForResource)(request.buildAwsValue())
        .map(zio.aws.nimble.model.ListTagsForResourceResponse.wrap)
        .provideEnvironment(r)
    def getLaunchProfileInitialization(
        request: GetLaunchProfileInitializationRequest
    ): IO[
      AwsError,
      zio.aws.nimble.model.GetLaunchProfileInitializationResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.nimble.model.GetLaunchProfileInitializationRequest,
      GetLaunchProfileInitializationResponse
    ]("getLaunchProfileInitialization", api.getLaunchProfileInitialization)(
      request.buildAwsValue()
    ).map(zio.aws.nimble.model.GetLaunchProfileInitializationResponse.wrap)
      .provideEnvironment(r)
    def deleteStudio(
        request: DeleteStudioRequest
    ): IO[AwsError, zio.aws.nimble.model.DeleteStudioResponse.ReadOnly] =
      asyncRequestResponse[
        software.amazon.awssdk.services.nimble.model.DeleteStudioRequest,
        DeleteStudioResponse
      ]("deleteStudio", api.deleteStudio)(request.buildAwsValue())
        .map(zio.aws.nimble.model.DeleteStudioResponse.wrap)
        .provideEnvironment(r)
    def tagResource(
        request: TagResourceRequest
    ): IO[AwsError, zio.aws.nimble.model.TagResourceResponse.ReadOnly] =
      asyncRequestResponse[
        software.amazon.awssdk.services.nimble.model.TagResourceRequest,
        TagResourceResponse
      ]("tagResource", api.tagResource)(request.buildAwsValue())
        .map(zio.aws.nimble.model.TagResourceResponse.wrap)
        .provideEnvironment(r)
    def putLaunchProfileMembers(request: PutLaunchProfileMembersRequest): IO[
      AwsError,
      zio.aws.nimble.model.PutLaunchProfileMembersResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.nimble.model.PutLaunchProfileMembersRequest,
      PutLaunchProfileMembersResponse
    ]("putLaunchProfileMembers", api.putLaunchProfileMembers)(
      request.buildAwsValue()
    ).map(zio.aws.nimble.model.PutLaunchProfileMembersResponse.wrap)
      .provideEnvironment(r)
    def getStudioComponent(
        request: GetStudioComponentRequest
    ): IO[AwsError, zio.aws.nimble.model.GetStudioComponentResponse.ReadOnly] =
      asyncRequestResponse[
        software.amazon.awssdk.services.nimble.model.GetStudioComponentRequest,
        GetStudioComponentResponse
      ]("getStudioComponent", api.getStudioComponent)(request.buildAwsValue())
        .map(zio.aws.nimble.model.GetStudioComponentResponse.wrap)
        .provideEnvironment(r)
    def getLaunchProfileMember(request: GetLaunchProfileMemberRequest): IO[
      AwsError,
      zio.aws.nimble.model.GetLaunchProfileMemberResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.nimble.model.GetLaunchProfileMemberRequest,
      GetLaunchProfileMemberResponse
    ]("getLaunchProfileMember", api.getLaunchProfileMember)(
      request.buildAwsValue()
    ).map(zio.aws.nimble.model.GetLaunchProfileMemberResponse.wrap)
      .provideEnvironment(r)
    def deleteStudioMember(
        request: DeleteStudioMemberRequest
    ): IO[AwsError, zio.aws.nimble.model.DeleteStudioMemberResponse.ReadOnly] =
      asyncRequestResponse[
        software.amazon.awssdk.services.nimble.model.DeleteStudioMemberRequest,
        DeleteStudioMemberResponse
      ]("deleteStudioMember", api.deleteStudioMember)(request.buildAwsValue())
        .map(zio.aws.nimble.model.DeleteStudioMemberResponse.wrap)
        .provideEnvironment(r)
    def createStudioComponent(request: CreateStudioComponentRequest): IO[
      AwsError,
      zio.aws.nimble.model.CreateStudioComponentResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.nimble.model.CreateStudioComponentRequest,
      CreateStudioComponentResponse
    ]("createStudioComponent", api.createStudioComponent)(
      request.buildAwsValue()
    ).map(zio.aws.nimble.model.CreateStudioComponentResponse.wrap)
      .provideEnvironment(r)
    def createStreamingSessionStream(
        request: CreateStreamingSessionStreamRequest
    ): IO[
      AwsError,
      zio.aws.nimble.model.CreateStreamingSessionStreamResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.nimble.model.CreateStreamingSessionStreamRequest,
      CreateStreamingSessionStreamResponse
    ]("createStreamingSessionStream", api.createStreamingSessionStream)(
      request.buildAwsValue()
    ).map(zio.aws.nimble.model.CreateStreamingSessionStreamResponse.wrap)
      .provideEnvironment(r)
    def startStudioSSOConfigurationRepair(
        request: StartStudioSsoConfigurationRepairRequest
    ): IO[
      AwsError,
      zio.aws.nimble.model.StartStudioSsoConfigurationRepairResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.nimble.model.StartStudioSsoConfigurationRepairRequest,
      StartStudioSsoConfigurationRepairResponse
    ](
      "startStudioSSOConfigurationRepair",
      api.startStudioSSOConfigurationRepair
    )(request.buildAwsValue())
      .map(zio.aws.nimble.model.StartStudioSsoConfigurationRepairResponse.wrap)
      .provideEnvironment(r)
    def deleteLaunchProfileMember(
        request: DeleteLaunchProfileMemberRequest
    ): IO[
      AwsError,
      zio.aws.nimble.model.DeleteLaunchProfileMemberResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.nimble.model.DeleteLaunchProfileMemberRequest,
      DeleteLaunchProfileMemberResponse
    ]("deleteLaunchProfileMember", api.deleteLaunchProfileMember)(
      request.buildAwsValue()
    ).map(zio.aws.nimble.model.DeleteLaunchProfileMemberResponse.wrap)
      .provideEnvironment(r)
    def getLaunchProfileDetails(request: GetLaunchProfileDetailsRequest): IO[
      AwsError,
      zio.aws.nimble.model.GetLaunchProfileDetailsResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.nimble.model.GetLaunchProfileDetailsRequest,
      GetLaunchProfileDetailsResponse
    ]("getLaunchProfileDetails", api.getLaunchProfileDetails)(
      request.buildAwsValue()
    ).map(zio.aws.nimble.model.GetLaunchProfileDetailsResponse.wrap)
      .provideEnvironment(r)
    def stopStreamingSession(request: StopStreamingSessionRequest): IO[
      AwsError,
      zio.aws.nimble.model.StopStreamingSessionResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.nimble.model.StopStreamingSessionRequest,
      StopStreamingSessionResponse
    ]("stopStreamingSession", api.stopStreamingSession)(request.buildAwsValue())
      .map(zio.aws.nimble.model.StopStreamingSessionResponse.wrap)
      .provideEnvironment(r)
  }
  def deleteStreamingImage(request: DeleteStreamingImageRequest): ZIO[
    zio.aws.nimble.Nimble,
    AwsError,
    zio.aws.nimble.model.DeleteStreamingImageResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.deleteStreamingImage(request))
  def listLaunchProfileMembers(
      request: ListLaunchProfileMembersRequest
  ): ZStream[
    zio.aws.nimble.Nimble,
    AwsError,
    zio.aws.nimble.model.LaunchProfileMembership.ReadOnly
  ] = ZStream.serviceWithStream(_.listLaunchProfileMembers(request))
  def listLaunchProfileMembersPaginated(
      request: ListLaunchProfileMembersRequest
  ): ZIO[
    zio.aws.nimble.Nimble,
    AwsError,
    zio.aws.nimble.model.ListLaunchProfileMembersResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.listLaunchProfileMembersPaginated(request))
  def createStudio(request: CreateStudioRequest): ZIO[
    zio.aws.nimble.Nimble,
    AwsError,
    zio.aws.nimble.model.CreateStudioResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.createStudio(request))
  def updateLaunchProfile(request: UpdateLaunchProfileRequest): ZIO[
    zio.aws.nimble.Nimble,
    AwsError,
    zio.aws.nimble.model.UpdateLaunchProfileResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.updateLaunchProfile(request))
  def createLaunchProfile(request: CreateLaunchProfileRequest): ZIO[
    zio.aws.nimble.Nimble,
    AwsError,
    zio.aws.nimble.model.CreateLaunchProfileResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.createLaunchProfile(request))
  def acceptEulas(request: AcceptEulasRequest): ZIO[
    zio.aws.nimble.Nimble,
    AwsError,
    zio.aws.nimble.model.AcceptEulasResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.acceptEulas(request))
  def getEula(request: GetEulaRequest): ZIO[
    zio.aws.nimble.Nimble,
    AwsError,
    zio.aws.nimble.model.GetEulaResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.getEula(request))
  def getLaunchProfile(request: GetLaunchProfileRequest): ZIO[
    zio.aws.nimble.Nimble,
    AwsError,
    zio.aws.nimble.model.GetLaunchProfileResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.getLaunchProfile(request))
  def listEulaAcceptances(request: ListEulaAcceptancesRequest): ZStream[
    zio.aws.nimble.Nimble,
    AwsError,
    zio.aws.nimble.model.EulaAcceptance.ReadOnly
  ] = ZStream.serviceWithStream(_.listEulaAcceptances(request))
  def listEulaAcceptancesPaginated(request: ListEulaAcceptancesRequest): ZIO[
    zio.aws.nimble.Nimble,
    AwsError,
    zio.aws.nimble.model.ListEulaAcceptancesResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.listEulaAcceptancesPaginated(request))
  def deleteStreamingSession(request: DeleteStreamingSessionRequest): ZIO[
    zio.aws.nimble.Nimble,
    AwsError,
    zio.aws.nimble.model.DeleteStreamingSessionResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.deleteStreamingSession(request))
  def deleteLaunchProfile(request: DeleteLaunchProfileRequest): ZIO[
    zio.aws.nimble.Nimble,
    AwsError,
    zio.aws.nimble.model.DeleteLaunchProfileResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.deleteLaunchProfile(request))
  def getStreamingImage(request: GetStreamingImageRequest): ZIO[
    zio.aws.nimble.Nimble,
    AwsError,
    zio.aws.nimble.model.GetStreamingImageResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.getStreamingImage(request))
  def updateStudioComponent(request: UpdateStudioComponentRequest): ZIO[
    zio.aws.nimble.Nimble,
    AwsError,
    zio.aws.nimble.model.UpdateStudioComponentResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.updateStudioComponent(request))
  def listStudioComponents(request: ListStudioComponentsRequest): ZStream[
    zio.aws.nimble.Nimble,
    AwsError,
    zio.aws.nimble.model.StudioComponent.ReadOnly
  ] = ZStream.serviceWithStream(_.listStudioComponents(request))
  def listStudioComponentsPaginated(request: ListStudioComponentsRequest): ZIO[
    zio.aws.nimble.Nimble,
    AwsError,
    zio.aws.nimble.model.ListStudioComponentsResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.listStudioComponentsPaginated(request))
  def getStudio(
      request: GetStudioRequest
  ): ZIO[zio.aws.nimble.Nimble, AwsError, ReadOnly] =
    ZIO.serviceWithZIO(_.getStudio(request))
  def listStudioMembers(request: ListStudioMembersRequest): ZStream[
    zio.aws.nimble.Nimble,
    AwsError,
    zio.aws.nimble.model.StudioMembership.ReadOnly
  ] = ZStream.serviceWithStream(_.listStudioMembers(request))
  def listStudioMembersPaginated(request: ListStudioMembersRequest): ZIO[
    zio.aws.nimble.Nimble,
    AwsError,
    zio.aws.nimble.model.ListStudioMembersResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.listStudioMembersPaginated(request))
  def listLaunchProfiles(request: ListLaunchProfilesRequest): ZStream[
    zio.aws.nimble.Nimble,
    AwsError,
    zio.aws.nimble.model.LaunchProfile.ReadOnly
  ] = ZStream.serviceWithStream(_.listLaunchProfiles(request))
  def listLaunchProfilesPaginated(request: ListLaunchProfilesRequest): ZIO[
    zio.aws.nimble.Nimble,
    AwsError,
    zio.aws.nimble.model.ListLaunchProfilesResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.listLaunchProfilesPaginated(request))
  def deleteStudioComponent(request: DeleteStudioComponentRequest): ZIO[
    zio.aws.nimble.Nimble,
    AwsError,
    zio.aws.nimble.model.DeleteStudioComponentResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.deleteStudioComponent(request))
  def createStreamingImage(request: CreateStreamingImageRequest): ZIO[
    zio.aws.nimble.Nimble,
    AwsError,
    zio.aws.nimble.model.CreateStreamingImageResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.createStreamingImage(request))
  def getStudioMember(request: GetStudioMemberRequest): ZIO[
    zio.aws.nimble.Nimble,
    AwsError,
    zio.aws.nimble.model.GetStudioMemberResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.getStudioMember(request))
  def updateStreamingImage(request: UpdateStreamingImageRequest): ZIO[
    zio.aws.nimble.Nimble,
    AwsError,
    zio.aws.nimble.model.UpdateStreamingImageResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.updateStreamingImage(request))
  def updateStudio(request: UpdateStudioRequest): ZIO[
    zio.aws.nimble.Nimble,
    AwsError,
    zio.aws.nimble.model.UpdateStudioResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.updateStudio(request))
  def updateLaunchProfileMember(request: UpdateLaunchProfileMemberRequest): ZIO[
    zio.aws.nimble.Nimble,
    AwsError,
    zio.aws.nimble.model.UpdateLaunchProfileMemberResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.updateLaunchProfileMember(request))
  def listStudios(request: ListStudiosRequest): ZStream[
    zio.aws.nimble.Nimble,
    AwsError,
    zio.aws.nimble.model.Studio.ReadOnly
  ] = ZStream.serviceWithStream(_.listStudios(request))
  def listStudiosPaginated(request: ListStudiosRequest): ZIO[
    zio.aws.nimble.Nimble,
    AwsError,
    zio.aws.nimble.model.ListStudiosResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.listStudiosPaginated(request))
  def untagResource(request: UntagResourceRequest): ZIO[
    zio.aws.nimble.Nimble,
    AwsError,
    zio.aws.nimble.model.UntagResourceResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.untagResource(request))
  def listStreamingSessions(request: ListStreamingSessionsRequest): ZStream[
    zio.aws.nimble.Nimble,
    AwsError,
    zio.aws.nimble.model.StreamingSession.ReadOnly
  ] = ZStream.serviceWithStream(_.listStreamingSessions(request))
  def listStreamingSessionsPaginated(
      request: ListStreamingSessionsRequest
  ): ZIO[
    zio.aws.nimble.Nimble,
    AwsError,
    zio.aws.nimble.model.ListStreamingSessionsResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.listStreamingSessionsPaginated(request))
  def listStreamingImages(request: ListStreamingImagesRequest): ZStream[
    zio.aws.nimble.Nimble,
    AwsError,
    zio.aws.nimble.model.StreamingImage.ReadOnly
  ] = ZStream.serviceWithStream(_.listStreamingImages(request))
  def listStreamingImagesPaginated(request: ListStreamingImagesRequest): ZIO[
    zio.aws.nimble.Nimble,
    AwsError,
    zio.aws.nimble.model.ListStreamingImagesResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.listStreamingImagesPaginated(request))
  def putStudioMembers(request: PutStudioMembersRequest): ZIO[
    zio.aws.nimble.Nimble,
    AwsError,
    zio.aws.nimble.model.PutStudioMembersResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.putStudioMembers(request))
  def listEulas(request: ListEulasRequest): ZStream[
    zio.aws.nimble.Nimble,
    AwsError,
    zio.aws.nimble.model.Eula.ReadOnly
  ] = ZStream.serviceWithStream(_.listEulas(request))
  def listEulasPaginated(request: ListEulasRequest): ZIO[
    zio.aws.nimble.Nimble,
    AwsError,
    zio.aws.nimble.model.ListEulasResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.listEulasPaginated(request))
  def startStreamingSession(request: StartStreamingSessionRequest): ZIO[
    zio.aws.nimble.Nimble,
    AwsError,
    zio.aws.nimble.model.StartStreamingSessionResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.startStreamingSession(request))
  def getStreamingSessionStream(request: GetStreamingSessionStreamRequest): ZIO[
    zio.aws.nimble.Nimble,
    AwsError,
    zio.aws.nimble.model.GetStreamingSessionStreamResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.getStreamingSessionStream(request))
  def createStreamingSession(request: CreateStreamingSessionRequest): ZIO[
    zio.aws.nimble.Nimble,
    AwsError,
    zio.aws.nimble.model.CreateStreamingSessionResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.createStreamingSession(request))
  def getStreamingSession(request: GetStreamingSessionRequest): ZIO[
    zio.aws.nimble.Nimble,
    AwsError,
    zio.aws.nimble.model.GetStreamingSessionResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.getStreamingSession(request))
  def listTagsForResource(request: ListTagsForResourceRequest): ZIO[
    zio.aws.nimble.Nimble,
    AwsError,
    zio.aws.nimble.model.ListTagsForResourceResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.listTagsForResource(request))
  def getLaunchProfileInitialization(
      request: GetLaunchProfileInitializationRequest
  ): ZIO[
    zio.aws.nimble.Nimble,
    AwsError,
    zio.aws.nimble.model.GetLaunchProfileInitializationResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.getLaunchProfileInitialization(request))
  def deleteStudio(request: DeleteStudioRequest): ZIO[
    zio.aws.nimble.Nimble,
    AwsError,
    zio.aws.nimble.model.DeleteStudioResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.deleteStudio(request))
  def tagResource(request: TagResourceRequest): ZIO[
    zio.aws.nimble.Nimble,
    AwsError,
    zio.aws.nimble.model.TagResourceResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.tagResource(request))
  def putLaunchProfileMembers(request: PutLaunchProfileMembersRequest): ZIO[
    zio.aws.nimble.Nimble,
    AwsError,
    zio.aws.nimble.model.PutLaunchProfileMembersResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.putLaunchProfileMembers(request))
  def getStudioComponent(request: GetStudioComponentRequest): ZIO[
    zio.aws.nimble.Nimble,
    AwsError,
    zio.aws.nimble.model.GetStudioComponentResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.getStudioComponent(request))
  def getLaunchProfileMember(request: GetLaunchProfileMemberRequest): ZIO[
    zio.aws.nimble.Nimble,
    AwsError,
    zio.aws.nimble.model.GetLaunchProfileMemberResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.getLaunchProfileMember(request))
  def deleteStudioMember(request: DeleteStudioMemberRequest): ZIO[
    zio.aws.nimble.Nimble,
    AwsError,
    zio.aws.nimble.model.DeleteStudioMemberResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.deleteStudioMember(request))
  def createStudioComponent(request: CreateStudioComponentRequest): ZIO[
    zio.aws.nimble.Nimble,
    AwsError,
    zio.aws.nimble.model.CreateStudioComponentResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.createStudioComponent(request))
  def createStreamingSessionStream(
      request: CreateStreamingSessionStreamRequest
  ): ZIO[
    zio.aws.nimble.Nimble,
    AwsError,
    zio.aws.nimble.model.CreateStreamingSessionStreamResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.createStreamingSessionStream(request))
  def startStudioSSOConfigurationRepair(
      request: StartStudioSsoConfigurationRepairRequest
  ): ZIO[
    zio.aws.nimble.Nimble,
    AwsError,
    zio.aws.nimble.model.StartStudioSsoConfigurationRepairResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.startStudioSSOConfigurationRepair(request))
  def deleteLaunchProfileMember(request: DeleteLaunchProfileMemberRequest): ZIO[
    zio.aws.nimble.Nimble,
    AwsError,
    zio.aws.nimble.model.DeleteLaunchProfileMemberResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.deleteLaunchProfileMember(request))
  def getLaunchProfileDetails(request: GetLaunchProfileDetailsRequest): ZIO[
    zio.aws.nimble.Nimble,
    AwsError,
    zio.aws.nimble.model.GetLaunchProfileDetailsResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.getLaunchProfileDetails(request))
  def stopStreamingSession(request: StopStreamingSessionRequest): ZIO[
    zio.aws.nimble.Nimble,
    AwsError,
    zio.aws.nimble.model.StopStreamingSessionResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.stopStreamingSession(request))
}
