package zio.aws.nimble.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters.*
final case class AcceptEulasResponse(
    eulaAcceptances: Option[Iterable[zio.aws.nimble.model.EulaAcceptance]] =
      None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.nimble.model.AcceptEulasResponse = {
    import AcceptEulasResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.nimble.model.AcceptEulasResponse
      .builder()
      .optionallyWith(
        eulaAcceptances.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.eulaAcceptances)
      .build()
  }
  def asReadOnly: zio.aws.nimble.model.AcceptEulasResponse.ReadOnly =
    zio.aws.nimble.model.AcceptEulasResponse.wrap(buildAwsValue())
}
object AcceptEulasResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.nimble.model.AcceptEulasResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.nimble.model.AcceptEulasResponse =
      zio.aws.nimble.model.AcceptEulasResponse(
        eulaAcceptances.map(value =>
          value.map { item =>
            item.asEditable
          }
        )
      )
    def eulaAcceptances
        : Option[List[zio.aws.nimble.model.EulaAcceptance.ReadOnly]]
    def getEulaAcceptances: ZIO[Any, AwsError, List[
      zio.aws.nimble.model.EulaAcceptance.ReadOnly
    ]] = AwsError.unwrapOptionField("eulaAcceptances", eulaAcceptances)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.nimble.model.AcceptEulasResponse
  ) extends zio.aws.nimble.model.AcceptEulasResponse.ReadOnly {
    override val eulaAcceptances
        : Option[List[zio.aws.nimble.model.EulaAcceptance.ReadOnly]] = scala
      .Option(impl.eulaAcceptances())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.nimble.model.EulaAcceptance.wrap(item)
        }.toList
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.nimble.model.AcceptEulasResponse
  ): zio.aws.nimble.model.AcceptEulasResponse.ReadOnly = new Wrapper(impl)
}
