package zio.aws.nimble.model
import zio.aws.nimble.model.primitives.{
  ActiveDirectoryOrganizationalUnitDistinguishedName,
  DirectoryId
}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters.*
final case class ActiveDirectoryConfiguration(
    computerAttributes: Option[
      Iterable[zio.aws.nimble.model.ActiveDirectoryComputerAttribute]
    ] = None,
    directoryId: Option[DirectoryId] = None,
    organizationalUnitDistinguishedName: Option[
      ActiveDirectoryOrganizationalUnitDistinguishedName
    ] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.nimble.model.ActiveDirectoryConfiguration = {
    import ActiveDirectoryConfiguration.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.nimble.model.ActiveDirectoryConfiguration
      .builder()
      .optionallyWith(
        computerAttributes.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.computerAttributes)
      .optionallyWith(
        directoryId.map(value => DirectoryId.unwrap(value): java.lang.String)
      )(_.directoryId)
      .optionallyWith(
        organizationalUnitDistinguishedName.map(value =>
          ActiveDirectoryOrganizationalUnitDistinguishedName.unwrap(
            value
          ): java.lang.String
        )
      )(_.organizationalUnitDistinguishedName)
      .build()
  }
  def asReadOnly: zio.aws.nimble.model.ActiveDirectoryConfiguration.ReadOnly =
    zio.aws.nimble.model.ActiveDirectoryConfiguration.wrap(buildAwsValue())
}
object ActiveDirectoryConfiguration {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.nimble.model.ActiveDirectoryConfiguration
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.nimble.model.ActiveDirectoryConfiguration =
      zio.aws.nimble.model.ActiveDirectoryConfiguration(
        computerAttributes.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        directoryId.map(value => value),
        organizationalUnitDistinguishedName.map(value => value)
      )
    def computerAttributes: Option[
      List[zio.aws.nimble.model.ActiveDirectoryComputerAttribute.ReadOnly]
    ]
    def directoryId: Option[DirectoryId]
    def organizationalUnitDistinguishedName
        : Option[ActiveDirectoryOrganizationalUnitDistinguishedName]
    def getComputerAttributes: ZIO[Any, AwsError, List[
      zio.aws.nimble.model.ActiveDirectoryComputerAttribute.ReadOnly
    ]] = AwsError.unwrapOptionField("computerAttributes", computerAttributes)
    def getDirectoryId: ZIO[Any, AwsError, DirectoryId] =
      AwsError.unwrapOptionField("directoryId", directoryId)
    def getOrganizationalUnitDistinguishedName: ZIO[
      Any,
      AwsError,
      ActiveDirectoryOrganizationalUnitDistinguishedName
    ] = AwsError.unwrapOptionField(
      "organizationalUnitDistinguishedName",
      organizationalUnitDistinguishedName
    )
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.nimble.model.ActiveDirectoryConfiguration
  ) extends zio.aws.nimble.model.ActiveDirectoryConfiguration.ReadOnly {
    override val computerAttributes: Option[
      List[zio.aws.nimble.model.ActiveDirectoryComputerAttribute.ReadOnly]
    ] = scala
      .Option(impl.computerAttributes())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.nimble.model.ActiveDirectoryComputerAttribute.wrap(item)
        }.toList
      )
    override val directoryId: Option[DirectoryId] = scala
      .Option(impl.directoryId())
      .map(value => zio.aws.nimble.model.primitives.DirectoryId(value))
    override val organizationalUnitDistinguishedName
        : Option[ActiveDirectoryOrganizationalUnitDistinguishedName] = scala
      .Option(impl.organizationalUnitDistinguishedName())
      .map(value =>
        zio.aws.nimble.model.primitives
          .ActiveDirectoryOrganizationalUnitDistinguishedName(value)
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.nimble.model.ActiveDirectoryConfiguration
  ): zio.aws.nimble.model.ActiveDirectoryConfiguration.ReadOnly = new Wrapper(
    impl
  )
}
