package zio.aws.nimble.model
import zio.aws.nimble.model.primitives.SyntheticComputeFarmConfigurationString
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters.*
final case class ComputeFarmConfiguration(
    activeDirectoryUser: Option[String] = None,
    endpoint: Option[SyntheticComputeFarmConfigurationString] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.nimble.model.ComputeFarmConfiguration = {
    import ComputeFarmConfiguration.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.nimble.model.ComputeFarmConfiguration
      .builder()
      .optionallyWith(
        activeDirectoryUser.map(value => value: java.lang.String)
      )(_.activeDirectoryUser)
      .optionallyWith(
        endpoint.map(value =>
          SyntheticComputeFarmConfigurationString.unwrap(
            value
          ): java.lang.String
        )
      )(_.endpoint)
      .build()
  }
  def asReadOnly: zio.aws.nimble.model.ComputeFarmConfiguration.ReadOnly =
    zio.aws.nimble.model.ComputeFarmConfiguration.wrap(buildAwsValue())
}
object ComputeFarmConfiguration {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.nimble.model.ComputeFarmConfiguration
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.nimble.model.ComputeFarmConfiguration =
      zio.aws.nimble.model.ComputeFarmConfiguration(
        activeDirectoryUser.map(value => value),
        endpoint.map(value => value)
      )
    def activeDirectoryUser: Option[String]
    def endpoint: Option[SyntheticComputeFarmConfigurationString]
    def getActiveDirectoryUser: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("activeDirectoryUser", activeDirectoryUser)
    def getEndpoint
        : ZIO[Any, AwsError, SyntheticComputeFarmConfigurationString] =
      AwsError.unwrapOptionField("endpoint", endpoint)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.nimble.model.ComputeFarmConfiguration
  ) extends zio.aws.nimble.model.ComputeFarmConfiguration.ReadOnly {
    override val activeDirectoryUser: Option[String] =
      scala.Option(impl.activeDirectoryUser()).map(value => value: String)
    override val endpoint: Option[SyntheticComputeFarmConfigurationString] =
      scala
        .Option(impl.endpoint())
        .map(value =>
          zio.aws.nimble.model.primitives
            .SyntheticComputeFarmConfigurationString(value)
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.nimble.model.ComputeFarmConfiguration
  ): zio.aws.nimble.model.ComputeFarmConfiguration.ReadOnly = new Wrapper(impl)
}
