package zio.aws.nimble.model
import zio.aws.nimble.model.primitives.{
  LaunchProfileName,
  EC2SubnetId,
  LaunchProfileDescription,
  LaunchProfileProtocolVersion,
  ClientToken
}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters.*
final case class CreateLaunchProfileRequest(
    clientToken: Option[ClientToken] = None,
    description: Option[LaunchProfileDescription] = None,
    ec2SubnetIds: Iterable[EC2SubnetId],
    launchProfileProtocolVersions: Iterable[LaunchProfileProtocolVersion],
    name: LaunchProfileName,
    streamConfiguration: zio.aws.nimble.model.StreamConfigurationCreate,
    studioComponentIds: Iterable[String],
    studioId: String,
    tags: Option[Map[String, String]] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.nimble.model.CreateLaunchProfileRequest = {
    import CreateLaunchProfileRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.nimble.model.CreateLaunchProfileRequest
      .builder()
      .optionallyWith(
        clientToken.map(value => ClientToken.unwrap(value): java.lang.String)
      )(_.clientToken)
      .optionallyWith(
        description.map(value =>
          LaunchProfileDescription.unwrap(value): java.lang.String
        )
      )(_.description)
      .ec2SubnetIds(ec2SubnetIds.map { item =>
        EC2SubnetId.unwrap(item): java.lang.String
      }.asJavaCollection)
      .launchProfileProtocolVersions(launchProfileProtocolVersions.map { item =>
        LaunchProfileProtocolVersion.unwrap(item): java.lang.String
      }.asJavaCollection)
      .name(LaunchProfileName.unwrap(name): java.lang.String)
      .streamConfiguration(streamConfiguration.buildAwsValue())
      .studioComponentIds(studioComponentIds.map { item =>
        item: java.lang.String
      }.asJavaCollection)
      .studioId(studioId: java.lang.String)
      .optionallyWith(
        tags.map(value =>
          value
            .map({ case (key, value) =>
              (key: java.lang.String) -> (value: java.lang.String)
            })
            .asJava
        )
      )(_.tags)
      .build()
  }
  def asReadOnly: zio.aws.nimble.model.CreateLaunchProfileRequest.ReadOnly =
    zio.aws.nimble.model.CreateLaunchProfileRequest.wrap(buildAwsValue())
}
object CreateLaunchProfileRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.nimble.model.CreateLaunchProfileRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.nimble.model.CreateLaunchProfileRequest =
      zio.aws.nimble.model.CreateLaunchProfileRequest(
        clientToken.map(value => value),
        description.map(value => value),
        ec2SubnetIds,
        launchProfileProtocolVersions,
        name,
        streamConfiguration.asEditable,
        studioComponentIds,
        studioId,
        tags.map(value => value)
      )
    def clientToken: Option[ClientToken]
    def description: Option[LaunchProfileDescription]
    def ec2SubnetIds: List[EC2SubnetId]
    def launchProfileProtocolVersions: List[LaunchProfileProtocolVersion]
    def name: LaunchProfileName
    def streamConfiguration
        : zio.aws.nimble.model.StreamConfigurationCreate.ReadOnly
    def studioComponentIds: List[String]
    def studioId: String
    def tags: Option[Map[String, String]]
    def getClientToken: ZIO[Any, AwsError, ClientToken] =
      AwsError.unwrapOptionField("clientToken", clientToken)
    def getDescription: ZIO[Any, AwsError, LaunchProfileDescription] =
      AwsError.unwrapOptionField("description", description)
    def getEc2SubnetIds: ZIO[Any, Nothing, List[EC2SubnetId]] =
      ZIO.succeed(ec2SubnetIds)
    def getLaunchProfileProtocolVersions
        : ZIO[Any, Nothing, List[LaunchProfileProtocolVersion]] =
      ZIO.succeed(launchProfileProtocolVersions)
    def getName: ZIO[Any, Nothing, LaunchProfileName] = ZIO.succeed(name)
    def getStreamConfiguration: ZIO[
      Any,
      Nothing,
      zio.aws.nimble.model.StreamConfigurationCreate.ReadOnly
    ] = ZIO.succeed(streamConfiguration)
    def getStudioComponentIds: ZIO[Any, Nothing, List[String]] =
      ZIO.succeed(studioComponentIds)
    def getStudioId: ZIO[Any, Nothing, String] = ZIO.succeed(studioId)
    def getTags: ZIO[Any, AwsError, Map[String, String]] =
      AwsError.unwrapOptionField("tags", tags)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.nimble.model.CreateLaunchProfileRequest
  ) extends zio.aws.nimble.model.CreateLaunchProfileRequest.ReadOnly {
    override val clientToken: Option[ClientToken] = scala
      .Option(impl.clientToken())
      .map(value => zio.aws.nimble.model.primitives.ClientToken(value))
    override val description: Option[LaunchProfileDescription] = scala
      .Option(impl.description())
      .map(value =>
        zio.aws.nimble.model.primitives.LaunchProfileDescription(value)
      )
    override val ec2SubnetIds: List[EC2SubnetId] = impl
      .ec2SubnetIds()
      .asScala
      .map { item =>
        zio.aws.nimble.model.primitives.EC2SubnetId(item)
      }
      .toList
    override val launchProfileProtocolVersions
        : List[LaunchProfileProtocolVersion] = impl
      .launchProfileProtocolVersions()
      .asScala
      .map { item =>
        zio.aws.nimble.model.primitives.LaunchProfileProtocolVersion(item)
      }
      .toList
    override val name: LaunchProfileName =
      zio.aws.nimble.model.primitives.LaunchProfileName(impl.name())
    override val streamConfiguration
        : zio.aws.nimble.model.StreamConfigurationCreate.ReadOnly =
      zio.aws.nimble.model.StreamConfigurationCreate
        .wrap(impl.streamConfiguration())
    override val studioComponentIds: List[String] = impl
      .studioComponentIds()
      .asScala
      .map { item =>
        item: String
      }
      .toList
    override val studioId: String = impl.studioId(): String
    override val tags: Option[Map[String, String]] = scala
      .Option(impl.tags())
      .map(value =>
        value.asScala
          .map({ case (key, value) =>
            (key: String) -> (value: String)
          })
          .toMap
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.nimble.model.CreateLaunchProfileRequest
  ): zio.aws.nimble.model.CreateLaunchProfileRequest.ReadOnly = new Wrapper(
    impl
  )
}
