package zio.aws.nimble.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters.*
final case class DeleteStreamingImageResponse(
    streamingImage: Option[zio.aws.nimble.model.StreamingImage] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.nimble.model.DeleteStreamingImageResponse = {
    import DeleteStreamingImageResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.nimble.model.DeleteStreamingImageResponse
      .builder()
      .optionallyWith(streamingImage.map(value => value.buildAwsValue()))(
        _.streamingImage
      )
      .build()
  }
  def asReadOnly: zio.aws.nimble.model.DeleteStreamingImageResponse.ReadOnly =
    zio.aws.nimble.model.DeleteStreamingImageResponse.wrap(buildAwsValue())
}
object DeleteStreamingImageResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.nimble.model.DeleteStreamingImageResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.nimble.model.DeleteStreamingImageResponse =
      zio.aws.nimble.model.DeleteStreamingImageResponse(
        streamingImage.map(value => value.asEditable)
      )
    def streamingImage: Option[zio.aws.nimble.model.StreamingImage.ReadOnly]
    def getStreamingImage
        : ZIO[Any, AwsError, zio.aws.nimble.model.StreamingImage.ReadOnly] =
      AwsError.unwrapOptionField("streamingImage", streamingImage)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.nimble.model.DeleteStreamingImageResponse
  ) extends zio.aws.nimble.model.DeleteStreamingImageResponse.ReadOnly {
    override val streamingImage
        : Option[zio.aws.nimble.model.StreamingImage.ReadOnly] = scala
      .Option(impl.streamingImage())
      .map(value => zio.aws.nimble.model.StreamingImage.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.nimble.model.DeleteStreamingImageResponse
  ): zio.aws.nimble.model.DeleteStreamingImageResponse.ReadOnly = new Wrapper(
    impl
  )
}
