package zio.aws.nimble.model
import zio.aws.nimble.model.primitives.ClientToken
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters.*
final case class DeleteStudioMemberRequest(
    clientToken: Option[ClientToken] = None,
    principalId: String,
    studioId: String
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.nimble.model.DeleteStudioMemberRequest = {
    import DeleteStudioMemberRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.nimble.model.DeleteStudioMemberRequest
      .builder()
      .optionallyWith(
        clientToken.map(value => ClientToken.unwrap(value): java.lang.String)
      )(_.clientToken)
      .principalId(principalId: java.lang.String)
      .studioId(studioId: java.lang.String)
      .build()
  }
  def asReadOnly: zio.aws.nimble.model.DeleteStudioMemberRequest.ReadOnly =
    zio.aws.nimble.model.DeleteStudioMemberRequest.wrap(buildAwsValue())
}
object DeleteStudioMemberRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.nimble.model.DeleteStudioMemberRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.nimble.model.DeleteStudioMemberRequest =
      zio.aws.nimble.model.DeleteStudioMemberRequest(
        clientToken.map(value => value),
        principalId,
        studioId
      )
    def clientToken: Option[ClientToken]
    def principalId: String
    def studioId: String
    def getClientToken: ZIO[Any, AwsError, ClientToken] =
      AwsError.unwrapOptionField("clientToken", clientToken)
    def getPrincipalId: ZIO[Any, Nothing, String] = ZIO.succeed(principalId)
    def getStudioId: ZIO[Any, Nothing, String] = ZIO.succeed(studioId)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.nimble.model.DeleteStudioMemberRequest
  ) extends zio.aws.nimble.model.DeleteStudioMemberRequest.ReadOnly {
    override val clientToken: Option[ClientToken] = scala
      .Option(impl.clientToken())
      .map(value => zio.aws.nimble.model.primitives.ClientToken(value))
    override val principalId: String = impl.principalId(): String
    override val studioId: String = impl.studioId(): String
  }
  def wrap(
      impl: software.amazon.awssdk.services.nimble.model.DeleteStudioMemberRequest
  ): zio.aws.nimble.model.DeleteStudioMemberRequest.ReadOnly = new Wrapper(impl)
}
