package zio.aws.nimble.model
import zio.aws.nimble.model.primitives.ClientToken
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters.*
final case class DeleteStudioRequest(
    clientToken: Option[ClientToken] = None,
    studioId: String
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.nimble.model.DeleteStudioRequest = {
    import DeleteStudioRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.nimble.model.DeleteStudioRequest
      .builder()
      .optionallyWith(
        clientToken.map(value => ClientToken.unwrap(value): java.lang.String)
      )(_.clientToken)
      .studioId(studioId: java.lang.String)
      .build()
  }
  def asReadOnly: zio.aws.nimble.model.DeleteStudioRequest.ReadOnly =
    zio.aws.nimble.model.DeleteStudioRequest.wrap(buildAwsValue())
}
object DeleteStudioRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.nimble.model.DeleteStudioRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.nimble.model.DeleteStudioRequest =
      zio.aws.nimble.model
        .DeleteStudioRequest(clientToken.map(value => value), studioId)
    def clientToken: Option[ClientToken]
    def studioId: String
    def getClientToken: ZIO[Any, AwsError, ClientToken] =
      AwsError.unwrapOptionField("clientToken", clientToken)
    def getStudioId: ZIO[Any, Nothing, String] = ZIO.succeed(studioId)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.nimble.model.DeleteStudioRequest
  ) extends zio.aws.nimble.model.DeleteStudioRequest.ReadOnly {
    override val clientToken: Option[ClientToken] = scala
      .Option(impl.clientToken())
      .map(value => zio.aws.nimble.model.primitives.ClientToken(value))
    override val studioId: String = impl.studioId(): String
  }
  def wrap(
      impl: software.amazon.awssdk.services.nimble.model.DeleteStudioRequest
  ): zio.aws.nimble.model.DeleteStudioRequest.ReadOnly = new Wrapper(impl)
}
